/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import io.trino.cost.CostComparator;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.cost.TaskCountEstimator;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.DetermineJoinDistributionType;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.iterative.rule.test.RuleBuilder;
import io.trino.sql.planner.iterative.rule.test.RuleTester;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.testing.TestingMetadata;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestDetermineJoinDistributionType {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction MULTIPLY_INTEGER = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final CostComparator COST_COMPARATOR = new CostComparator(1.0, 1.0, 1.0);
    private static final int NODES_COUNT = 4;
    private RuleTester tester;

    @BeforeAll
    public void setUp() {
        this.tester = RuleTester.builder().withNodeCountForStats(4).build();
    }

    @AfterAll
    public void tearDown() {
        this.tester.close();
        this.tester = null;
    }

    @Test
    public void testDetermineDistributionType() {
        this.testDetermineDistributionType(OptimizerConfig.JoinDistributionType.PARTITIONED, JoinType.INNER, JoinNode.DistributionType.PARTITIONED);
        this.testDetermineDistributionType(OptimizerConfig.JoinDistributionType.BROADCAST, JoinType.INNER, JoinNode.DistributionType.REPLICATED);
        this.testDetermineDistributionType(OptimizerConfig.JoinDistributionType.AUTOMATIC, JoinType.INNER, JoinNode.DistributionType.PARTITIONED);
    }

    @Test
    public void testDetermineDistributionTypeForLeftOuter() {
        this.testDetermineDistributionType(OptimizerConfig.JoinDistributionType.PARTITIONED, JoinType.LEFT, JoinNode.DistributionType.PARTITIONED);
        this.testDetermineDistributionType(OptimizerConfig.JoinDistributionType.BROADCAST, JoinType.LEFT, JoinNode.DistributionType.REPLICATED);
        this.testDetermineDistributionType(OptimizerConfig.JoinDistributionType.AUTOMATIC, JoinType.LEFT, JoinNode.DistributionType.PARTITIONED);
    }

    private void testDetermineDistributionType(OptimizerConfig.JoinDistributionType sessionDistributedJoin, JoinType joinType, JoinNode.DistributionType expectedDistribution) {
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", sessionDistributedJoin.name()).on(p -> p.join(joinType, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)10L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)11L)))), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)50L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)11L)))), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT)), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(joinType, builder -> builder.equiCriteria("B1", "A1").distributionType(expectedDistribution).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)))));
    }

    @Test
    public void testRepartitionRightOuter() {
        this.testRepartitionRightOuter(OptimizerConfig.JoinDistributionType.PARTITIONED, JoinType.FULL);
        this.testRepartitionRightOuter(OptimizerConfig.JoinDistributionType.PARTITIONED, JoinType.RIGHT);
        this.testRepartitionRightOuter(OptimizerConfig.JoinDistributionType.BROADCAST, JoinType.FULL);
        this.testRepartitionRightOuter(OptimizerConfig.JoinDistributionType.BROADCAST, JoinType.RIGHT);
        this.testRepartitionRightOuter(OptimizerConfig.JoinDistributionType.AUTOMATIC, JoinType.FULL);
        this.testRepartitionRightOuter(OptimizerConfig.JoinDistributionType.AUTOMATIC, JoinType.RIGHT);
    }

    private void testRepartitionRightOuter(OptimizerConfig.JoinDistributionType sessionDistributedJoin, JoinType joinType) {
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", sessionDistributedJoin.name()).on(p -> p.join(joinType, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)10L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)11L)))), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)50L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)11L)))), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT)), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(joinType, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
    }

    @Test
    public void testReplicateScalar() {
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.PARTITIONED.name()).on(p -> p.join(JoinType.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)10L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)11L)))), (PlanNode)p.enforceSingleRow((PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)50L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)11L))))), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT)), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.REPLICATED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.enforceSingleRow(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))))));
    }

    @Test
    public void testReplicateNoEquiCriteria() {
        this.testReplicateNoEquiCriteria(JoinType.INNER);
        this.testReplicateNoEquiCriteria(JoinType.LEFT);
    }

    private void testReplicateNoEquiCriteria(JoinType joinType) {
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.PARTITIONED.name()).on(p -> p.join(joinType, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)10L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)11L)))), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)50L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)11L)))), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT)), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new ArithmeticBinaryExpression(MULTIPLY_INTEGER, ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "A1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "B1")), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)100L))))).matches(PlanMatchPattern.join(joinType, builder -> builder.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new ArithmeticBinaryExpression(MULTIPLY_INTEGER, ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "A1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "B1")), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)100L))).distributionType(JoinNode.DistributionType.REPLICATED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
    }

    @Test
    public void testRetainDistributionType() {
        this.assertDetermineJoinDistributionType().on(p -> p.join(JoinType.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)10L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)11L)))), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)50L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)11L)))), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT)), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), (Map<DynamicFilterId, Symbol>)ImmutableMap.of())).doesNotFire();
    }

    @Test
    public void testFlipAndReplicateWhenOneTableMuchSmaller() {
        VarcharType symbolType = VarcharType.createUnboundedVarcharType();
        int aRows = 100;
        int bRows = 10000;
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> {
            Symbol a1 = p.symbol("A1", (Type)symbolType);
            Symbol b1 = p.symbol("B1", (Type)symbolType);
            return p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("B1", "A1").distributionType(JoinNode.DistributionType.REPLICATED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)))));
    }

    @Test
    public void testFlipAndReplicateWhenOneTableMuchSmallerAndJoinCardinalityUnknown() {
        int aRows = 100;
        int bRows = 10000;
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "A1"), (Object)SymbolStatsEstimate.unknown())).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "B1"), (Object)SymbolStatsEstimate.unknown())).build()).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT)), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("B1", "A1").distributionType(JoinNode.DistributionType.REPLICATED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)))));
    }

    @Test
    public void testPartitionWhenRequiredBySession() {
        VarcharType symbolType = VarcharType.createUnboundedVarcharType();
        int aRows = 100;
        int bRows = 10000;
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.PARTITIONED.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> {
            Symbol a1 = p.symbol("A1", (Type)symbolType);
            Symbol b1 = p.symbol("B1", (Type)symbolType);
            return p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("B1", "A1").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)))));
    }

    @Test
    public void testPartitionWhenBothTablesEqual() {
        int aRows = 10000;
        int bRows = 10000;
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT)), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
    }

    @Test
    public void testReplicatesWhenRequiredBySession() {
        VarcharType symbolType = VarcharType.createUnboundedVarcharType();
        int aRows = 10000;
        int bRows = 10000;
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.BROADCAST.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> {
            Symbol a1 = p.symbol("A1", (Type)symbolType);
            Symbol b1 = p.symbol("B1", (Type)symbolType);
            return p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.REPLICATED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
    }

    @Test
    public void testPartitionFullOuterJoin() {
        int aRows = 10000;
        int bRows = 10;
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinType.FULL, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT)), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinType.FULL, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
    }

    @Test
    public void testPartitionRightOuterJoin() {
        int aRows = 10000;
        int bRows = 10;
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinType.RIGHT, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT)), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinType.RIGHT, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
    }

    @Test
    public void testReplicateLeftOuterJoin() {
        int aRows = 10000;
        int bRows = 10;
        this.assertDetermineJoinDistributionType(new CostComparator(75.0, 10.0, 15.0)).setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT)), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.REPLICATED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
    }

    @Test
    public void testFlipAndReplicateRightOuterJoin() {
        int aRows = 10;
        int bRows = 1000000;
        this.assertDetermineJoinDistributionType(new CostComparator(75.0, 10.0, 15.0)).setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinType.RIGHT, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT)), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.REPLICATED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
    }

    @Test
    public void testFlipAndReplicateRightOuterJoinWhenJoinCardinalityUnknown() {
        int aRows = 10;
        int bRows = 1000000;
        this.assertDetermineJoinDistributionType(new CostComparator(75.0, 10.0, 15.0)).setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "A1"), (Object)SymbolStatsEstimate.unknown())).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "B1"), (Object)SymbolStatsEstimate.unknown())).build()).on(p -> p.join(JoinType.RIGHT, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT)), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.REPLICATED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
    }

    @Test
    public void testReplicatesWhenNotRestricted() {
        VarcharType symbolType = VarcharType.createUnboundedVarcharType();
        int aRows = 10000;
        int bRows = 10;
        PlanNodeStatsEstimate probeSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 10.0))).build();
        PlanNodeStatsEstimate buildSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 10.0))).build();
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", probeSideStatsEstimate).overrideStats("valuesB", buildSideStatsEstimate).on(p -> {
            Symbol a1 = p.symbol("A1", (Type)symbolType);
            Symbol b1 = p.symbol("B1", (Type)symbolType);
            return p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.REPLICATED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
        probeSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        buildSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", probeSideStatsEstimate).overrideStats("valuesB", buildSideStatsEstimate).on(p -> {
            Symbol a1 = p.symbol("A1", (Type)symbolType);
            Symbol b1 = p.symbol("B1", (Type)symbolType);
            return p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
    }

    @Test
    public void testReplicatesWhenSourceIsSmall() {
        VarcharType symbolType = VarcharType.createUnboundedVarcharType();
        int aRows = 10000;
        int bRows = 10;
        PlanNodeStatsEstimate aStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        PlanNodeStatsEstimate bStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        PlanNodeStatsEstimate bSourceStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 64.0, 10.0))).build();
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", aStatsEstimate).overrideStats("filterB", bStatsEstimate).overrideStats("valuesB", bSourceStatsEstimate).on(p -> {
            Symbol a1 = p.symbol("A1", (Type)symbolType);
            Symbol b1 = p.symbol("B1", (Type)symbolType);
            return p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.filter(new PlanNodeId("filterB"), (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.REPLICATED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))))));
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", aStatsEstimate).overrideStats("filterB", bStatsEstimate).overrideStats("valuesB", bSourceStatsEstimate).on(p -> {
            Symbol a1 = p.symbol("A1", (Type)symbolType);
            Symbol b1 = p.symbol("B1", (Type)symbolType);
            return p.join(JoinType.INNER, (PlanNode)p.filter(new PlanNodeId("filterB"), (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1)), (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(b1, a1)), (List<Symbol>)ImmutableList.of((Object)b1), (List<Symbol>)ImmutableList.of((Object)a1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.REPLICATED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))))));
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", PlanNodeStatsEstimate.unknown()).overrideStats("filterB", PlanNodeStatsEstimate.unknown()).overrideStats("valuesB", bSourceStatsEstimate).on(p -> {
            Symbol a1 = p.symbol("A1", (Type)symbolType);
            Symbol b1 = p.symbol("B1", (Type)symbolType);
            return p.join(JoinType.LEFT, (PlanNode)p.filter(new PlanNodeId("filterB"), (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1)), (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(b1, a1)), (List<Symbol>)ImmutableList.of((Object)b1), (List<Symbol>)ImmutableList.of((Object)a1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.RIGHT, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))))));
    }

    @Test
    public void testFlipWhenSizeDifferenceLarge() {
        VarcharType symbolType = VarcharType.createUnboundedVarcharType();
        int aRows = 10000;
        int bRows = 1000;
        PlanNodeStatsEstimate aStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        PlanNodeStatsEstimate bStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", aStatsEstimate).overrideStats("valuesB", bStatsEstimate).overrideStats("filterB", PlanNodeStatsEstimate.unknown()).on(p -> {
            Symbol a1 = p.symbol("A1", (Type)symbolType);
            Symbol b1 = p.symbol("B1", (Type)symbolType);
            return p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.filter(new PlanNodeId("filterB"), (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))))));
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", aStatsEstimate).overrideStats("valuesB", bStatsEstimate).overrideStats("filterB", PlanNodeStatsEstimate.unknown()).on(p -> {
            Symbol a1 = p.symbol("A1", (Type)symbolType);
            Symbol b1 = p.symbol("B1", (Type)symbolType);
            return p.join(JoinType.INNER, (PlanNode)p.filter(new PlanNodeId("filterB"), (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1)), (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(b1, a1)), (List<Symbol>)ImmutableList.of((Object)b1), (List<Symbol>)ImmutableList.of((Object)a1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))))));
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", aStatsEstimate).overrideStats("valuesB", bStatsEstimate).overrideStats("filterB", PlanNodeStatsEstimate.unknown()).on(p -> {
            Symbol a1 = p.symbol("A1", (Type)symbolType);
            Symbol b1 = p.symbol("B1", (Type)symbolType);
            return p.join(JoinType.INNER, (PlanNode)p.filter(new PlanNodeId("filterB"), (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1)), (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.of((Object)b1), (List<Symbol>)ImmutableList.of((Object)a1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.distributionType(JoinNode.DistributionType.REPLICATED).left(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)))));
        bStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", aStatsEstimate).overrideStats("valuesB", bStatsEstimate).overrideStats("filterB", PlanNodeStatsEstimate.unknown()).on(p -> {
            Symbol a1 = p.symbol("A1", (Type)symbolType);
            Symbol b1 = p.symbol("B1", (Type)symbolType);
            return p.join(JoinType.INNER, (PlanNode)p.filter(new PlanNodeId("filterB"), (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.values(new PlanNodeId("valuesB"), aRows, b1)), (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(b1, a1)), (List<Symbol>)ImmutableList.of((Object)b1), (List<Symbol>)ImmutableList.of((Object)a1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("B1", "A1").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)))));
    }

    @Test
    public void testGetSourceTablesSizeInBytes() {
        PlanBuilder planBuilder = new PlanBuilder(new PlanNodeIdAllocator(), this.tester.getPlannerContext(), this.tester.getSession());
        Symbol symbol = planBuilder.symbol("col");
        Symbol sourceSymbol1 = planBuilder.symbol("source1");
        Symbol sourceSymbol2 = planBuilder.symbol("soruce2");
        Assertions.assertThat((double)DetermineJoinDistributionType.getSourceTablesSizeInBytes((PlanNode)planBuilder.values(symbol), (Lookup)Lookup.noLookup(), node -> PlanNodeStatsEstimate.unknown())).isNaN();
        PlanNodeStatsEstimate sourceStatsEstimate1 = PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).build();
        PlanNodeStatsEstimate sourceStatsEstimate2 = PlanNodeStatsEstimate.builder().setOutputRowCount(20.0).build();
        Assertions.assertThat((double)DetermineJoinDistributionType.getSourceTablesSizeInBytes((PlanNode)planBuilder.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)symbol, (Object)sourceSymbol1).put((Object)symbol, (Object)sourceSymbol2).build(), (List<PlanNode>)ImmutableList.of((Object)planBuilder.tableScan((List<Symbol>)ImmutableList.of((Object)sourceSymbol1), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)sourceSymbol1, (Object)new TestingMetadata.TestingColumnHandle("col"))), (Object)planBuilder.values(new PlanNodeId("valuesNode"), sourceSymbol2))), (Lookup)Lookup.noLookup(), node -> {
            if (node instanceof TableScanNode) {
                return sourceStatsEstimate1;
            }
            if (node instanceof ValuesNode) {
                return sourceStatsEstimate2;
            }
            return PlanNodeStatsEstimate.unknown();
        })).isEqualTo(270.0);
        Assertions.assertThat((double)DetermineJoinDistributionType.getSourceTablesSizeInBytes((PlanNode)planBuilder.join(JoinType.INNER, (PlanNode)planBuilder.values(sourceSymbol1), (PlanNode)planBuilder.values(sourceSymbol2), new JoinNode.EquiJoinClause[0]), (Lookup)Lookup.noLookup(), node -> sourceStatsEstimate1)).isNaN();
        Assertions.assertThat((double)DetermineJoinDistributionType.getSourceTablesSizeInBytes((PlanNode)planBuilder.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(sourceSymbol1, (List)ImmutableList.of((Object)sourceSymbol1))), (PlanNode)planBuilder.values(sourceSymbol1)), (Lookup)Lookup.noLookup(), node -> sourceStatsEstimate1)).isNaN();
    }

    @Test
    public void testGetApproximateSourceSizeInBytes() {
        PlanBuilder planBuilder = new PlanBuilder(new PlanNodeIdAllocator(), this.tester.getPlannerContext(), this.tester.getSession());
        Symbol symbol = planBuilder.symbol("col");
        Symbol sourceSymbol1 = planBuilder.symbol("source1");
        Symbol sourceSymbol2 = planBuilder.symbol("source2");
        Assertions.assertThat((double)DetermineJoinDistributionType.getFirstKnownOutputSizeInBytes((PlanNode)planBuilder.values(symbol), (Lookup)Lookup.noLookup(), node -> PlanNodeStatsEstimate.unknown())).isNaN();
        PlanNodeStatsEstimate sourceStatsEstimate1 = PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).build();
        PlanNodeStatsEstimate sourceStatsEstimate2 = PlanNodeStatsEstimate.builder().setOutputRowCount(2000.0).build();
        PlanNodeStatsEstimate filterStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount(250.0).build();
        PlanNodeStatsEstimate limitStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount(20.0).build();
        double sourceRowCount = sourceStatsEstimate1.getOutputRowCount() + sourceStatsEstimate2.getOutputRowCount();
        double unionInputRowCount = filterStatsEstimate.getOutputRowCount() + limitStatsEstimate.getOutputRowCount();
        double sourceSizeInBytes = sourceRowCount + sourceRowCount * (double)BigintType.BIGINT.getFixedSize();
        Assertions.assertThat((double)DetermineJoinDistributionType.getFirstKnownOutputSizeInBytes((PlanNode)planBuilder.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)symbol, (Object)sourceSymbol1).put((Object)symbol, (Object)sourceSymbol2).build(), (List<PlanNode>)ImmutableList.of((Object)planBuilder.filter((Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)planBuilder.tableScan((List<Symbol>)ImmutableList.of((Object)sourceSymbol1), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)sourceSymbol1, (Object)new TestingMetadata.TestingColumnHandle("col")))), (Object)planBuilder.limit(20L, (PlanNode)planBuilder.values(sourceSymbol2)))), (Lookup)Lookup.noLookup(), node -> {
            if (node instanceof TableScanNode) {
                return sourceStatsEstimate1;
            }
            if (node instanceof FilterNode) {
                return filterStatsEstimate;
            }
            if (node instanceof ValuesNode) {
                return sourceStatsEstimate2;
            }
            if (node instanceof LimitNode) {
                return limitStatsEstimate;
            }
            return PlanNodeStatsEstimate.unknown();
        })).isEqualTo(unionInputRowCount / sourceRowCount * sourceSizeInBytes);
        Assertions.assertThat((double)DetermineJoinDistributionType.getFirstKnownOutputSizeInBytes((PlanNode)planBuilder.join(JoinType.INNER, (PlanNode)planBuilder.values(sourceSymbol1), (PlanNode)planBuilder.values(sourceSymbol2), new JoinNode.EquiJoinClause[0]), (Lookup)Lookup.noLookup(), node -> sourceStatsEstimate1)).isEqualTo(sourceStatsEstimate1.getOutputRowCount() * 2.0 * (double)(BigintType.BIGINT.getFixedSize() + 1));
        Assertions.assertThat((double)DetermineJoinDistributionType.getFirstKnownOutputSizeInBytes((PlanNode)planBuilder.join(JoinType.INNER, (PlanNode)planBuilder.tableScan((List<Symbol>)ImmutableList.of((Object)sourceSymbol1), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)sourceSymbol1, (Object)new TestingMetadata.TestingColumnHandle("col"))), (PlanNode)planBuilder.values(sourceSymbol2), new JoinNode.EquiJoinClause[0]), (Lookup)Lookup.noLookup(), node -> {
            if (node instanceof TableScanNode) {
                return sourceStatsEstimate1;
            }
            if (node instanceof ValuesNode) {
                return sourceStatsEstimate2;
            }
            return PlanNodeStatsEstimate.unknown();
        })).isNaN();
        Assertions.assertThat((double)DetermineJoinDistributionType.getFirstKnownOutputSizeInBytes((PlanNode)planBuilder.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)symbol, (Object)sourceSymbol1).put((Object)symbol, (Object)sourceSymbol2).build(), (List<PlanNode>)ImmutableList.of((Object)planBuilder.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(sourceSymbol1, (List)ImmutableList.of((Object)sourceSymbol1))), (PlanNode)planBuilder.values(sourceSymbol1)), (Object)planBuilder.values(sourceSymbol2))), (Lookup)Lookup.noLookup(), node -> {
            if (node instanceof UnnestNode) {
                return sourceStatsEstimate1;
            }
            if (node instanceof ValuesNode) {
                return sourceStatsEstimate2;
            }
            return PlanNodeStatsEstimate.unknown();
        })).isEqualTo(sourceSizeInBytes);
        Assertions.assertThat((double)DetermineJoinDistributionType.getFirstKnownOutputSizeInBytes((PlanNode)planBuilder.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)symbol, (Object)sourceSymbol1).put((Object)symbol, (Object)sourceSymbol2).build(), (List<PlanNode>)ImmutableList.of((Object)planBuilder.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(sourceSymbol1, (List)ImmutableList.of((Object)sourceSymbol1))), (PlanNode)planBuilder.values(sourceSymbol1)), (Object)planBuilder.values(sourceSymbol2))), (Lookup)Lookup.noLookup(), node -> {
            if (node instanceof ValuesNode) {
                return sourceStatsEstimate2;
            }
            return PlanNodeStatsEstimate.unknown();
        })).isNaN();
    }

    private RuleBuilder assertDetermineJoinDistributionType() {
        return this.assertDetermineJoinDistributionType(COST_COMPARATOR);
    }

    private RuleBuilder assertDetermineJoinDistributionType(CostComparator costComparator) {
        return this.tester.assertThat((Rule<?>)new DetermineJoinDistributionType(costComparator, new TaskCountEstimator(() -> 4)));
    }
}

