/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ImplementFilteredAggregations;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestImplementFilteredAggregations
extends BaseRuleTest {
    public TestImplementFilteredAggregations() {
        super(new Plugin[0]);
    }

    @Test
    public void testFilterToMask() {
        this.tester().assertThat((Rule<?>)new ImplementFilteredAggregations()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol g = p.symbol("g");
            Symbol filter = p.symbol("filter", (Type)BooleanType.BOOLEAN);
            return p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)a.toSymbolReference()), filter), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(a, g, filter)));
        }).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("g"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"filter"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), (Object)"g", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "g")), (Object)"filter", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "filter"))), PlanMatchPattern.values("a", "g", "filter")))));
    }

    @Test
    public void testCombineMaskAndFilter() {
        this.tester().assertThat((Rule<?>)new ImplementFilteredAggregations()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol g = p.symbol("g");
            Symbol mask = p.symbol("mask", (Type)BooleanType.BOOLEAN);
            Symbol filter = p.symbol("filter", (Type)BooleanType.BOOLEAN);
            return p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)a.toSymbolReference()), filter), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), mask).source((PlanNode)p.values(a, g, mask, filter)));
        }).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("g"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"new_mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), (Object)"g", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "g")), (Object)"mask", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "mask")), (Object)"filter", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "filter")), (Object)"new_mask", (Object)PlanMatchPattern.expression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "mask"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "filter"))))), PlanMatchPattern.values("a", "g", "mask", "filter")))));
    }

    @Test
    public void testWithFilterPushdown() {
        this.tester().assertThat((Rule<?>)new ImplementFilteredAggregations()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol g = p.symbol("g");
            Symbol filter = p.symbol("filter", (Type)BooleanType.BOOLEAN);
            return p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)a.toSymbolReference()), filter), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(a, g, filter)));
        }).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"filter"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.filter((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "filter"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), (Object)"g", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "g")), (Object)"filter", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "filter"))), PlanMatchPattern.values("a", "g", "filter")))));
    }

    @Test
    public void testWithMultipleAggregations() {
        this.tester().assertThat((Rule<?>)new ImplementFilteredAggregations()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol g = p.symbol("g");
            Symbol filter = p.symbol("filter", (Type)BooleanType.BOOLEAN);
            return p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)a.toSymbolReference()), filter), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("avg"), PlanBuilder.aggregation("avg", (List<Expression>)ImmutableList.of((Object)a.toSymbolReference())), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(a, g, filter)));
        }).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a")), Optional.of("avg"), PlanMatchPattern.aggregationFunction("avg", (List<String>)ImmutableList.of((Object)"a"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"filter"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), (Object)"g", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "g")), (Object)"filter", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "filter"))), PlanMatchPattern.values("a", "g", "filter")))));
    }
}

