/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.RowNumberSymbolMatcher;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ImplementOffset;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.SortItem;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestImplementOffset
extends BaseRuleTest {
    public TestImplementOffset() {
        super(new Plugin[0]);
    }

    @Test
    public void testReplaceOffsetOverValues() {
        this.tester().assertThat((Rule<?>)new ImplementOffset()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.offset(2L, (PlanNode)p.values(a, b));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))), PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "row_num"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.values("a", "b")).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher()))));
    }

    @Test
    public void testReplaceOffsetOverSort() {
        this.tester().assertThat((Rule<?>)new ImplementOffset()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.offset(2L, (PlanNode)p.sort((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))), PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "row_num"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b"))).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher()))));
    }
}

