/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.InlineProjectIntoFilter;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestInlineProjectIntoFilter
extends BaseRuleTest {
    public TestInlineProjectIntoFilter() {
        super(new Plugin[0]);
    }

    @Test
    public void testInlineProjection() {
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter()).on(p -> p.filter((Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (PlanNode)p.values(p.symbol("b", (Type)IntegerType.INTEGER))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)BooleanLiteral.TRUE_LITERAL)), PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"))), PlanMatchPattern.values("b")))));
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter()).on(p -> {
            Symbol a = p.symbol("a", (Type)IntegerType.INTEGER);
            Symbol b = p.symbol("b", (Type)IntegerType.INTEGER);
            Symbol c = p.symbol("c", (Type)IntegerType.INTEGER);
            Symbol d = p.symbol("d", (Type)IntegerType.INTEGER);
            return p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "c")))), (PlanNode)p.project(Assignments.builder().put(a, (Expression)new IsNullPredicate((Expression)new SymbolReference((Type)IntegerType.INTEGER, "d"))).put(b, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b")).put(c, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "c")).build(), (PlanNode)p.values(b, c, d)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)IntegerType.INTEGER, "b")), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)IntegerType.INTEGER, "c")), (Object)"a", (Object)PlanMatchPattern.expression((Expression)BooleanLiteral.TRUE_LITERAL)), PlanMatchPattern.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference((Type)IntegerType.INTEGER, "d")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "c")))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"d", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)IntegerType.INTEGER, "d")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)IntegerType.INTEGER, "b")), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)IntegerType.INTEGER, "c"))), PlanMatchPattern.values("b", "c", "d")))));
    }

    @Test
    public void testNoSimpleConjuncts() {
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter()).on(p -> p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Object)BooleanLiteral.FALSE_LITERAL)), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (PlanNode)p.values(p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void testMultipleReferencesToConjunct() {
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter()).on(p -> p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Object)new SymbolReference((Type)IntegerType.INTEGER, "a"))), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (PlanNode)p.values(p.symbol("b"))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter()).on(p -> p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Object)BooleanLiteral.FALSE_LITERAL)))), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (PlanNode)p.values(p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void testInlineMultiple() {
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter()).on(p -> p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Object)new SymbolReference((Type)IntegerType.INTEGER, "b"))), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "c"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Symbol)p.symbol("b"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "c"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (PlanNode)p.values(p.symbol("c", (Type)IntegerType.INTEGER))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "c"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "c"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"c", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)IntegerType.INTEGER, "c"))), PlanMatchPattern.values("c")))));
    }

    @Test
    public void testInlinePartially() {
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter()).on(p -> p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Object)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Object)new SymbolReference((Type)IntegerType.INTEGER, "b"))), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "c"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Symbol)p.symbol("b"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "c"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (PlanNode)p.values(p.symbol("c", (Type)IntegerType.INTEGER))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)IntegerType.INTEGER, "a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)BooleanLiteral.TRUE_LITERAL)), PlanMatchPattern.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "c"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "c"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)IntegerType.INTEGER, "c"))), PlanMatchPattern.values("c")))));
    }

    @Test
    public void testTrivialProjection() {
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter()).on(p -> p.filter((Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a")), (PlanNode)p.values(p.symbol("a"))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter()).on(p -> p.filter((Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b")), (PlanNode)p.values(p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void testCorrelationSymbol() {
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter()).on(p -> p.filter((Expression)new SymbolReference((Type)IntegerType.INTEGER, "corr"), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (PlanNode)p.values(p.symbol("b"))))).doesNotFire();
    }
}

