/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.InlineProjections;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestInlineProjections
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction SUBTRACT_INTEGER = FUNCTIONS.resolveOperator(OperatorType.SUBTRACT, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction MULTIPLY_INTEGER = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction ADD_DECIMAL_8_4 = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)DecimalType.createDecimalType((int)8, (int)4), (Object)DecimalType.createDecimalType((int)8, (int)4)));
    private static final ResolvedFunction MULTIPLY_DECIMAL_8_4 = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)DecimalType.createDecimalType((int)8, (int)4), (Object)DecimalType.createDecimalType((int)8, (int)4)));
    private static final RowType MSG_TYPE = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)VarcharType.VARCHAR), (Object)new RowType.Field(Optional.of("y"), (Type)VarcharType.VARCHAR)));

    public TestInlineProjections() {
        super(new Plugin[0]);
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule<?>)new InlineProjections()).on(p -> p.project(Assignments.builder().put(p.symbol("identity"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "symbol")).put(p.symbol("multi_complex_1"), (Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "complex"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))).put(p.symbol("multi_complex_2"), (Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "complex"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))).put(p.symbol("multi_literal_1"), (Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "literal"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))).put(p.symbol("multi_literal_2"), (Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "literal"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))).put(p.symbol("single_complex"), (Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "complex_2"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))).put(p.symbol("msg_xx"), (Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "z"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))).put(p.symbol("multi_symbol_reference"), (Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "v"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "v"))).build(), (PlanNode)p.project(Assignments.builder().put(p.symbol("symbol"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "x")).put(p.symbol("complex"), (Expression)new ArithmeticBinaryExpression(MULTIPLY_INTEGER, ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "x"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))).put(p.symbol("literal"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)).put(p.symbol("complex_2"), (Expression)new ArithmeticBinaryExpression(SUBTRACT_INTEGER, ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "x"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))).put(p.symbol("z"), (Expression)new SubscriptExpression((Type)VarcharType.VARCHAR, (Expression)new SymbolReference((Type)MSG_TYPE, "msg"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))).put(p.symbol("v"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "x")).build(), (PlanNode)p.values(p.symbol("x"), p.symbol("msg", (Type)MSG_TYPE))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"out1", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "x"))).put((Object)"out2", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "y"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)))).put((Object)"out3", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "y"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)))).put((Object)"out4", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)))).put((Object)"out5", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)))).put((Object)"out6", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new ArithmeticBinaryExpression(SUBTRACT_INTEGER, ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "x"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)))).put((Object)"out8", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "z"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)))).put((Object)"out10", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "x"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "x")))).buildOrThrow(), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "x")), (Object)"y", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(MULTIPLY_INTEGER, ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "x"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Object)"z", (Object)PlanMatchPattern.expression((Expression)new SubscriptExpression((Type)VarcharType.VARCHAR, (Expression)new SymbolReference((Type)MSG_TYPE, "msg"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)))), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"x", (Object)0, (Object)"msg", (Object)1)))));
    }

    @Test
    public void testInlineEffectivelyLiteral() {
        this.tester().assertThat((Rule<?>)new InlineProjections()).on(p -> p.project(Assignments.builder().put(p.symbol("decimal_multiplication"), (Expression)new ArithmeticBinaryExpression(MULTIPLY_DECIMAL_8_4, ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference((Type)DecimalType.createDecimalType((int)8, (int)4), "decimal_literal"), (Expression)new SymbolReference((Type)DecimalType.createDecimalType((int)8, (int)4), "decimal_literal"))).put(p.symbol("decimal_addition"), (Expression)new ArithmeticBinaryExpression(ADD_DECIMAL_8_4, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)DecimalType.createDecimalType((int)8, (int)4), "decimal_literal"), (Expression)new SymbolReference((Type)DecimalType.createDecimalType((int)8, (int)4), "decimal_literal"))).build(), (PlanNode)p.project(Assignments.builder().put(p.symbol("decimal_literal", (Type)DecimalType.createDecimalType((int)8, (int)4)), (Expression)new Constant((Type)DecimalType.createDecimalType((int)8, (int)4), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("12.5")))).build(), (PlanNode)p.values(p.symbol("x"))))).matches(PlanMatchPattern.project(Map.of("decimal_multiplication", PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(MULTIPLY_DECIMAL_8_4, ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new Constant((Type)DecimalType.createDecimalType((int)8, (int)4), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("12.5"))), (Expression)new Constant((Type)DecimalType.createDecimalType((int)8, (int)4), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("12.5"))))), "decimal_addition", PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ADD_DECIMAL_8_4, ArithmeticBinaryExpression.Operator.ADD, (Expression)new Constant((Type)DecimalType.createDecimalType((int)8, (int)4), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("12.5"))), (Expression)new Constant((Type)DecimalType.createDecimalType((int)8, (int)4), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("12.5")))))), PlanMatchPattern.values(Map.of("x", 0))));
    }

    @Test
    public void testEliminatesIdentityProjection() {
        this.tester().assertThat((Rule<?>)new InlineProjections()).on(p -> p.project(Assignments.builder().put(p.symbol("single_complex", (Type)IntegerType.INTEGER), (Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "complex"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))).build(), (PlanNode)p.project(Assignments.builder().put(p.symbol("complex", (Type)IntegerType.INTEGER), (Expression)new ArithmeticBinaryExpression(SUBTRACT_INTEGER, ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "x"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))).build(), (PlanNode)p.values(p.symbol("x", (Type)IntegerType.INTEGER))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"out1", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new ArithmeticBinaryExpression(SUBTRACT_INTEGER, ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "x"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)))), PlanMatchPattern.values("x")));
    }

    @Test
    public void testIdentityProjections() {
        this.tester().assertThat((Rule<?>)new InlineProjections()).on(p -> p.project(Assignments.of((Symbol)p.symbol("output"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "value")), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("value")}), (PlanNode)p.values(p.symbol("value"))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new InlineProjections()).on(p -> p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("x")}), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("x"), p.symbol("y")}), (PlanNode)p.values(p.symbol("x"), p.symbol("y"))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "x"))), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"x", (Object)0, (Object)"y", (Object)1))));
    }

    @Test
    public void testSubqueryProjections() {
        this.tester().assertThat((Rule<?>)new InlineProjections()).on(p -> p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("fromOuterScope"), p.symbol("value")}), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("value")}), (PlanNode)p.values(p.symbol("value"))))).matches(PlanMatchPattern.project(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"value", (Object)0))));
        this.tester().assertThat((Rule<?>)new InlineProjections()).on(p -> p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("fromOuterScope"), p.symbol("value_1")}), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("value_1"), (Expression)new ArithmeticBinaryExpression(SUBTRACT_INTEGER, ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (PlanNode)p.values(p.symbol("value"))))).matches(PlanMatchPattern.project(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"value", (Object)0))));
    }
}

