/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.BindExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.LambdaExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.iterative.rule.LambdaCaptureDesugaringRewriter;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLambdaCaptureDesugaringRewriter {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));

    @Test
    public void testRewriteBasicLambda() {
        SymbolAllocator allocator = new SymbolAllocator((Collection)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a")));
        Assertions.assertThat((Object)LambdaCaptureDesugaringRewriter.rewrite((Expression)new LambdaExpression((List)ImmutableList.of((Object)new Symbol((Type)IntegerType.INTEGER, "x")), (Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "x"))), (SymbolAllocator)allocator)).isEqualTo((Object)new BindExpression((List)ImmutableList.of((Object)new SymbolReference((Type)IntegerType.INTEGER, "a")), new LambdaExpression((List)ImmutableList.of((Object)new Symbol((Type)IntegerType.INTEGER, "a_0"), (Object)new Symbol((Type)IntegerType.INTEGER, "x")), (Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a_0"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "x")))));
    }
}

