/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.ArithmeticNegation;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.MergeProjectWithValues;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.type.UnknownType;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestMergeProjectWithValues
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction ADD_DOUBLE = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));

    public TestMergeProjectWithValues() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireOnNonRowType() {
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of(), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)new Constant((Type)UnknownType.UNKNOWN, null))), (Type)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT))))))).doesNotFire();
    }

    @Test
    public void testProjectWithoutOutputSymbols() {
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of(), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"x")), (Object)BooleanLiteral.TRUE_LITERAL)), (Object)new Row((List)ImmutableList.of((Object)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"y")), (Object)BooleanLiteral.FALSE_LITERAL)))))).matches(PlanMatchPattern.values(2));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of(), (Object)ImmutableList.of())))).matches(PlanMatchPattern.values(2));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of(), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<List<Expression>>)ImmutableList.of()))).matches(PlanMatchPattern.values(new String[0]));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of()))).matches(PlanMatchPattern.values(new String[0]));
    }

    @Test
    public void testValuesWithoutOutputSymbols() {
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"x")), (Symbol)p.symbol("b"), (Expression)BooleanLiteral.TRUE_LITERAL), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of(), (Object)ImmutableList.of())))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"x")), (Object)BooleanLiteral.TRUE_LITERAL), (Object)ImmutableList.of((Object)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"x")), (Object)BooleanLiteral.TRUE_LITERAL))));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"x")), (Symbol)p.symbol("b"), (Expression)BooleanLiteral.TRUE_LITERAL), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of()))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b"), (List<List<Expression>>)ImmutableList.of()));
    }

    @Test
    public void testNonDeterministicValues() {
        FunctionCall randomFunction = new FunctionCall(this.tester().getMetadata().resolveBuiltinFunction("random", (List)ImmutableList.of()), (List)ImmutableList.of());
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("rand", (Type)DoubleType.DOUBLE), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "rand")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("rand", (Type)DoubleType.DOUBLE)), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)randomFunction)))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"rand"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)randomFunction))));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("output", (Type)DoubleType.DOUBLE), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "value")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("value", (Type)DoubleType.DOUBLE)), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, null))), (Object)new Row((List)ImmutableList.of((Object)randomFunction)), (Object)new Row((List)ImmutableList.of((Object)new ArithmeticNegation((Expression)randomFunction))))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"output"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, null)), (Object)ImmutableList.of((Object)randomFunction), (Object)ImmutableList.of((Object)new ArithmeticNegation((Expression)randomFunction)))));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)new ArithmeticNegation((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "a")), (Symbol)p.symbol("y"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "b")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a", (Type)DoubleType.DOUBLE), (Object)p.symbol("b", (Type)DoubleType.DOUBLE)), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, (Object)1.0), (Object)randomFunction)), (Object)new Row((List)ImmutableList.of((Object)randomFunction, (Object)new Constant((Type)DoubleType.DOUBLE, null))), (Object)new Row((List)ImmutableList.of((Object)new ArithmeticNegation((Expression)randomFunction), (Object)new Constant((Type)DoubleType.DOUBLE, null))))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x", (Object)"y"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new ArithmeticNegation((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0)), (Object)randomFunction), (Object)ImmutableList.of((Object)new ArithmeticNegation((Expression)randomFunction), (Object)new Constant((Type)DoubleType.DOUBLE, null)), (Object)ImmutableList.of((Object)new ArithmeticNegation((Expression)new ArithmeticNegation((Expression)randomFunction)), (Object)new Constant((Type)DoubleType.DOUBLE, null)))));
    }

    @Test
    public void testDoNotFireOnNonDeterministicValues() {
        FunctionCall randomFunction = new FunctionCall(this.tester().getMetadata().resolveBuiltinFunction("random", (List)ImmutableList.of()), (List)ImmutableList.of());
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "rand"), (Symbol)p.symbol("y"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "rand")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("rand")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)randomFunction)))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)new ArithmeticBinaryExpression(ADD_DOUBLE, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "rand"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "rand"))), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("rand")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)randomFunction)))))).doesNotFire();
    }

    @Test
    public void testCorrelation() {
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x", (Type)IntegerType.INTEGER), (Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "corr"))), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a", (Type)IntegerType.INTEGER)), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "corr"))))));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new SymbolReference((Type)BigintType.BIGINT, "corr"))))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new SymbolReference((Type)BigintType.BIGINT, "corr")))));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new SymbolReference((Type)IntegerType.INTEGER, "corr"))))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))));
    }

    @Test
    public void testFailingExpression() {
        FunctionCall failFunction = LogicalPlanner.failFunction((Metadata)this.tester().getMetadata(), (ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, (String)"message");
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)failFunction), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)failFunction))));
    }

    @Test
    public void testMergeProjectWithValues() {
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            Symbol f = p.symbol("f");
            Assignments.Builder assignments = Assignments.builder();
            assignments.putIdentity(a);
            assignments.put(d, (Expression)b.toSymbolReference());
            assignments.put(e, (Expression)new IsNullPredicate((Expression)a.toSymbolReference()));
            assignments.put(f, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
            return p.project(assignments.build(), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)a, (Object)b, (Object)c), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"x")), (Object)BooleanLiteral.TRUE_LITERAL, (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Object)new Row((List)ImmutableList.of((Object)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"y")), (Object)BooleanLiteral.FALSE_LITERAL, (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Object)new Row((List)ImmutableList.of((Object)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"z")), (Object)BooleanLiteral.TRUE_LITERAL, (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L))))));
        }).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"d", (Object)"e", (Object)"f"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"x")), (Object)BooleanLiteral.TRUE_LITERAL, (Object)new IsNullPredicate((Expression)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"x"))), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)ImmutableList.of((Object)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"y")), (Object)BooleanLiteral.FALSE_LITERAL, (Object)new IsNullPredicate((Expression)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"y"))), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)ImmutableList.of((Object)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"z")), (Object)BooleanLiteral.TRUE_LITERAL, (Object)new IsNullPredicate((Expression)new Constant((Type)CharType.createCharType((int)1), (Object)Slices.utf8Slice((String)"z"))), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            Symbol f = p.symbol("f");
            Assignments.Builder assignments = Assignments.builder();
            assignments.putIdentity(a);
            assignments.put(d, (Expression)b.toSymbolReference());
            assignments.put(e, (Expression)new IsNullPredicate((Expression)a.toSymbolReference()));
            assignments.put(f, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
            return p.project(assignments.build(), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)a, (Object)b, (Object)c), (List<List<Expression>>)ImmutableList.of()));
        }).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"d", (Object)"e", (Object)"f"), (List<List<Expression>>)ImmutableList.of()));
    }
}

