/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SetExpressionMatcher;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneApplyCorrelation;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPruneApplyCorrelation
extends BaseRuleTest {
    public TestPruneApplyCorrelation() {
        super(new Plugin[0]);
    }

    @Test
    public void testPruneCorrelationSymbolNotReferencedInSubquery() {
        this.tester().assertThat((Rule<?>)new PruneApplyCorrelation()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol inputSymbol = p.symbol("input_symbol");
            Symbol subquerySymbol = p.symbol("subquery_symbol");
            Symbol inResult = p.symbol("in_result");
            return p.apply((Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.of((Object)inResult, (Object)new ApplyNode.In(a, subquerySymbol)), (List<Symbol>)ImmutableList.of((Object)inputSymbol), (PlanNode)p.values(a, inputSymbol), (PlanNode)p.values(subquerySymbol));
        }).matches(PlanMatchPattern.apply((List<String>)ImmutableList.of(), (Map<String, SetExpressionMatcher>)ImmutableMap.of((Object)"in_result", (Object)PlanMatchPattern.setExpression((ApplyNode.SetExpression)new ApplyNode.In(new Symbol((Type)UnknownType.UNKNOWN, "a"), new Symbol((Type)UnknownType.UNKNOWN, "subquery_symbol")))), PlanMatchPattern.values("a", "input_symbol"), PlanMatchPattern.values("subquery_symbol")));
    }

    @Test
    public void testAllCorrelationSymbolsReferencedInSubquery() {
        this.tester().assertThat((Rule<?>)new PruneApplyCorrelation()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol inputSymbol = p.symbol("input_symbol");
            Symbol subquerySymbol = p.symbol("subquery_symbol");
            Symbol inResult = p.symbol("in_result");
            return p.apply((Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.of((Object)inResult, (Object)new ApplyNode.In(a, subquerySymbol)), (List<Symbol>)ImmutableList.of((Object)inputSymbol), (PlanNode)p.values(a, inputSymbol), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)subquerySymbol.toSymbolReference(), (Expression)inputSymbol.toSymbolReference()), (PlanNode)p.values(subquerySymbol)));
        }).doesNotFire();
    }
}

