/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneDistinctLimitSourceColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPruneDistinctLimitSourceColumns
extends BaseRuleTest {
    public TestPruneDistinctLimitSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testPruneInputColumn() {
        this.tester().assertThat((Rule<?>)new PruneDistinctLimitSourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.distinctLimit(5L, (List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a, b));
        }).matches(PlanMatchPattern.distinctLimit(5L, (List<String>)ImmutableList.of((Object)"a"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))), PlanMatchPattern.values("a", "b"))));
        this.tester().assertThat((Rule<?>)new PruneDistinctLimitSourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol hashSymbol = p.symbol("hash_symbol");
            return p.distinctLimit(5L, (List<Symbol>)ImmutableList.of((Object)a), Optional.of(hashSymbol), (PlanNode)p.values(a, b, hashSymbol));
        }).matches(PlanMatchPattern.distinctLimit(5L, (List<String>)ImmutableList.of((Object)"a"), "hash_symbol", PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), (Object)"hash_symbol", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "hash_symbol"))), PlanMatchPattern.values("a", "b", "hash_symbol"))));
    }

    @Test
    public void allInputsNeeded() {
        this.tester().assertThat((Rule<?>)new PruneDistinctLimitSourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol hashSymbol = p.symbol("hash_symbol");
            return p.distinctLimit(5L, (List<Symbol>)ImmutableList.of((Object)a, (Object)b), Optional.of(hashSymbol), (PlanNode)p.values(a, b, hashSymbol));
        }).doesNotFire();
    }
}

