/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneGroupIdColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPruneGroupIdColumns
extends BaseRuleTest {
    public TestPruneGroupIdColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testPruneAggregationArgument() {
        this.tester().assertThat((Rule<?>)new PruneGroupIdColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol k = p.symbol("k");
            Symbol groupId = p.symbol("group_id");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, k, groupId}), (PlanNode)p.groupId((List<List<Symbol>>)ImmutableList.of((Object)ImmutableList.of((Object)k), (Object)ImmutableList.of((Object)k)), (List<Symbol>)ImmutableList.of((Object)a, (Object)b), groupId, (PlanNode)p.values(a, b, k)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), (Object)"k", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "k")), (Object)"group_id", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)IntegerType.INTEGER, "group_id"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"k"), (Object)ImmutableList.of((Object)"k")), (List<String>)ImmutableList.of((Object)"a"), "group_id", PlanMatchPattern.values("a", "b", "k"))));
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneGroupIdColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol k = p.symbol("k");
            Symbol groupId = p.symbol("group_id");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, k, groupId}), (PlanNode)p.groupId((List<List<Symbol>>)ImmutableList.of((Object)ImmutableList.of((Object)k), (Object)ImmutableList.of((Object)k)), (List<Symbol>)ImmutableList.of((Object)a), groupId, (PlanNode)p.values(a, k)));
        }).doesNotFire();
    }

    @Test
    public void doNotPruneGroupingSymbols() {
        this.tester().assertThat((Rule<?>)new PruneGroupIdColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol k = p.symbol("k");
            Symbol groupId = p.symbol("group_id");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, groupId}), (PlanNode)p.groupId((List<List<Symbol>>)ImmutableList.of((Object)ImmutableList.of((Object)k), (Object)ImmutableList.of((Object)k)), (List<Symbol>)ImmutableList.of((Object)a), groupId, (PlanNode)p.values(a, k)));
        }).doesNotFire();
    }

    @Test
    public void testGroupIdSymbolUnreferenced() {
        this.tester().assertThat((Rule<?>)new PruneGroupIdColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol k = p.symbol("k");
            Symbol groupId = p.symbol("group_id");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, k}), (PlanNode)p.groupId((List<List<Symbol>>)ImmutableList.of((Object)ImmutableList.of((Object)k), (Object)ImmutableList.of((Object)k)), (List<Symbol>)ImmutableList.of((Object)a), groupId, (PlanNode)p.values(a, k)));
        }).doesNotFire();
    }
}

