/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneLimitColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.tree.SortItem;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.junit.jupiter.api.Test;

public class TestPruneLimitColumns
extends BaseRuleTest {
    public TestPruneLimitColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneLimitColumns()).on(p -> this.buildProjectedLimit((PlanBuilder)p, symbol -> symbol.getName().equals("b"))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))), PlanMatchPattern.limit(1L, PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))), PlanMatchPattern.values("a", "b")))));
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneLimitColumns()).on(p -> this.buildProjectedLimit((PlanBuilder)p, (Predicate<Symbol>)Predicates.alwaysTrue())).doesNotFire();
    }

    @Test
    public void testDoNotPruneTiesResolvingSymbols() {
        this.tester().assertThat((Rule<?>)new PruneLimitColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.project(Assignments.of(), (PlanNode)p.limit(1L, (List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.limit(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))), PlanMatchPattern.values("a", "b")))));
    }

    @Test
    public void testDoNotPrunePreSortedInputSymbols() {
        this.tester().assertThat((Rule<?>)new PruneLimitColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            ImmutableList orderBy = ImmutableList.of((Object)a);
            return p.project(Assignments.of(), (PlanNode)p.limit(1L, false, (List<Symbol>)orderBy, (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.limit(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), false, (List<String>)ImmutableList.of((Object)"a"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))), PlanMatchPattern.values("a", "b")))));
    }

    private ProjectNode buildProjectedLimit(PlanBuilder planBuilder, Predicate<Symbol> projectionFilter) {
        Symbol a = planBuilder.symbol("a");
        Symbol b = planBuilder.symbol("b");
        return planBuilder.project(Assignments.identity((Iterable)((Iterable)Stream.of(a, b).filter(projectionFilter).collect(ImmutableSet.toImmutableSet()))), (PlanNode)planBuilder.limit(1L, (PlanNode)planBuilder.values(a, b)));
    }
}

