/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.RowNumberSymbolMatcher;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneRowNumberColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPruneRowNumberColumns
extends BaseRuleTest {
    public TestPruneRowNumberColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testRowNumberSymbolNotReferenced() {
        this.tester().assertThat((Rule<?>)new PruneRowNumberColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.empty(), rowNumber, (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))));
        this.tester().assertThat((Rule<?>)new PruneRowNumberColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)a), Optional.empty(), rowNumber, (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))));
        this.tester().assertThat((Rule<?>)new PruneRowNumberColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.of(5), rowNumber, (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))), PlanMatchPattern.limit(5L, PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a")))));
        this.tester().assertThat((Rule<?>)new PruneRowNumberColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol rowNumber = p.symbol("row_number");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)a), Optional.of(5), rowNumber, (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))), PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of((Object)"a")).maxRowCountPerPartition(Optional.of(5)), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b"))))));
    }

    @Test
    public void testDoNotPrunePartitioningSymbol() {
        this.tester().assertThat((Rule<?>)new PruneRowNumberColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{rowNumber}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)a), Optional.empty(), rowNumber, (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPruneHashSymbol() {
        this.tester().assertThat((Rule<?>)new PruneRowNumberColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            Symbol hash = p.symbol("hash");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, rowNumber}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)a), Optional.empty(), rowNumber, Optional.of(hash), (PlanNode)p.values(a, hash)));
        }).doesNotFire();
    }

    @Test
    public void testSourceSymbolNotReferenced() {
        this.tester().assertThat((Rule<?>)new PruneRowNumberColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{rowNumber}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.empty(), rowNumber, (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"row_number", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "row_number"))), PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a")))).withAlias("row_number", (RvalueMatcher)new RowNumberSymbolMatcher())));
    }

    @Test
    public void testAllSymbolsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneRowNumberColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, rowNumber}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.empty(), rowNumber, (PlanNode)p.values(a)));
        }).doesNotFire();
    }
}

