/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneSortColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.SortItem;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPruneSortColumns
extends BaseRuleTest {
    public TestPruneSortColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoNotPruneOrderingSymbol() {
        this.tester().assertThat((Rule<?>)new PruneSortColumns()).on(p -> {
            Symbol a = p.symbol("a");
            return p.project(Assignments.of(), (PlanNode)p.sort((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    @Test
    public void testNotAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneSortColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a}), (PlanNode)p.sort((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))), PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))), PlanMatchPattern.values("a", "b")))));
    }

    @Test
    public void testAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneSortColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, b}), (PlanNode)p.sort((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a, b)));
        }).doesNotFire();
    }
}

