/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneTableWriterSourceColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.StatisticAggregationsDescriptor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPruneTableWriterSourceColumns
extends BaseRuleTest {
    public TestPruneTableWriterSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneTableWriterSourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.tableWriter((List<Symbol>)ImmutableList.of((Object)a), (List<String>)ImmutableList.of((Object)"column_a"), (PlanNode)p.values(a, b));
        }).matches(PlanMatchPattern.tableWriter((List<String>)ImmutableList.of((Object)"a"), (List<String>)ImmutableList.of((Object)"column_a"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneTableWriterSourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.tableWriter((List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<String>)ImmutableList.of((Object)"column_a", (Object)"column_b"), (PlanNode)p.values(a, b));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPrunePartitioningSchemeSymbols() {
        this.tester().assertThat((Rule<?>)new PruneTableWriterSourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol partition = p.symbol("partition");
            Symbol hash = p.symbol("hash");
            return p.tableWriter((List<Symbol>)ImmutableList.of((Object)a), (List<String>)ImmutableList.of((Object)"column_a"), Optional.of(p.partitioningScheme((List<Symbol>)ImmutableList.of((Object)partition, (Object)hash), (List<Symbol>)ImmutableList.of((Object)partition), hash)), Optional.empty(), Optional.empty(), (PlanNode)p.values(a, partition, hash));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPruneStatisticAggregationSymbols() {
        this.tester().assertThat((Rule<?>)new PruneTableWriterSourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol group = p.symbol("group");
            Symbol argument = p.symbol("argument");
            Symbol aggregation = p.symbol("aggregation");
            return p.tableWriter((List<Symbol>)ImmutableList.of((Object)a), (List<String>)ImmutableList.of((Object)"column_a"), Optional.empty(), Optional.of(p.statisticAggregations((Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of((Object)aggregation, (Object)p.aggregation(PlanBuilder.aggregation("avg", (List<Expression>)ImmutableList.of((Object)new SymbolReference((Type)BigintType.BIGINT, "argument"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)group))), Optional.of(StatisticAggregationsDescriptor.empty()), (PlanNode)p.values(a, group, argument));
        }).doesNotFire();
    }
}

