/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneValuesColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPruneValuesColumns
extends BaseRuleTest {
    public TestPruneValuesColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneValuesColumns()).on(p -> p.project(Assignments.of((Symbol)p.symbol("y"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "x")), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("unused"), (Object)p.symbol("x")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L)))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"y", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)IntegerType.INTEGER, "x"))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)4L))))));
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneValuesColumns()).on(p -> p.project(Assignments.of((Symbol)p.symbol("y"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "x")), (PlanNode)p.values(p.symbol("x")))).doesNotFire();
    }

    @Test
    public void testPruneAllOutputs() {
        this.tester().assertThat((Rule<?>)new PruneValuesColumns()).on(p -> p.project(Assignments.of(), (PlanNode)p.values(5, p.symbol("x")))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.values(5)));
    }

    @Test
    public void testPruneAllOutputsWhenValuesExpressionIsNotRow() {
        this.tester().assertThat((Rule<?>)new PruneValuesColumns()).on(p -> p.project(Assignments.of(), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("x")), (List<Expression>)ImmutableList.of((Object)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT})))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.values(1)));
    }

    @Test
    public void testDoNotPruneWhenValuesExpressionIsNotRow() {
        this.tester().assertThat((Rule<?>)new PruneValuesColumns()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "x")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("x"), (Object)p.symbol("y")), (List<Expression>)ImmutableList.of((Object)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")))), (Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, CharType.createCharType((int)2)})))))).doesNotFire();
    }
}

