/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.rule.PushCastIntoRow;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPushCastIntoRow
extends BaseRuleTest {
    public TestPushCastIntoRow() {
        super(new Plugin[0]);
    }

    @Test
    public void test() {
        this.test((Expression)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT})), (Expression)new Row((List)ImmutableList.of((Object)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)BigintType.BIGINT))));
        this.test((Expression)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")))), (Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR})), (Expression)new Row((List)ImmutableList.of((Object)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)BigintType.BIGINT), (Object)new Cast((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Type)VarcharType.VARCHAR))));
        this.test((Expression)new Cast((Expression)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")))), (Type)RowType.anonymousRow((Type[])new Type[]{SmallintType.SMALLINT, VarcharType.VARCHAR})), (Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR})), (Expression)new Row((List)ImmutableList.of((Object)new Cast((Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)SmallintType.SMALLINT), (Type)BigintType.BIGINT), (Object)new Cast((Expression)new Cast((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Type)VarcharType.VARCHAR), (Type)VarcharType.VARCHAR))));
        this.test((Expression)new Cast((Expression)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")))), (Type)RowType.anonymousRow((Type[])new Type[]{SmallintType.SMALLINT, VarcharType.VARCHAR})), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"x", (Type)BigintType.BIGINT), RowType.field((Type)VarcharType.VARCHAR)})), (Expression)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)SmallintType.SMALLINT), (Object)new Cast((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Type)VarcharType.VARCHAR))), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"x", (Type)BigintType.BIGINT), RowType.field((Type)VarcharType.VARCHAR)})));
        this.test((Expression)new Cast((Expression)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")))), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)SmallintType.SMALLINT), RowType.field((String)"b", (Type)VarcharType.VARCHAR)})), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"x", (Type)BigintType.BIGINT), RowType.field((Type)VarcharType.VARCHAR)})), (Expression)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)SmallintType.SMALLINT), (Object)new Cast((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Type)VarcharType.VARCHAR))), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"x", (Type)BigintType.BIGINT), RowType.field((Type)VarcharType.VARCHAR)})));
        this.test((Expression)new SubscriptExpression((Type)BigintType.BIGINT, (Expression)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT})), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new SubscriptExpression((Type)BigintType.BIGINT, (Expression)new Row((List)ImmutableList.of((Object)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)BigintType.BIGINT))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
        this.test((Expression)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)UnknownType.UNKNOWN, null))), (Type)RowType.anonymousRow((Type[])new Type[]{UnknownType.UNKNOWN})), (Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)UnknownType.UNKNOWN, null))));
    }

    private void test(Expression original, Expression unwrapped) {
        this.tester().assertThat(new PushCastIntoRow().projectExpressionRewrite()).on(p -> p.project(Assignments.builder().put(p.symbol("output"), original).build(), (PlanNode)p.values(new Symbol[0]))).matches(PlanMatchPattern.project(Map.of("output", PlanMatchPattern.expression(unwrapped)), PlanMatchPattern.values(new String[0])));
    }
}

