/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushDownProjectionsFromPatternRecognition;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.rowpattern.AggregatedSetDescriptor;
import io.trino.sql.planner.rowpattern.AggregationValuePointer;
import io.trino.sql.planner.rowpattern.ClassifierValuePointer;
import io.trino.sql.planner.rowpattern.LogicalIndexPointer;
import io.trino.sql.planner.rowpattern.MatchNumberValuePointer;
import io.trino.sql.planner.rowpattern.ValuePointer;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.Test;

public class TestPushDownProjectionsFromPatternRecognition
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction ADD_BIGINT = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final ResolvedFunction MULTIPLY_BIGINT = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final ResolvedFunction CONCAT = FUNCTIONS.resolveFunction("concat", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR}));
    private static final ResolvedFunction MAX_BY = MetadataManager.createTestMetadataManager().resolveBuiltinFunction("max_by", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}));

    public TestPushDownProjectionsFromPatternRecognition() {
        super(new Plugin[0]);
    }

    @Test
    public void testNoAggregations() {
        this.tester().assertThat((Rule<?>)new PushDownProjectionsFromPatternRecognition()).on(p -> p.patternRecognition(builder -> builder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testDoNotPushRuntimeEvaluatedArguments() {
        this.tester().assertThat((Rule<?>)new PushDownProjectionsFromPatternRecognition()).on(p -> p.patternRecognition(builder -> builder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new FunctionCall(MAX_BY, (List)ImmutableList.of((Object)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "match")), (Object)new FunctionCall(CONCAT, (List)ImmutableList.of((Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"x")), (Object)new SymbolReference((Type)VarcharType.VARCHAR, "classifier"))))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (Map<Symbol, ValuePointer>)ImmutableMap.of((Object)new Symbol((Type)VarcharType.VARCHAR, "classifier"), (Object)new ClassifierValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of(), true, true, 0, 0)), (Object)new Symbol((Type)IntegerType.INTEGER, "match"), (Object)new MatchNumberValuePointer())).source((PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testDoNotPushSymbolReferences() {
        this.tester().assertThat((Rule<?>)new PushDownProjectionsFromPatternRecognition()).on(p -> p.patternRecognition(builder -> builder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new FunctionCall(MAX_BY, (List)ImmutableList.of((Object)new SymbolReference((Type)BigintType.BIGINT, "a"), (Object)new SymbolReference((Type)BigintType.BIGINT, "b"))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L))).source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void testPreProjectArguments() {
        ResolvedFunction maxBy = this.tester().getMetadata().resolveBuiltinFunction("max_by", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}));
        this.tester().assertThat((Rule<?>)new PushDownProjectionsFromPatternRecognition()).on(p -> p.patternRecognition(builder -> builder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "agg"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), (Map<Symbol, ValuePointer>)ImmutableMap.of((Object)new Symbol((Type)BigintType.BIGINT, "agg"), (Object)new AggregationValuePointer(maxBy, new AggregatedSetDescriptor((Set)ImmutableSet.of(), true), (List)ImmutableList.of((Object)new ArithmeticBinaryExpression(ADD_BIGINT, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)), (Object)new ArithmeticBinaryExpression(MULTIPLY_BIGINT, ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L))), Optional.empty(), Optional.empty()))).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.patternRecognition(builder -> builder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "agg"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), (Map<String, ValuePointer>)ImmutableMap.of((Object)"agg", (Object)new AggregationValuePointer(maxBy, new AggregatedSetDescriptor((Set)ImmutableSet.of(), true), (List)ImmutableList.of((Object)new SymbolReference((Type)BigintType.BIGINT, "expr_1"), (Object)new SymbolReference((Type)BigintType.BIGINT, "expr_2")), Optional.empty(), Optional.empty()))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_1", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ADD_BIGINT, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Object)"expr_2", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(MULTIPLY_BIGINT, ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L))), (Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))), PlanMatchPattern.values("a", "b"))));
    }
}

