/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.rule.PushInequalityFilterExpressionBelowJoinRuleSet;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestPushInequalityFilterExpressionBelowJoinRuleSet
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_BIGINT = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private PushInequalityFilterExpressionBelowJoinRuleSet ruleSet;

    public TestPushInequalityFilterExpressionBelowJoinRuleSet() {
        super(new Plugin[0]);
    }

    @BeforeAll
    public void setUpBeforeClass() {
        this.ruleSet = new PushInequalityFilterExpressionBelowJoinRuleSet();
    }

    @Test
    public void testExpressionNotPushedDownToLeftJoinSource() {
        this.tester().assertThat(this.ruleSet.pushJoinInequalityFilterExpressionBelowJoinRule()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.join(JoinType.INNER, (PlanNode)p.values(a), (PlanNode)p.values(b), (Expression)TestPushInequalityFilterExpressionBelowJoinRuleSet.comparison(ComparisonExpression.Operator.LESS_THAN, (Expression)this.add(a, 1L), (Expression)b.toSymbolReference()), new JoinNode.EquiJoinClause[0]);
        }).doesNotFire();
    }

    @Test
    public void testJoinFilterExpressionPushedDownToRightJoinSource() {
        this.tester().assertThat(this.ruleSet.pushJoinInequalityFilterExpressionBelowJoinRule()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.join(JoinType.INNER, (PlanNode)p.values(a), (PlanNode)p.values(b), (Expression)TestPushInequalityFilterExpressionBelowJoinRuleSet.comparison(ComparisonExpression.Operator.LESS_THAN, (Expression)this.add(b, 1L), (Expression)a.toSymbolReference()), new JoinNode.EquiJoinClause[0]);
        }).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "expr"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))).left(PlanMatchPattern.values("a")).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ADD_BIGINT, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.values("b")))));
    }

    @Test
    public void testManyJoinFilterExpressionsPushedDownToRightJoinSource() {
        this.tester().assertThat(this.ruleSet.pushJoinInequalityFilterExpressionBelowJoinRule()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.join(JoinType.INNER, (PlanNode)p.values(a), (PlanNode)p.values(b), (Expression)LogicalExpression.and((Expression)TestPushInequalityFilterExpressionBelowJoinRuleSet.comparison(ComparisonExpression.Operator.LESS_THAN, (Expression)this.add(b, 1L), (Expression)a.toSymbolReference()), (Expression)TestPushInequalityFilterExpressionBelowJoinRuleSet.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)this.add(b, 10L), (Expression)a.toSymbolReference())), new JoinNode.EquiJoinClause[0]);
        }).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "expr_less"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "expr_greater"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))))).left(PlanMatchPattern.values("a")).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_less", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ADD_BIGINT, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Object)"expr_greater", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ADD_BIGINT, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L)))), PlanMatchPattern.values("b")))));
    }

    @Test
    public void testOnlyRightJoinFilterExpressionPushedDownToRightJoinSource() {
        this.tester().assertThat(this.ruleSet.pushJoinInequalityFilterExpressionBelowJoinRule()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.join(JoinType.INNER, (PlanNode)p.values(a), (PlanNode)p.values(b), (Expression)TestPushInequalityFilterExpressionBelowJoinRuleSet.comparison(ComparisonExpression.Operator.LESS_THAN, (Expression)this.add(b, 1L), (Expression)this.add(a, 2L)), new JoinNode.EquiJoinClause[0]);
        }).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "expr"), (Expression)new ArithmeticBinaryExpression(ADD_BIGINT, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)))).left(PlanMatchPattern.values("a")).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ADD_BIGINT, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.values("b")))));
    }

    @Test
    public void testParentFilterExpressionNotPushedDownToLeftJoinSource() {
        this.tester().assertThat(this.ruleSet.pushParentInequalityFilterExpressionBelowJoinRule()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.filter((Expression)TestPushInequalityFilterExpressionBelowJoinRuleSet.comparison(ComparisonExpression.Operator.LESS_THAN, (Expression)this.add(a, 1L), (Expression)b.toSymbolReference()), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(a), (PlanNode)p.values(b), new JoinNode.EquiJoinClause[0]));
        }).doesNotFire();
    }

    @Test
    public void testParentFilterExpressionPushedDownToRightJoinSource() {
        this.tester().assertThat(this.ruleSet.pushParentInequalityFilterExpressionBelowJoinRule()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.filter((Expression)TestPushInequalityFilterExpressionBelowJoinRuleSet.comparison(ComparisonExpression.Operator.LESS_THAN, (Expression)this.add(b, 1L), (Expression)a.toSymbolReference()), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(a), (PlanNode)p.values(b), new JoinNode.EquiJoinClause[0]));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "expr"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.values("a")).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ADD_BIGINT, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.values("b")))))));
    }

    @Test
    public void testManyParentFilterExpressionsPushedDownToRightJoinSource() {
        this.tester().assertThat(this.ruleSet.pushParentInequalityFilterExpressionBelowJoinRule()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.filter((Expression)LogicalExpression.and((Expression)TestPushInequalityFilterExpressionBelowJoinRuleSet.comparison(ComparisonExpression.Operator.LESS_THAN, (Expression)this.add(b, 1L), (Expression)a.toSymbolReference()), (Expression)TestPushInequalityFilterExpressionBelowJoinRuleSet.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)this.add(b, 10L), (Expression)a.toSymbolReference())), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(a), (PlanNode)p.values(b), new JoinNode.EquiJoinClause[0]));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "expr_less"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "expr_greater"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a")))), PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.values("a")).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_less", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ADD_BIGINT, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Object)"expr_greater", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ADD_BIGINT, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L)))), PlanMatchPattern.values("b")))))));
    }

    @Test
    public void testOnlyParentFilterExpressionExposedInaJoin() {
        this.tester().assertThat(this.ruleSet.pushParentInequalityFilterExpressionBelowJoinRule()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.filter((Expression)TestPushInequalityFilterExpressionBelowJoinRuleSet.comparison(ComparisonExpression.Operator.LESS_THAN, (Expression)this.add(b, 1L), (Expression)a.toSymbolReference()), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(a), (PlanNode)p.values(b), (Expression)TestPushInequalityFilterExpressionBelowJoinRuleSet.comparison(ComparisonExpression.Operator.LESS_THAN, (Expression)this.add(b, 2L), (Expression)a.toSymbolReference()), new JoinNode.EquiJoinClause[0]));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "parent_expression"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), PlanMatchPattern.join(JoinType.INNER, builder -> builder.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "join_expression"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))).left(PlanMatchPattern.values("a")).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"join_expression", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ADD_BIGINT, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L))), (Object)"parent_expression", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ADD_BIGINT, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.values("b")))).withExactOutputs("a", "b", "parent_expression"))));
    }

    @Test
    public void testNoExpression() {
        this.tester().assertThat(this.ruleSet.pushJoinInequalityFilterExpressionBelowJoinRule()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.join(JoinType.INNER, (PlanNode)p.values(a), (PlanNode)p.values(b), (Expression)TestPushInequalityFilterExpressionBelowJoinRuleSet.comparison(ComparisonExpression.Operator.LESS_THAN, (Expression)a.toSymbolReference(), (Expression)b.toSymbolReference()), new JoinNode.EquiJoinClause[0]);
        }).doesNotFire();
    }

    @Test
    public void testNotSupportedExpression() {
        this.tester().assertThat(this.ruleSet.pushJoinInequalityFilterExpressionBelowJoinRule()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.join(JoinType.INNER, (PlanNode)p.values(a), (PlanNode)p.values(b), (Expression)TestPushInequalityFilterExpressionBelowJoinRuleSet.comparison(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)a.toSymbolReference(), (Expression)b.toSymbolReference()), new JoinNode.EquiJoinClause[0]);
        }).doesNotFire();
    }

    private static ComparisonExpression comparison(ComparisonExpression.Operator operator, Expression left, Expression right) {
        return new ComparisonExpression(operator, left, right);
    }

    private ArithmeticBinaryExpression add(Symbol symbol, long value) {
        return new ArithmeticBinaryExpression(ADD_BIGINT, ArithmeticBinaryExpression.Operator.ADD, (Expression)symbol.toSymbolReference(), (Expression)new Constant((Type)BigintType.BIGINT, (Object)value));
    }
}

