/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.StatsAndCosts;
import io.trino.metadata.AbstractMockMetadata;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.ArithmeticNegation;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanAssert;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.iterative.rule.PushProjectionThroughJoin;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.testing.TestingSession;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPushProjectionThroughJoin {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_BIGINT = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));

    @Test
    public void testPushesProjectionThroughJoin() {
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        PlanBuilder p = new PlanBuilder(idAllocator, TestingPlannerContext.PLANNER_CONTEXT, SessionTestUtils.TEST_SESSION);
        Symbol a0 = p.symbol("a0");
        Symbol a1 = p.symbol("a1");
        Symbol a2 = p.symbol("a2");
        Symbol a3 = p.symbol("a3");
        Symbol b0 = p.symbol("b0");
        Symbol b1 = p.symbol("b1");
        Symbol b2 = p.symbol("b2");
        ProjectNode planNode = p.project(Assignments.of((Symbol)a3, (Expression)new ArithmeticNegation((Expression)a2.toSymbolReference()), (Symbol)b2, (Expression)new ArithmeticNegation((Expression)b1.toSymbolReference())), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.project(Assignments.of((Symbol)a2, (Expression)new ArithmeticNegation((Expression)a0.toSymbolReference()), (Symbol)a1, (Expression)a1.toSymbolReference()), (PlanNode)p.project(Assignments.builder().putIdentity(a0).putIdentity(a1).build(), (PlanNode)p.values(a0, a1))), (PlanNode)p.values(b0, b1), new JoinNode.EquiJoinClause(a1, b1)));
        Session session = TestingSession.testSessionBuilder().build();
        Optional rewritten = PushProjectionThroughJoin.pushProjectionThroughJoin((ProjectNode)planNode, (Lookup)Lookup.noLookup(), (PlanNodeIdAllocator)idAllocator);
        Assertions.assertThat((boolean)rewritten.isPresent()).isTrue();
        PlanAssert.assertPlan(session, AbstractMockMetadata.dummyMetadata(), FunctionManager.createTestingFunctionManager(), node -> PlanNodeStatsEstimate.unknown(), new Plan((PlanNode)rewritten.get(), StatsAndCosts.empty()), Lookup.noLookup(), PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria((List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(aliases -> new JoinNode.EquiJoinClause(new Symbol((Type)UnknownType.UNKNOWN, "a1"), new Symbol((Type)UnknownType.UNKNOWN, "b1")))).left(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a3", (Object)PlanMatchPattern.expression((Expression)new ArithmeticNegation((Expression)new ArithmeticNegation((Expression)new SymbolReference((Type)BigintType.BIGINT, "a0")))), (Object)"a1", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a1"))), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a0", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a0")), (Object)"a1", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a1"))), PlanMatchPattern.values("a0", "a1")))).right(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b2", (Object)PlanMatchPattern.expression((Expression)new ArithmeticNegation((Expression)new SymbolReference((Type)BigintType.BIGINT, "b1"))), (Object)"b1", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "b1"))), PlanMatchPattern.values("b0", "b1")))).withExactOutputs("a3", "b2"));
    }

    @Test
    public void testDoesNotPushStraddlingProjection() {
        PlanBuilder p = new PlanBuilder(new PlanNodeIdAllocator(), TestingPlannerContext.PLANNER_CONTEXT, SessionTestUtils.TEST_SESSION);
        Symbol a = p.symbol("a");
        Symbol b = p.symbol("b");
        Symbol c = p.symbol("c");
        ProjectNode planNode = p.project(Assignments.of((Symbol)c, (Expression)new ArithmeticBinaryExpression(ADD_BIGINT, ArithmeticBinaryExpression.Operator.ADD, (Expression)a.toSymbolReference(), (Expression)b.toSymbolReference())), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(a), (PlanNode)p.values(b), new JoinNode.EquiJoinClause[0]));
        Optional rewritten = PushProjectionThroughJoin.pushProjectionThroughJoin((ProjectNode)planNode, (Lookup)Lookup.noLookup(), (PlanNodeIdAllocator)new PlanNodeIdAllocator());
        Assertions.assertThat((Optional)rewritten).isEmpty();
    }

    @Test
    public void testDoesNotPushProjectionThroughOuterJoin() {
        PlanBuilder p = new PlanBuilder(new PlanNodeIdAllocator(), TestingPlannerContext.PLANNER_CONTEXT, SessionTestUtils.TEST_SESSION);
        Symbol a = p.symbol("a");
        Symbol b = p.symbol("b");
        Symbol c = p.symbol("c");
        ProjectNode planNode = p.project(Assignments.of((Symbol)c, (Expression)new ArithmeticNegation((Expression)a.toSymbolReference())), (PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values(a), (PlanNode)p.values(b), new JoinNode.EquiJoinClause[0]));
        Optional rewritten = PushProjectionThroughJoin.pushProjectionThroughJoin((ProjectNode)planNode, (Lookup)Lookup.noLookup(), (PlanNodeIdAllocator)new PlanNodeIdAllocator());
        Assertions.assertThat((Optional)rewritten).isEmpty();
    }
}

