/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushTopNThroughProject;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.SortItem;
import io.trino.testing.TestingMetadata;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPushTopNThroughProject
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_BIGINT = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final RowType rowType = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("y"), (Type)BigintType.BIGINT)));

    public TestPushTopNThroughProject() {
        super(new Plugin[0]);
    }

    @Test
    public void testPushdownTopNNonIdentityProjection() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughProject()).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            Symbol projectedB = p.symbol("projectedB");
            Symbol b = p.symbol("b");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Symbol)projectedB, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b")), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"projectedA", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), (Object)"projectedB", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))), PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testPushdownTopNNonIdentityProjectionWithExpression() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughProject()).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            Symbol projectedC = p.symbol("projectedC");
            Symbol b = p.symbol("b");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Symbol)projectedC, (Expression)new ArithmeticBinaryExpression(ADD_BIGINT, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"projectedA", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), (Object)"projectedC", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ADD_BIGINT, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b")))), PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testDoNotPushdownTopNThroughIdentityProjection() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughProject()).on(p -> {
            Symbol a = p.symbol("a");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.project(Assignments.of((Symbol)a, (Expression)a.toSymbolReference()), (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPushdownTopNThroughProjectionOverFilterOverTableScan() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughProject()).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), (PlanNode)p.filter((Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of()))));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPushdownTopNThroughProjectionOverTableScan() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughProject()).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of((Object)a), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)a, (Object)new TestingMetadata.TestingColumnHandle("a")))));
        }).doesNotFire();
    }

    @Test
    public void testDoesntPushDownTopNThroughExclusiveDereferences() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughProject()).on(p -> {
            Symbol a = p.symbol("a", (Type)rowType);
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)p.symbol("c")), (PlanNode)p.project(Assignments.builder().put(p.symbol("b"), (Expression)new SubscriptExpression((Type)BigintType.BIGINT, (Expression)a.toSymbolReference(), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))).put(p.symbol("c"), (Expression)new SubscriptExpression((Type)BigintType.BIGINT, (Expression)a.toSymbolReference(), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))).build(), (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    @Test
    public void testPushTopNThroughOverlappingDereferences() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughProject()).on(p -> {
            Symbol a = p.symbol("a", (Type)rowType);
            Symbol d = p.symbol("d");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)d), (PlanNode)p.project(Assignments.builder().put(p.symbol("b"), (Expression)new SubscriptExpression((Type)BigintType.BIGINT, (Expression)a.toSymbolReference(), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))).put(p.symbol("c", (Type)rowType), (Expression)a.toSymbolReference()).putIdentity(d).build(), (PlanNode)p.values(a, d)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression((Expression)new SubscriptExpression((Type)BigintType.BIGINT, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), (Object)"d", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "d"))), PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("d", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "d"))));
    }
}

