/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveRedundantLimit;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ValuesNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestRemoveRedundantLimit
extends BaseRuleTest {
    public TestRemoveRedundantLimit() {
        super(new Plugin[0]);
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantLimit()).on(p -> p.limit(10L, (PlanNode)p.aggregation(builder -> builder.addAggregation(p.symbol("c"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new SymbolReference((Type)BigintType.BIGINT, "foo"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping().source((PlanNode)p.values(p.symbol("foo")))))).matches(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])));
    }

    @Test
    public void testRemoveLimitWithTies() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantLimit()).on(p -> {
            Symbol c = p.symbol("c");
            return p.limit(10L, (List<Symbol>)ImmutableList.of((Object)c), (PlanNode)p.values(5, c));
        }).matches(PlanMatchPattern.values("c"));
    }

    @Test
    public void testForZeroLimit() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantLimit()).on(p -> p.limit(0L, (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)10L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)11L))))))).matches(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of()));
    }

    @Test
    public void testLimitWithPreSortedInputs() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantLimit()).on(p -> p.limit(10L, (List<Symbol>)ImmutableList.of(), true, (List<Symbol>)ImmutableList.of((Object)p.symbol("c")), (PlanNode)p.aggregation(builder -> builder.addAggregation(p.symbol("c"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new SymbolReference((Type)BigintType.BIGINT, "foo"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping().source((PlanNode)p.values(p.symbol("foo")))))).matches(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])));
        this.tester().assertThat((Rule<?>)new RemoveRedundantLimit()).on(p -> p.limit(10L, (List<Symbol>)ImmutableList.of(), true, (List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)10L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)11L))))))).matches(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])));
    }

    @Test
    public void doesNotFire() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantLimit()).on(p -> p.limit(10L, (PlanNode)p.aggregation(builder -> builder.addAggregation(p.symbol("c"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new SymbolReference((Type)BigintType.BIGINT, "foo"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(p.symbol("foo")).source((PlanNode)p.values(20, p.symbol("foo")))))).doesNotFire();
    }
}

