/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveTrivialFilters;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestRemoveTrivialFilters
extends BaseRuleTest {
    public TestRemoveTrivialFilters() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new RemoveTrivialFilters()).on(p -> p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (PlanNode)p.values(new Symbol[0]))).doesNotFire();
    }

    @Test
    public void testRemovesTrueFilter() {
        this.tester().assertThat((Rule<?>)new RemoveTrivialFilters()).on(p -> p.filter((Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.values(new Symbol[0]))).matches(PlanMatchPattern.values(new String[0]));
    }

    @Test
    public void testRemovesFalseFilter() {
        this.tester().assertThat((Rule<?>)new RemoveTrivialFilters()).on(p -> p.filter((Expression)BooleanLiteral.FALSE_LITERAL, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))))).matches(PlanMatchPattern.values("a"));
    }

    @Test
    public void testRemovesNullFilter() {
        this.tester().assertThat((Rule<?>)new RemoveTrivialFilters()).on(p -> p.filter((Expression)new Constant((Type)BooleanType.BOOLEAN, null), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), (List<List<Expression>>)ImmutableList.of()));
    }
}

