/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ReplaceRedundantJoinWithSource;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestReplaceRedundantJoinWithSource
extends BaseRuleTest {
    public TestReplaceRedundantJoinWithSource() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireOnJoinWithEmptySource() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(0, p.symbol("a")), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(0, p.symbol("a")), (PlanNode)p.values(1, new Symbol[0]), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinType.RIGHT, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(0, p.symbol("a")), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinType.FULL, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(0, p.symbol("a")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnJoinWithNoScalarSource() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(10, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(10, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinType.RIGHT, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(10, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinType.FULL, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(10, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testReplaceCrossJoin() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(10, p.symbol("a", (Type)BigintType.BIGINT)), (PlanNode)p.values(1, new Symbol[0]), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), Collections.nCopies(10, ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null)))));
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(10, p.symbol("b", (Type)BigintType.BIGINT)), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b"), Collections.nCopies(10, ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null)))));
    }

    @Test
    public void testReplaceInnerJoinWithFilter() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(10, p.symbol("a", (Type)BigintType.BIGINT)), (PlanNode)p.values(1, new Symbol[0]), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), Collections.nCopies(10, ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null))))));
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(10, p.symbol("b", (Type)BigintType.BIGINT)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b"), Collections.nCopies(10, ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null))))));
    }

    @Test
    public void testReplaceLeftJoin() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(10, p.symbol("a", (Type)BigintType.BIGINT)), (PlanNode)p.values(1, new Symbol[0]), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), Collections.nCopies(10, ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null)))));
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(10, p.symbol("a", (Type)BigintType.BIGINT)), (PlanNode)p.values(1, new Symbol[0]), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), Collections.nCopies(10, ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null)))));
    }

    @Test
    public void testReplaceRightJoin() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinType.RIGHT, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(10, p.symbol("b", (Type)BigintType.BIGINT)), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b"), Collections.nCopies(10, ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null)))));
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinType.RIGHT, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(10, p.symbol("b", (Type)BigintType.BIGINT)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b"), Collections.nCopies(10, ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null)))));
    }

    @Test
    public void testReplaceFullJoin() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinType.FULL, (PlanNode)p.values(10, p.symbol("a", (Type)BigintType.BIGINT)), (PlanNode)p.values(1, new Symbol[0]), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), Collections.nCopies(10, ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null)))));
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinType.FULL, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(10, p.symbol("b", (Type)BigintType.BIGINT)), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b"), Collections.nCopies(10, ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null)))));
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinType.FULL, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(10, p.symbol("b", (Type)BigintType.BIGINT)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b"), Collections.nCopies(10, ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null)))));
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinType.FULL, (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), (PlanNode)p.values(10, p.symbol("a", (Type)BigintType.BIGINT))), (PlanNode)p.values(1, new Symbol[0]), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinType.FULL, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), (PlanNode)p.values(10, p.symbol("a", (Type)BigintType.BIGINT))), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testPruneOutputs() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> {
            Symbol a = p.symbol("a", (Type)BigintType.BIGINT);
            Symbol b = p.symbol("b", (Type)BigintType.BIGINT);
            return p.join(JoinType.LEFT, (PlanNode)p.values(10, a, b), (PlanNode)p.values(1, new Symbol[0]), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.of((Object)a), (List<Symbol>)ImmutableList.of(), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b"), Collections.nCopies(10, ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null), (Object)new Constant((Type)BigintType.BIGINT, null))))));
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.join(JoinType.INNER, (PlanNode)p.values(10, a, b), (PlanNode)p.values(1, new Symbol[0]), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.of((Object)a), (List<Symbol>)ImmutableList.of(), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))), PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b"), Collections.nCopies(10, ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null), (Object)new Constant((Type)BigintType.BIGINT, null)))))));
    }
}

