/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.iterative.rule.SimplifyExpressions;
import io.trino.type.Reals;
import io.trino.type.UnknownType;
import io.trino.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSimplifyExpressions {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction DIVIDE_DOUBLE = FUNCTIONS.resolveOperator(OperatorType.DIVIDE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));
    private static final ResolvedFunction DIVIDE_REAL = FUNCTIONS.resolveOperator(OperatorType.DIVIDE, (List<? extends Type>)ImmutableList.of((Object)RealType.REAL, (Object)RealType.REAL));

    @Test
    public void testPushesDownNegations() {
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X")), (Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X")));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X"))), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X"));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new NotExpression((Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X")))), (Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X")));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new NotExpression((Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X")))), (Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X")));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "Y")));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Expression)new NotExpression((Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"))))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "Y")));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Expression)new NotExpression((Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "Y")))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "Y")));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"), (Object)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Z"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))))))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X")), (Object)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "Y")), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Z"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"), (Object)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Z"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X")), (Object)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "Y")), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Z"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Z"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V")))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X")), (Object)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "Y")), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "Z")), (Object)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "V")))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"))));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"))));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"))));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"))));
    }

    @Test
    public void testExtractCommonPredicates() {
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"))));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"))));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"))), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X"));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"))), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "X"));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"))));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "V"));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "V"));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "C"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"))));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "C"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"))));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "I"), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "C")))))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "I"), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B")))));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Z"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Z"))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Z"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Z"))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Z"))))), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "I")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Z"))))), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "I")));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))))), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "V"));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Z"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Z"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Z"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"))))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Y"), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "Z"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "V"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "X"))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "C"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "D"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "E"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "F"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "C"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "D"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "E"))), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "F"))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "C"))))), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "D"))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "C"))), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "D"))));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "C"))))), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "D"))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "D"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "C"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "D"))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "C"))))), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "D"))), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "E"))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "E"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "C"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "E"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "D"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "E"))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "C"))))), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "D"))), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "E"))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "C"))), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "D"))), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "E"))));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "C"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "D"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "C"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "D"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "C"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "D"))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "C"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "D"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "E"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "F"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "C"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "D"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "E"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "F"))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A1"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A2"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A3"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A4"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A5"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A6"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A7"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A8"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A9"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A10"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A11"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A12"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A13"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A14"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A15"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A16"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A17"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A18"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A19"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A20"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A21"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A22"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A23"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A24"))), (Object[])new Expression[]{new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A25"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A26"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A27"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A28"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A29"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A30"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A31"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A32"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A33"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A34"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A35"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A36"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A37"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A38"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A39"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A40"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A41"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A42"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A43"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A44"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A45"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A46"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A47"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A48"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A49"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A50"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A51"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A52"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A53"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A54"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A55"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A56"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A57"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A58"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A59"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A60")))})), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A1"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A2"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A3"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A4"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A5"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A6"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A7"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A8"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A9"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A10"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A11"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A12"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A13"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A14"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A15"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A16"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A17"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A18"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A19"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A20"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A21"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A22"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A23"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A24"))), (Object[])new Expression[]{new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A25"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A26"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A27"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A28"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A29"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A30"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A31"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A32"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A33"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A34"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A35"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A36"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A37"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A38"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A39"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A40"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A41"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A42"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A43"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A44"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A45"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A46"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A47"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A48"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A49"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A50"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A51"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A52"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A53"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A54"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A55"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A56"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A57"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A58"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A59"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "A60")))})));
    }

    @Test
    public void testMultipleNulls() {
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)BooleanLiteral.FALSE_LITERAL)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B1"))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B1"))));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)BooleanLiteral.TRUE_LITERAL)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B1"))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B1"))));
    }

    @Test
    public void testCastBigintToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)BigintType.BIGINT, (Object)12300000000L), (Type)VarcharType.createVarcharType((int)11)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)11), (Object)Slices.utf8Slice((String)"12300000000")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)BigintType.BIGINT, (Object)-12300000000L), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)50), (Object)Slices.utf8Slice((String)"-12300000000")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)BigintType.BIGINT, (Object)12300000000L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)BigintType.BIGINT, (Object)12300000000L), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)BigintType.BIGINT, (Object)-12300000000L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)BigintType.BIGINT, (Object)-12300000000L), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)BigintType.BIGINT, (Object)12300000000L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"12300000000"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)BigintType.BIGINT, (Object)12300000000L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"12300000000"))));
    }

    @Test
    public void testCastIntegerToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (Type)VarcharType.createVarcharType((int)4)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)4), (Object)Slices.utf8Slice((String)"1234")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)-1234L), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)50), (Object)Slices.utf8Slice((String)"-1234")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1234"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1234"))));
    }

    @Test
    public void testCastSmallintToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)SmallintType.SMALLINT, (Object)1234L), (Type)VarcharType.createVarcharType((int)4)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)4), (Object)Slices.utf8Slice((String)"1234")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)SmallintType.SMALLINT, (Object)-1234L), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)50), (Object)Slices.utf8Slice((String)"-1234")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)SmallintType.SMALLINT, (Object)1234L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)SmallintType.SMALLINT, (Object)1234L), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)SmallintType.SMALLINT, (Object)-1234L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)SmallintType.SMALLINT, (Object)-1234L), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)SmallintType.SMALLINT, (Object)1234L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1234"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)SmallintType.SMALLINT, (Object)1234L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1234"))));
    }

    @Test
    public void testCastTinyintToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)TinyintType.TINYINT, (Object)123L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"123")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)TinyintType.TINYINT, (Object)-123L), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)50), (Object)Slices.utf8Slice((String)"-123")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)TinyintType.TINYINT, (Object)123L), (Type)VarcharType.createVarcharType((int)2)), (Expression)new Cast((Expression)new Constant((Type)TinyintType.TINYINT, (Object)123L), (Type)VarcharType.createVarcharType((int)2)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)TinyintType.TINYINT, (Object)-123L), (Type)VarcharType.createVarcharType((int)2)), (Expression)new Cast((Expression)new Constant((Type)TinyintType.TINYINT, (Object)-123L), (Type)VarcharType.createVarcharType((int)2)));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)TinyintType.TINYINT, (Object)123L), (Type)VarcharType.createVarcharType((int)2)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"123"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)TinyintType.TINYINT, (Object)123L), (Type)VarcharType.createVarcharType((int)2)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"123"))));
    }

    @Test
    public void testCastShortDecimalToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("12.4"))), (Type)VarcharType.createVarcharType((int)4)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)4), (Object)Slices.utf8Slice((String)"12.4")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("-12.4"))), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)50), (Object)Slices.utf8Slice((String)"-12.4")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("12.4"))), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("12.4"))), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("-12.4"))), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("-12.4"))), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("12.4"))), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"12.4"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("12.4"))), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"12.4"))));
    }

    @Test
    public void testCastLongDecimalToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)19, (int)1), (Object)Decimals.valueOf((BigDecimal)new BigDecimal("100000000000000000.1"))), (Type)VarcharType.createVarcharType((int)20)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)20), (Object)Slices.utf8Slice((String)"100000000000000000.1")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)19, (int)1), (Object)Decimals.valueOf((BigDecimal)new BigDecimal("-100000000000000000.1"))), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)50), (Object)Slices.utf8Slice((String)"-100000000000000000.1")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)19, (int)1), (Object)Decimals.valueOf((BigDecimal)new BigDecimal("100000000000000000.1"))), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)19, (int)1), (Object)Decimals.valueOf((BigDecimal)new BigDecimal("100000000000000000.1"))), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)19, (int)1), (Object)Decimals.valueOf((BigDecimal)new BigDecimal("-100000000000000000.1"))), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)19, (int)1), (Object)Decimals.valueOf((BigDecimal)new BigDecimal("-100000000000000000.1"))), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)19, (int)1), (Object)Decimals.valueOf((BigDecimal)new BigDecimal("100000000000000000.1"))), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"100000000000000000.1"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)19, (int)1), (Object)Decimals.valueOf((BigDecimal)new BigDecimal("100000000000000000.1"))), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"100000000000000000.1"))));
    }

    @Test
    public void testCastDoubleToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"0E0")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-0.0), (Type)VarcharType.createVarcharType((int)4)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)4), (Object)Slices.utf8Slice((String)"-0E0")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new ArithmeticBinaryExpression(DIVIDE_DOUBLE, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0)), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"NaN")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)Double.POSITIVE_INFINITY), (Type)VarcharType.createVarcharType((int)8)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)8), (Object)Slices.utf8Slice((String)"Infinity")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1200.0), (Type)VarcharType.createVarcharType((int)5)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)5), (Object)Slices.utf8Slice((String)"1.2E3")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-1200.0), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)50), (Object)Slices.utf8Slice((String)"-1.2E3")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1200.0), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1200.0), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-1200.0), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-1200.0), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)Double.NaN), (Type)VarcharType.createVarcharType((int)2)), (Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)Double.NaN), (Type)VarcharType.createVarcharType((int)2)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)Double.POSITIVE_INFINITY), (Type)VarcharType.createVarcharType((int)7)), (Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)Double.POSITIVE_INFINITY), (Type)VarcharType.createVarcharType((int)7)));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1200.0), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1200.0"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1200.0), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1200.0"))));
    }

    @Test
    public void testCastRealToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)0.0f)), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"0E0")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)-0.0f)), (Type)VarcharType.createVarcharType((int)4)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)4), (Object)Slices.utf8Slice((String)"-0E0")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new ArithmeticBinaryExpression(DIVIDE_REAL, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)0.0f)), (Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)0.0f))), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"NaN")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)Float.POSITIVE_INFINITY)), (Type)VarcharType.createVarcharType((int)8)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)8), (Object)Slices.utf8Slice((String)"Infinity")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)1200.0f)), (Type)VarcharType.createVarcharType((int)5)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)5), (Object)Slices.utf8Slice((String)"1.2E3")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)-1200.0f)), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)50), (Object)Slices.utf8Slice((String)"-1.2E3")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)1200.0f)), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)1200.0f)), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)-1200.0f)), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)-1200.0f)), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)Float.NaN)), (Type)VarcharType.createVarcharType((int)2)), (Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)Float.NaN)), (Type)VarcharType.createVarcharType((int)2)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)Float.POSITIVE_INFINITY)), (Type)VarcharType.createVarcharType((int)7)), (Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)Float.POSITIVE_INFINITY)), (Type)VarcharType.createVarcharType((int)7)));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)1200.0f)), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1200.0"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)1200.0f)), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1200.0"))));
    }

    @Test
    public void testCastDateToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2013-02-02")), (Type)VarcharType.createVarcharType((int)10)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2013-02-02")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2013-02-02")), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)50), (Object)Slices.utf8Slice((String)"2013-02-02")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2013-02-02")), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2013-02-02")), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2013-02-02")), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2013-02-02"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2013-02-02")), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2013-02-02"))));
    }

    private static void assertSimplifies(Expression expression, Expression expected) {
        Expression simplified = TestSimplifyExpressions.normalize(SimplifyExpressions.rewrite((Expression)expression, (Session)SessionTestUtils.TEST_SESSION, (PlannerContext)TestingPlannerContext.PLANNER_CONTEXT));
        Assertions.assertThat((Object)simplified).isEqualTo((Object)TestSimplifyExpressions.normalize(expected));
    }

    @Test
    public void testPushesDownNegationsNumericTypes() {
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I2"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I2"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I2")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I3"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I4"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I2")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I3"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I4")))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new NotExpression((Expression)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I2")))), (Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I3"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I4")))))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I2")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I3"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I4")))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I2")), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B1"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B2"))), (Object)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B3"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B4"))))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I2")), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "B1")), (Object)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "B2")))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B3"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B4"))))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new NotExpression((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2"))))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new NotExpression((Expression)new NotExpression((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2")))))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new NotExpression((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2"))))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new NotExpression((Expression)new NotExpression((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2")))))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I2")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I2")), (Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2"))))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new NotExpression((Expression)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2")))), (Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I2")))))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2"))), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I2")))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2")), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B1"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B2"))), (Object)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B3"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B4"))))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "B1")), (Object)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "B2")))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B3"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B4"))))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I2")))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B1"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "B2"))), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2"))))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2"))), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I2")))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "B1")), (Object)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "B2")))), (Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new SymbolReference((Type)RealType.REAL, "R2"))))))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(IrExpressions.ifExpression((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I2"))), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2")), IrExpressions.ifExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I1"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "I2")), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "D2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)1.0f)))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)RealType.REAL, "R1"), (Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)1.0f)))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)1.0f)), (Expression)new SymbolReference((Type)RealType.REAL, "R2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)1.0f)), (Expression)new SymbolReference((Type)RealType.REAL, "R2"))));
    }

    private static void assertSimplifiesNumericTypes(Expression expression, Expression expected) {
        Expression rewritten = SimplifyExpressions.rewrite((Expression)expression, (Session)SessionTestUtils.TEST_SESSION, (PlannerContext)TestingPlannerContext.PLANNER_CONTEXT);
        Assertions.assertThat((Object)TestSimplifyExpressions.normalize(rewritten)).isEqualTo((Object)TestSimplifyExpressions.normalize(expected));
    }

    private static Expression normalize(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new NormalizeExpressionRewriter(), (Expression)expression);
    }

    private static class NormalizeExpressionRewriter
    extends ExpressionRewriter<Void> {
        private NormalizeExpressionRewriter() {
        }

        public Expression rewriteLogicalExpression(LogicalExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            List predicates = IrUtils.extractPredicates((LogicalExpression.Operator)node.getOperator(), (Expression)node).stream().map(p -> treeRewriter.rewrite(p, (Object)context)).sorted(Comparator.comparing(Expression::toString)).collect(Collectors.toList());
            return IrUtils.logicalExpression((LogicalExpression.Operator)node.getOperator(), predicates);
        }

        public Expression rewriteCast(Cast node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            return new Cast(node.getExpression(), node.getType(), node.isSafe());
        }
    }
}

