/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.NullIfExpression;
import io.trino.sql.ir.SearchedCaseExpression;
import io.trino.sql.ir.SimpleCaseExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.SimplifyFilterPredicate;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestSimplifyFilterPredicate
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));

    public TestSimplifyFilterPredicate() {
        super(new Plugin[0]);
    }

    @Test
    public void testSimplifyIfExpression() {
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter(IrExpressions.ifExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)BooleanLiteral.FALSE_LITERAL), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter(IrExpressions.ifExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Constant((Type)UnknownType.UNKNOWN, null)), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter(IrExpressions.ifExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), (Expression)BooleanLiteral.FALSE_LITERAL, (Expression)BooleanLiteral.TRUE_LITERAL), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a")), (Object)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a")))), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter(IrExpressions.ifExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Expression)BooleanLiteral.TRUE_LITERAL), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a")), (Object)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a")))), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter(IrExpressions.ifExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)BooleanLiteral.TRUE_LITERAL), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter(IrExpressions.ifExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), (Expression)BooleanLiteral.FALSE_LITERAL, (Expression)BooleanLiteral.FALSE_LITERAL), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.FALSE_LITERAL, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter(IrExpressions.ifExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), PlanMatchPattern.values("a", "b")));
        FunctionCall randomFunction = new FunctionCall(this.tester().getMetadata().resolveBuiltinFunction("random", (List)ImmutableList.of()), (List)ImmutableList.of());
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter(IrExpressions.ifExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)randomFunction, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)randomFunction, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter(IrExpressions.ifExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Constant((Type)UnknownType.UNKNOWN, null)), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.FALSE_LITERAL, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter(IrExpressions.ifExpression((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), (Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"))), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter(IrExpressions.ifExpression((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), (Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"))), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a")), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter(IrExpressions.ifExpression((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a")), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.FALSE_LITERAL, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter(IrExpressions.ifExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "b")), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).doesNotFire();
    }

    @Test
    public void testSimplifyNullIfExpression() {
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter((Expression)new NullIfExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "b")), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "b")), (Object)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "b")))))), PlanMatchPattern.values("a", "b")));
    }

    @Test
    public void testSimplifySearchedCaseExpression() {
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)BooleanLiteral.TRUE_LITERAL), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)BooleanLiteral.FALSE_LITERAL), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)BooleanLiteral.TRUE_LITERAL)), Optional.of(BooleanLiteral.FALSE_LITERAL)), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)BooleanLiteral.TRUE_LITERAL), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)BooleanLiteral.TRUE_LITERAL), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)BooleanLiteral.TRUE_LITERAL)), Optional.of(BooleanLiteral.TRUE_LITERAL)), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)BooleanLiteral.FALSE_LITERAL), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)UnknownType.UNKNOWN, null)), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)BooleanLiteral.FALSE_LITERAL)), Optional.of(BooleanLiteral.FALSE_LITERAL)), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.FALSE_LITERAL, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)BooleanLiteral.FALSE_LITERAL), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)UnknownType.UNKNOWN, null)), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)BooleanLiteral.FALSE_LITERAL)), Optional.empty()), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.FALSE_LITERAL, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)BooleanLiteral.FALSE_LITERAL), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)UnknownType.UNKNOWN, null)), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)BooleanLiteral.TRUE_LITERAL)), Optional.of(BooleanLiteral.FALSE_LITERAL)), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))))), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)BooleanLiteral.TRUE_LITERAL), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)UnknownType.UNKNOWN, null)), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)BooleanLiteral.FALSE_LITERAL)), Optional.of(BooleanLiteral.FALSE_LITERAL)), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)BooleanLiteral.FALSE_LITERAL), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)UnknownType.UNKNOWN, null)), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)BooleanLiteral.FALSE_LITERAL)), Optional.of(BooleanLiteral.TRUE_LITERAL)), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))))))), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a")), (Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a")), (Object)new WhenClause((Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"))), Optional.of(new SymbolReference((Type)BooleanType.BOOLEAN, "b"))), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "b"), PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a")), (Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"))), (Object)new WhenClause((Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"))), Optional.empty()), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.FALSE_LITERAL, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a")), (Object)new WhenClause((Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"))), (Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "b"))), Optional.empty()), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "b"), PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a")), (Object)new WhenClause((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "b"), (Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"))), (Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "b"))), Optional.empty()), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "b"), (Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a")))), Optional.of(new SymbolReference((Type)BooleanType.BOOLEAN, "b"))), PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a")), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"))), (Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "b")), (Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "b")))), Optional.empty()), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a")), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a")))), Optional.of(new SymbolReference((Type)BooleanType.BOOLEAN, "b"))), PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a")), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a")))), Optional.of(new SymbolReference((Type)BooleanType.BOOLEAN, "b"))), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).doesNotFire();
    }

    @Test
    public void testSimplifySimpleCaseExpression() {
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter((Expression)new SimpleCaseExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), (List)ImmutableList.of((Object)new WhenClause((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "b"), (Expression)BooleanLiteral.TRUE_LITERAL), (Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)BooleanLiteral.FALSE_LITERAL)), Optional.of(BooleanLiteral.TRUE_LITERAL)), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).doesNotFire();
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter((Expression)new SimpleCaseExpression((Expression)new Constant((Type)UnknownType.UNKNOWN, null), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Expression)BooleanLiteral.TRUE_LITERAL), (Object)new WhenClause((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), (Expression)BooleanLiteral.FALSE_LITERAL)), Optional.of(new SymbolReference((Type)BooleanType.BOOLEAN, "b"))), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "b"), PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter((Expression)new SimpleCaseExpression((Expression)new Constant((Type)UnknownType.UNKNOWN, null), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Expression)BooleanLiteral.TRUE_LITERAL), (Object)new WhenClause((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), (Expression)BooleanLiteral.FALSE_LITERAL)), Optional.empty()), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.FALSE_LITERAL, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter((Expression)new SimpleCaseExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)BooleanLiteral.TRUE_LITERAL), (Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Expression)BooleanLiteral.TRUE_LITERAL)), Optional.of(BooleanLiteral.TRUE_LITERAL)), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter((Expression)new SimpleCaseExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)BooleanLiteral.FALSE_LITERAL), (Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Expression)new Constant((Type)UnknownType.UNKNOWN, null))), Optional.of(BooleanLiteral.FALSE_LITERAL)), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.FALSE_LITERAL, PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate()).on(p -> p.filter((Expression)new SimpleCaseExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a"), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)BooleanLiteral.FALSE_LITERAL), (Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Expression)new Constant((Type)UnknownType.UNKNOWN, null))), Optional.empty()), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.FALSE_LITERAL, PlanMatchPattern.values("a", "b")));
    }
}

