/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedGlobalAggregationWithoutProjection;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestTransformCorrelatedGlobalAggregationWithoutProjection
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction SUBTRACT_INTEGER = FUNCTIONS.resolveOperator(OperatorType.SUBTRACT, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));

    public TestTransformCorrelatedGlobalAggregationWithoutProjection() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireOnPlanWithoutCorrelatedJoinNode() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.values(p.symbol("a"))).doesNotFire();
    }

    @Test
    public void doesNotFireOnCorrelatedWithoutAggregation() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void doesNotFireOnUncorrelated() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of(), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values(p.symbol("b")))).doesNotFire();
    }

    @Test
    public void doesNotFireOnCorrelatedWithNonScalarAggregation() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void doesNotFireOnMultipleProjections() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr_2"), (Expression)new ArithmeticBinaryExpression(SUBTRACT_INTEGER, ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "expr"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr"), (Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "sum"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping()))))).doesNotFire();
    }

    @Test
    public void rewritesOnSubqueryWithoutProjection() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping()))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"sum_1", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "sum_1")), (Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "corr"))), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"sum_1", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.join(JoinType.LEFT, builder -> builder.left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"corr", (Object)0)))).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression((Expression)BooleanLiteral.TRUE_LITERAL)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0, (Object)"b", (Object)1))))))));
    }

    @Test
    public void rewritesOnSubqueryWithProjection() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr"), (Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "sum"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping())))).doesNotFire();
    }

    @Test
    public void testSubqueryWithCount() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("count_rows"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).addAggregation(p.symbol("count_non_null_values"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new SymbolReference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping()))).matches(PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"count_rows", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of()), (Object)"count_non_null_values", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.join(JoinType.LEFT, builder -> builder.left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"corr", (Object)0)))).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression((Expression)BooleanLiteral.TRUE_LITERAL)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0, (Object)"b", (Object)1))))))));
    }

    @Test
    public void rewritesOnSubqueryWithDistinct() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(outerBuilder -> outerBuilder.addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("count"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).globalGrouping().source((PlanNode)p.aggregation(innerBuilder -> innerBuilder.singleGroupingSet(p.symbol("a")).source((PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "corr")), (PlanNode)p.values(p.symbol("a"), p.symbol("b"))))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "corr")), (Object)"sum_agg", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "sum_agg")), (Object)"count_agg", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "count_agg"))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum_agg"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a")), Optional.of("count_agg"), PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"non_null"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique", "non_null", "a"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.LEFT, builder -> builder.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "corr"))).left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression((Expression)BooleanLiteral.TRUE_LITERAL)), PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values("a", "b")))))))));
    }

    @Test
    public void rewritesOnSubqueryWithDecorrelatableDistinct() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(outerBuilder -> outerBuilder.addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("count"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).globalGrouping().source((PlanNode)p.aggregation(innerBuilder -> innerBuilder.singleGroupingSet(p.symbol("a")).source((PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "corr")), (PlanNode)p.values(p.symbol("a"), p.symbol("b"))))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "corr")), (Object)"sum_agg", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "sum_agg")), (Object)"count_agg", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "count_agg"))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum_agg"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a")), Optional.of("count_agg"), PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"non_null"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.LEFT, builder -> builder.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "corr"))).left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression((Expression)BooleanLiteral.TRUE_LITERAL)), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("a", "b"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values("a", "b")))))))));
    }

    @Test
    public void testWithPreexistingMask() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("mask", (Type)BooleanType.BOOLEAN))).addAggregation(p.symbol("count_non_null_values"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new SymbolReference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), p.symbol("mask", (Type)BooleanType.BOOLEAN)).globalGrouping()))).matches(PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("count_non_null_values"), PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of((Object)"a"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"new_mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"new_mask", (Object)PlanMatchPattern.expression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "mask"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "non_null"))))), PlanMatchPattern.join(JoinType.LEFT, builder -> builder.left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"corr", (Object)0)))).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression((Expression)BooleanLiteral.TRUE_LITERAL)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0, (Object)"mask", (Object)1)))))))));
    }
}

