/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.CoalesceExpression;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformExistsApplyToCorrelatedJoin;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestTransformExistsApplyToCorrelatedJoin
extends BaseRuleTest {
    public TestTransformExistsApplyToCorrelatedJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new TransformExistsApplyToCorrelatedJoin(this.tester().getPlannerContext())).on(p -> p.values(p.symbol("a"))).doesNotFire();
        this.tester().assertThat((Rule<?>)new TransformExistsApplyToCorrelatedJoin(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void testRewrite() {
        this.tester().assertThat((Rule<?>)new TransformExistsApplyToCorrelatedJoin(this.tester().getPlannerContext())).on(p -> p.apply((Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.of((Object)p.symbol("b", (Type)BooleanType.BOOLEAN), (Object)new ApplyNode.Exists()), (List<Symbol>)ImmutableList.of(), (PlanNode)p.values(new Symbol[0]), (PlanNode)p.values(new Symbol[0]))).matches(PlanMatchPattern.correlatedJoin((List<String>)ImmutableList.of(), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of()), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "count_expr"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)))), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"count_expr", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values(new String[0])))));
    }

    @Test
    public void testRewritesToLimit() {
        this.tester().assertThat((Rule<?>)new TransformExistsApplyToCorrelatedJoin(this.tester().getPlannerContext())).on(p -> p.apply((Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.of((Object)p.symbol("b", (Type)BooleanType.BOOLEAN), (Object)new ApplyNode.Exists()), (List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of(), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "corr"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "column")), (PlanNode)p.values(p.symbol("column")))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression((Expression)new CoalesceExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "subquerytrue"), (Expression)BooleanLiteral.FALSE_LITERAL, new Expression[0]))), PlanMatchPattern.correlatedJoin((List<String>)ImmutableList.of((Object)"corr"), PlanMatchPattern.values("corr"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"subquerytrue", (Object)PlanMatchPattern.expression((Expression)BooleanLiteral.TRUE_LITERAL)), PlanMatchPattern.limit(1L, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.values("column"))))))));
    }
}

