/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformFilteringSemiJoinToInnerJoin;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestTransformFilteringSemiJoinToInnerJoin
extends BaseRuleTest {
    public TestTransformFilteringSemiJoinToInnerJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testTransformSemiJoinToInnerJoin() {
        this.tester().assertThat((Rule<?>)new TransformFilteringSemiJoinToInnerJoin()).on(p -> {
            Symbol a = p.symbol("a", (Type)BigintType.BIGINT);
            Symbol b = p.symbol("b", (Type)BigintType.BIGINT);
            Symbol aInB = p.symbol("a_in_b", (Type)BooleanType.BOOLEAN);
            return p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "a_in_b"), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)))), (PlanNode)p.semiJoin((PlanNode)p.values(a), (PlanNode)p.values(b), a, b, aInB, Optional.empty(), Optional.empty(), Optional.empty()));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), (Object)"a_in_b", (Object)PlanMatchPattern.expression((Expression)BooleanLiteral.TRUE_LITERAL)), PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("a", "b").filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L))).left(PlanMatchPattern.values("a")).right(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("b"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values("b"))))));
    }

    @Test
    public void testRemoveRedundantFilter() {
        this.tester().assertThat((Rule<?>)new TransformFilteringSemiJoinToInnerJoin()).on(p -> {
            Symbol a = p.symbol("a", (Type)BigintType.BIGINT);
            Symbol b = p.symbol("b", (Type)BigintType.BIGINT);
            Symbol aInB = p.symbol("a_in_b", (Type)BooleanType.BOOLEAN);
            return p.filter((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a_in_b"), (PlanNode)p.semiJoin((PlanNode)p.values(a), (PlanNode)p.values(b), a, b, aInB, Optional.empty(), Optional.empty(), Optional.empty()));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), (Object)"a_in_b", (Object)PlanMatchPattern.expression((Expression)BooleanLiteral.TRUE_LITERAL)), PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("a", "b").left(PlanMatchPattern.values("a")).right(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("b"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values("b"))))));
    }

    @Test
    public void testFilterNotMatching() {
        this.tester().assertThat((Rule<?>)new TransformFilteringSemiJoinToInnerJoin()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol aInB = p.symbol("a_in_b");
            return p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (PlanNode)p.semiJoin((PlanNode)p.values(a), (PlanNode)p.values(b), a, b, aInB, Optional.empty(), Optional.empty(), Optional.empty()));
        }).doesNotFire();
    }

    @Test
    public void testDoNotRewriteInContextOfDelete() {
        this.tester().assertThat((Rule<?>)new TransformFilteringSemiJoinToInnerJoin()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol aInB = p.symbol("a_in_b");
            return p.filter((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a_in_b"), (PlanNode)p.semiJoin((PlanNode)p.tableScan((List<Symbol>)ImmutableList.of((Object)a), true), (PlanNode)p.values(b), a, b, aInB, Optional.empty(), Optional.empty(), Optional.empty()));
        }).doesNotFire();
        this.tester().assertThat((Rule<?>)new TransformFilteringSemiJoinToInnerJoin()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol aInB = p.symbol("a_in_b");
            return p.filter((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "a_in_b"), (PlanNode)p.semiJoin((PlanNode)p.project(Assignments.of((Symbol)a, (Expression)new SymbolReference((Type)BigintType.BIGINT, "c")), (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of((Object)c), true)), (PlanNode)p.values(b), a, b, aInB, Optional.empty(), Optional.empty(), Optional.empty()));
        }).doesNotFire();
    }
}

