/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformUncorrelatedSubqueryToJoin;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.type.UnknownType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestTransformUncorrelatedSubqueryToJoin
extends BaseRuleTest {
    public TestTransformUncorrelatedSubqueryToJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testRewriteLeftCorrelatedJoinWithScalarSubquery() {
        this.tester().assertThat((Rule<?>)new TransformUncorrelatedSubqueryToJoin()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(a), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.values(1, b));
        }).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.values("a")).right(PlanMatchPattern.values("b"))));
    }

    @Test
    public void testRewriteInnerCorrelatedJoin() {
        this.tester().assertThat((Rule<?>)new TransformUncorrelatedSubqueryToJoin()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(a), JoinType.LEFT, (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.values(b));
        }).matches(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))).left(PlanMatchPattern.values("a")).right(PlanMatchPattern.values("b"))));
    }

    @Test
    public void testRewriteLeftCorrelatedJoin() {
        this.tester().assertThat((Rule<?>)new TransformUncorrelatedSubqueryToJoin()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(a), JoinType.LEFT, (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.values(b));
        }).matches(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))).left(PlanMatchPattern.values("a")).right(PlanMatchPattern.values("b"))));
    }

    @Test
    public void testRewriteRightCorrelatedJoin() {
        this.tester().assertThat((Rule<?>)new TransformUncorrelatedSubqueryToJoin()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(a), JoinType.RIGHT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.values(b));
        }).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.values("a")).right(PlanMatchPattern.values("b"))));
        this.tester().assertThat((Rule<?>)new TransformUncorrelatedSubqueryToJoin()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(a), JoinType.RIGHT, (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.values(b));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a")), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new Constant((Type)BigintType.BIGINT, null))), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))), PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.values("a")).right(PlanMatchPattern.values("b")))));
    }

    @Test
    public void testRewriteFullCorrelatedJoin() {
        this.tester().assertThat((Rule<?>)new TransformUncorrelatedSubqueryToJoin()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(a), JoinType.FULL, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.values(b));
        }).matches(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.left(PlanMatchPattern.values("a")).right(PlanMatchPattern.values("b"))));
        this.tester().assertThat((Rule<?>)new TransformUncorrelatedSubqueryToJoin()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(a), JoinType.FULL, (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.values(b));
        }).doesNotFire();
    }

    @Test
    public void testDoesNotFire() {
        Symbol symbol = new Symbol((Type)UnknownType.UNKNOWN, "x");
        this.tester().assertThat((Rule<?>)new TransformUncorrelatedSubqueryToJoin()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)symbol), (PlanNode)p.values(symbol), (PlanNode)p.values(new Symbol[0]))).doesNotFire();
    }
}

