/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.rule.UnwrapRowSubscript;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestUnwrapRowSubscript
extends BaseRuleTest {
    public TestUnwrapRowSubscript() {
        super(new Plugin[0]);
    }

    @Test
    public void testSimpleSubscript() {
        this.test((Expression)new SubscriptExpression((Type)IntegerType.INTEGER, (Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        this.test((Expression)new SubscriptExpression((Type)IntegerType.INTEGER, (Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        this.test((Expression)new SubscriptExpression((Type)IntegerType.INTEGER, (Expression)new SubscriptExpression((Type)RowType.anonymousRow((Type[])new Type[]{IntegerType.INTEGER}), (Expression)new Row((List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L));
    }

    @Test
    public void testWithCast() {
        this.test((Expression)new SubscriptExpression((Type)BigintType.BIGINT, (Expression)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)BigintType.BIGINT)})), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)BigintType.BIGINT));
        this.test((Expression)new SubscriptExpression((Type)BigintType.BIGINT, (Expression)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)BigintType.BIGINT));
        this.test((Expression)new SubscriptExpression((Type)BigintType.BIGINT, (Expression)new Cast((Expression)new SubscriptExpression((Type)RowType.anonymousRow((Type[])new Type[]{SmallintType.SMALLINT, SmallintType.SMALLINT}), (Expression)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L))), (Type)RowType.anonymousRow((Type[])new Type[]{RowType.anonymousRow((Type[])new Type[]{SmallintType.SMALLINT, SmallintType.SMALLINT}), BigintType.BIGINT})), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"x", (Type)BigintType.BIGINT), RowType.field((String)"y", (Type)BigintType.BIGINT)})), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Expression)new Cast((Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Type)SmallintType.SMALLINT), (Type)BigintType.BIGINT));
    }

    @Test
    public void testWithTryCast() {
        this.test((Expression)new SubscriptExpression((Type)BigintType.BIGINT, (Expression)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)BigintType.BIGINT)}), true), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)BigintType.BIGINT, true));
        this.test((Expression)new SubscriptExpression((Type)BigintType.BIGINT, (Expression)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}), true), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)BigintType.BIGINT, true));
        this.test((Expression)new SubscriptExpression((Type)BigintType.BIGINT, (Expression)new Cast((Expression)new SubscriptExpression((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"x", (Type)BigintType.BIGINT), RowType.field((String)"y", (Type)BigintType.BIGINT)}), (Expression)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L))), (Type)RowType.anonymousRow((Type[])new Type[]{RowType.anonymousRow((Type[])new Type[]{SmallintType.SMALLINT, SmallintType.SMALLINT}), BigintType.BIGINT}), true), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"x", (Type)BigintType.BIGINT), RowType.field((String)"y", (Type)BigintType.BIGINT)}), true), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Expression)new Cast((Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Type)SmallintType.SMALLINT, true), (Type)BigintType.BIGINT, true));
    }

    private void test(Expression original, Expression unwrapped) {
        this.tester().assertThat(new UnwrapRowSubscript().projectExpressionRewrite()).on(p -> p.project(Assignments.builder().put(p.symbol("output"), original).build(), (PlanNode)p.values(new Symbol[0]))).matches(PlanMatchPattern.project(Map.of("output", PlanMatchPattern.expression(unwrapped)), PlanMatchPattern.values(new String[0])));
    }
}

