/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.RowsPerMatch;
import io.trino.sql.planner.plan.SkipToPosition;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.rowpattern.ExpressionAndValuePointers;
import io.trino.sql.planner.rowpattern.ValuePointer;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PatternRecognitionBuilder {
    private PlanNode source;
    private List<Symbol> partitionBy = ImmutableList.of();
    private Optional<OrderingScheme> orderBy = Optional.empty();
    private final Map<Symbol, WindowNode.Function> windowFunctions = new HashMap<Symbol, WindowNode.Function>();
    private final Map<Symbol, PatternRecognitionNode.Measure> measures = new HashMap<Symbol, PatternRecognitionNode.Measure>();
    private Optional<WindowNode.Frame> commonBaseFrame = Optional.empty();
    private RowsPerMatch rowsPerMatch = RowsPerMatch.ONE;
    private Set<IrLabel> skipToLabels = ImmutableSet.of();
    private SkipToPosition skipToPosition = SkipToPosition.PAST_LAST;
    private boolean initial = true;
    private IrRowPattern pattern;
    private final Map<IrLabel, Set<IrLabel>> subsets = new HashMap<IrLabel, Set<IrLabel>>();
    private final Map<IrLabel, ExpressionAndValuePointers> variableDefinitions = new HashMap<IrLabel, ExpressionAndValuePointers>();

    public PatternRecognitionBuilder source(PlanNode source) {
        this.source = source;
        return this;
    }

    public PatternRecognitionBuilder partitionBy(List<Symbol> partitionBy) {
        this.partitionBy = partitionBy;
        return this;
    }

    public PatternRecognitionBuilder orderBy(OrderingScheme orderingScheme) {
        this.orderBy = Optional.of(orderingScheme);
        return this;
    }

    public PatternRecognitionBuilder addWindowFunction(Symbol symbol, WindowNode.Function function) {
        this.windowFunctions.put(symbol, function);
        return this;
    }

    public PatternRecognitionBuilder addMeasure(Symbol symbol, Expression expression, Map<String, ValuePointer> pointers) {
        List<ExpressionAndValuePointers.Assignment> assignments = pointers.entrySet().stream().map(entry -> new ExpressionAndValuePointers.Assignment(new Symbol(symbol.getType(), (String)entry.getKey()), (ValuePointer)entry.getValue())).toList();
        this.measures.put(symbol, new PatternRecognitionNode.Measure(new ExpressionAndValuePointers(expression, assignments), symbol.getType()));
        return this;
    }

    public PatternRecognitionBuilder addMeasure(Symbol symbol, Expression expression) {
        return this.addMeasure(symbol, expression, (Map<String, ValuePointer>)ImmutableMap.of());
    }

    public PatternRecognitionBuilder frame(WindowNode.Frame frame) {
        this.commonBaseFrame = Optional.of(frame);
        return this;
    }

    public PatternRecognitionBuilder rowsPerMatch(RowsPerMatch rowsPerMatch) {
        this.rowsPerMatch = rowsPerMatch;
        return this;
    }

    public PatternRecognitionBuilder skipTo(SkipToPosition position, Set<IrLabel> labels) {
        this.skipToPosition = position;
        this.skipToLabels = ImmutableSet.copyOf(labels);
        return this;
    }

    public PatternRecognitionBuilder skipTo(SkipToPosition position) {
        this.skipToPosition = position;
        return this;
    }

    public PatternRecognitionBuilder seek() {
        this.initial = false;
        return this;
    }

    public PatternRecognitionBuilder pattern(IrRowPattern pattern) {
        this.pattern = pattern;
        return this;
    }

    public PatternRecognitionBuilder addSubset(IrLabel name, Set<IrLabel> elements) {
        this.subsets.put(name, elements);
        return this;
    }

    public PatternRecognitionBuilder addVariableDefinition(IrLabel name, Expression expression, Map<Symbol, ValuePointer> pointers) {
        List<ExpressionAndValuePointers.Assignment> assignments = pointers.entrySet().stream().map(entry -> new ExpressionAndValuePointers.Assignment((Symbol)entry.getKey(), (ValuePointer)entry.getValue())).toList();
        this.variableDefinitions.put(name, new ExpressionAndValuePointers(expression, assignments));
        return this;
    }

    public PatternRecognitionBuilder addVariableDefinition(IrLabel name, Expression expression) {
        return this.addVariableDefinition(name, expression, (Map<Symbol, ValuePointer>)ImmutableMap.of());
    }

    public PatternRecognitionNode build(PlanNodeIdAllocator idAllocator) {
        return new PatternRecognitionNode(idAllocator.getNextId(), this.source, new DataOrganizationSpecification(this.partitionBy, this.orderBy), Optional.empty(), (Set)ImmutableSet.of(), 0, this.windowFunctions, this.measures, this.commonBaseFrame, this.rowsPerMatch, this.skipToLabels, this.skipToPosition, this.initial, this.pattern, this.variableDefinitions);
    }
}

