/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.JoinType;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestEliminateCrossJoins
extends BasePlanTest {
    private static final PlanMatchPattern ORDERS_TABLESCAN = PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey"));
    private static final PlanMatchPattern ORDERS_WITH_SHIPPRIORITY_TABLESCAN = PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey", (Object)"O_SHIPPRIORITY", (Object)"shippriority"));
    private static final PlanMatchPattern PART_TABLESCAN = PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"P_PARTKEY", (Object)"partkey"));
    private static final PlanMatchPattern PART_WITH_NAME_TABLESCAN = PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"P_PARTKEY", (Object)"partkey", (Object)"P_NAME", (Object)"name"));
    private static final PlanMatchPattern LINEITEM_TABLESCAN = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_PARTKEY", (Object)"partkey", (Object)"L_ORDERKEY", (Object)"orderkey"));
    private static final PlanMatchPattern LINEITEM_WITH_RETURNFLAG_TABLESCAN = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_PARTKEY", (Object)"partkey", (Object)"L_ORDERKEY", (Object)"orderkey", (Object)"L_RETURNFLAG", (Object)"returnflag"));
    private static final PlanMatchPattern LINEITEM_WITH_COMMENT_TABLESCAN = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_PARTKEY", (Object)"partkey", (Object)"L_ORDERKEY", (Object)"orderkey", (Object)"L_COMMENT", (Object)"comment"));

    public TestEliminateCrossJoins() {
        super((Map<String, String>)ImmutableMap.of((Object)"join_reordering_strategy", (Object)"ELIMINATE_CROSS_JOINS"));
    }

    @Test
    public void testEliminateSimpleCrossJoin() {
        this.assertPlan("SELECT * FROM part p, orders o, lineitem l WHERE p.partkey = l.partkey AND l.orderkey = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("L_ORDERKEY", "O_ORDERKEY").left(PlanMatchPattern.join(JoinType.INNER, leftJoinBuilder -> leftJoinBuilder.equiCriteria("P_PARTKEY", "L_PARTKEY").left(PlanMatchPattern.anyTree(PART_TABLESCAN)).right(PlanMatchPattern.anyTree(LINEITEM_TABLESCAN)))).right(PlanMatchPattern.anyTree(ORDERS_TABLESCAN)))));
    }

    @Test
    public void testDoesNotReorderJoinsWhenNoCrossJoinPresent() {
        this.assertPlan("SELECT o1.orderkey, o2.custkey, o3.orderstatus, o4.totalprice FROM (orders o1 JOIN orders o2 ON o1.orderkey = o2.orderkey) JOIN (orders o3 JOIN orders o4 ON o3.orderkey = o4.orderkey) ON o1.orderkey = o3.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("O1_ORDERKEY", "O3_ORDERKEY").left(PlanMatchPattern.join(JoinType.INNER, leftJoinBuilder -> leftJoinBuilder.equiCriteria("O1_ORDERKEY", "O2_ORDERKEY").left(PlanMatchPattern.anyTree(PlanMatchPattern.strictTableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O1_ORDERKEY", (Object)"orderkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.strictTableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O2_ORDERKEY", (Object)"orderkey", (Object)"O2_CUSTKEY", (Object)"custkey")))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, rightJoinBuilder -> rightJoinBuilder.equiCriteria("O3_ORDERKEY", "O4_ORDERKEY").left(PlanMatchPattern.anyTree(PlanMatchPattern.strictTableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O3_ORDERKEY", (Object)"orderkey", (Object)"O3_ORDERSTATUS", (Object)"orderstatus")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.strictTableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O4_ORDERKEY", (Object)"orderkey", (Object)"O4_totalprice", (Object)"totalprice"))))))))));
    }

    @Test
    public void testGiveUpOnCrossJoin() {
        this.assertPlan("SELECT o.orderkey FROM part p, orders o, lineitem l WHERE l.orderkey = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("O_ORDERKEY", "L_ORDERKEY").left(PlanMatchPattern.join(JoinType.INNER, leftJoinBuilder -> leftJoinBuilder.left(PlanMatchPattern.tableScan("part")).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey")))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey")))))));
    }

    @Test
    public void testEliminateCrossJoinWithNonEqualityCondition() {
        this.assertPlan("SELECT o.orderkey FROM part p, orders o, lineitem l WHERE p.partkey = l.partkey AND l.orderkey = o.orderkey AND p.partkey <> o.orderkey AND p.name < l.comment", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("L_ORDERKEY", "O_ORDERKEY").left(PlanMatchPattern.join(JoinType.INNER, leftJoinBuilder -> leftJoinBuilder.equiCriteria("P_PARTKEY", "L_PARTKEY").filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)VarcharType.VARCHAR, "P_NAME"), (Expression)new SymbolReference((Type)VarcharType.VARCHAR, "expr"))).left(PlanMatchPattern.anyTree(PART_WITH_NAME_TABLESCAN)).right(PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new SymbolReference((Type)VarcharType.VARCHAR, "L_COMMENT"), (Type)VarcharType.createVarcharType((int)55)))), PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "L_PARTKEY"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "L_ORDERKEY")), LINEITEM_WITH_COMMENT_TABLESCAN)))))).right(PlanMatchPattern.anyTree(ORDERS_TABLESCAN)))));
    }

    @Test
    public void testEliminateCrossJoinPreserveFilters() {
        this.assertPlan("SELECT o.orderkey FROM part p, orders o, lineitem l WHERE p.partkey = l.partkey AND l.orderkey = o.orderkey AND l.returnflag = 'R' AND shippriority >= 10", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("L_ORDERKEY", "O_ORDERKEY").left(PlanMatchPattern.join(JoinType.INNER, leftJoinBuilder -> leftJoinBuilder.equiCriteria("P_PARTKEY", "L_PARTKEY").left(PlanMatchPattern.anyTree(PART_TABLESCAN)).right(PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)VarcharType.createVarcharType((int)1), "L_RETURNFLAG"), (Expression)new Constant((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"R"))), LINEITEM_WITH_RETURNFLAG_TABLESCAN))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "O_SHIPPRIORITY"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)10L)), ORDERS_WITH_SHIPPRIORITY_TABLESCAN))))));
    }
}

