/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.SessionTestUtils;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.optimizations.ExpressionEquivalence;
import io.trino.testing.TransactionBuilder;
import io.trino.transaction.TestingTransactionManager;
import io.trino.transaction.TransactionManager;
import io.trino.type.DateTimes;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExpressionEquivalence {
    private static final TestingTransactionManager TRANSACTION_MANAGER = new TestingTransactionManager();
    private static final PlannerContext PLANNER_CONTEXT = TestingPlannerContext.plannerContextBuilder().withTransactionManager(TRANSACTION_MANAGER).build();
    private static final ExpressionEquivalence EQUIVALENCE = new ExpressionEquivalence(PLANNER_CONTEXT.getMetadata(), PLANNER_CONTEXT.getFunctionManager(), PLANNER_CONTEXT.getTypeManager());
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction MOD = FUNCTIONS.resolveFunction("mod", TypeSignatureProvider.fromTypes((Type[])new Type[]{IntegerType.INTEGER, IntegerType.INTEGER}));

    @Test
    public void testEquivalent() {
        TestExpressionEquivalence.assertEquivalent((Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, null));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a_bigint"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "b_double")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "b_double"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a_bigint")));
        TestExpressionEquivalence.assertEquivalent((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionEquivalence.assertEquivalent((Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L));
        TestExpressionEquivalence.assertEquivalent((Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("4.4"))), (Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("4.4"))));
        TestExpressionEquivalence.assertEquivalent((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"foo")), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"foo")));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("4.4"))), (Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("5.5")))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("5.5"))), (Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("4.4")))));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"foo")), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"bar"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"bar")), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"foo"))));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Constant((Type)TimestampType.createTimestampType((int)9), DateTimes.parseTimestamp((int)9, (String)"2020-05-10 12:34:56.123456789")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)9), DateTimes.parseTimestamp((int)9, (String)"2021-05-10 12:34:56.123456789"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Constant((Type)TimestampType.createTimestampType((int)9), DateTimes.parseTimestamp((int)9, (String)"2021-05-10 12:34:56.123456789")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)9), DateTimes.parseTimestamp((int)9, (String)"2020-05-10 12:34:56.123456789"))));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Constant((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9), DateTimes.parseTimestampWithTimeZone((int)9, (String)"2020-05-10 12:34:56.123456789 +8")), (Expression)new Constant((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9), DateTimes.parseTimestampWithTimeZone((int)9, (String)"2021-05-10 12:34:56.123456789 +8"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Constant((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9), DateTimes.parseTimestampWithTimeZone((int)9, (String)"2021-05-10 12:34:56.123456789 +8")), (Expression)new Constant((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9), DateTimes.parseTimestampWithTimeZone((int)9, (String)"2020-05-10 12:34:56.123456789 +8"))));
        TestExpressionEquivalence.assertEquivalent((Expression)new FunctionCall(MOD, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)new FunctionCall(MOD, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))));
        TestExpressionEquivalence.assertEquivalent((Expression)new SymbolReference((Type)BigintType.BIGINT, "a_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a_bigint"));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b_bigint")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a_bigint")));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b_bigint")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a_bigint")));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a_bigint"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "b_double")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "b_double"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a_bigint")));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)BooleanLiteral.TRUE_LITERAL, (Object)BooleanLiteral.FALSE_LITERAL)), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)BooleanLiteral.FALSE_LITERAL, (Object)BooleanLiteral.TRUE_LITERAL)));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)7L)))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)7L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)7L)))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)7L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b_bigint")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "c_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "d_bigint")))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "d_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "c_bigint")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a_bigint")))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b_bigint")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "c_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "d_bigint")))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "d_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "c_bigint")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a_bigint")))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)7L)))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)7L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)7L)))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)7L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)7L)))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)7L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)7L)))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)7L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "a_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "b_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "c_boolean"))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "c_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "b_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "a_boolean"))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "a_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "b_boolean"))), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "c_boolean"))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "c_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "b_boolean"))), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "a_boolean"))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "a_boolean"), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "b_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "c_boolean"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "a_boolean"), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "c_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "b_boolean"))), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "a_boolean"))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "a_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "b_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "c_boolean"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "d_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "e_boolean"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "f_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "g_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "h_boolean"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "h_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "g_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "f_boolean"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "b_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "a_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "c_boolean"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "e_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "d_boolean"))))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "a_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "b_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "c_boolean"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "d_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "e_boolean"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "f_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "g_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "h_boolean"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "h_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "g_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "f_boolean"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "b_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "a_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "c_boolean"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference((Type)BooleanType.BOOLEAN, "e_boolean"), (Object)new SymbolReference((Type)BooleanType.BOOLEAN, "d_boolean"))))));
    }

    private static void assertEquivalent(Expression leftExpression, Expression rightExpression) {
        Set symbols = SymbolsExtractor.extractUnique((Iterable)ImmutableList.of((Object)leftExpression, (Object)rightExpression));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)TestExpressionEquivalence.areExpressionEquivalent(leftExpression, rightExpression, symbols)).describedAs(String.format("Expected (%s) and (%s) to be equivalent", leftExpression, rightExpression), new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)TestExpressionEquivalence.areExpressionEquivalent(rightExpression, leftExpression, symbols)).describedAs(String.format("Expected (%s) and (%s) to be equivalent", rightExpression, leftExpression), new Object[0])).isTrue();
    }

    @Test
    public void testNotEquivalent() {
        TestExpressionEquivalence.assertNotEquivalent((Expression)new Constant((Type)BooleanType.BOOLEAN, null), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionEquivalence.assertNotEquivalent((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new Constant((Type)BooleanType.BOOLEAN, null));
        TestExpressionEquivalence.assertNotEquivalent((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionEquivalence.assertNotEquivalent((Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("4.4"))), (Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("5.5"))));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"'foo'")), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"'bar'")));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L)));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L)));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L)));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L)));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L)));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new FunctionCall(MOD, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)new FunctionCall(MOD, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L))));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new SymbolReference((Type)BigintType.BIGINT, "a_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b_bigint"));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b_bigint")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "c_bigint")));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b_bigint")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "c_bigint")));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a_bigint"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "b_double")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "b_double"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "c_bigint")));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)7L)))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)7L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L)))));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)7L)))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)7L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L)))));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b_bigint")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "c_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "d_bigint")))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "d_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "c_bigint")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "c_bigint")))));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b_bigint")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "c_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "d_bigint")))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "d_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "c_bigint")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b_bigint"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "c_bigint")))));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new Cast((Expression)new Constant((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)3), DateTimes.parseTimeWithTimeZone((int)3, (String)"12:34:56.123 +00:00")), (Type)VarcharType.VARCHAR), (Expression)new Cast((Expression)new Constant((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)3), DateTimes.parseTimeWithTimeZone((int)3, (String)"14:34:56.123 +02:00")), (Type)VarcharType.VARCHAR));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new Cast((Expression)new Constant((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)6), DateTimes.parseTimeWithTimeZone((int)6, (String)"12:34:56.123456 +00:00")), (Type)VarcharType.VARCHAR), (Expression)new Cast((Expression)new Constant((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)6), DateTimes.parseTimeWithTimeZone((int)6, (String)"14:34:56.123456 +02:00")), (Type)VarcharType.VARCHAR));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new Cast((Expression)new Constant((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)9), DateTimes.parseTimeWithTimeZone((int)9, (String)"12:34:56.123456789 +00:00")), (Type)VarcharType.VARCHAR), (Expression)new Cast((Expression)new Constant((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)9), DateTimes.parseTimeWithTimeZone((int)9, (String)"14:34:56.123456789 +02:00")), (Type)VarcharType.VARCHAR));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new Cast((Expression)new Constant((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)12), DateTimes.parseTimeWithTimeZone((int)12, (String)"12:34:56.123456789012 +00:00")), (Type)VarcharType.VARCHAR), (Expression)new Cast((Expression)new Constant((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)12), DateTimes.parseTimeWithTimeZone((int)12, (String)"14:34:56.123456789012 +02:00")), (Type)VarcharType.VARCHAR));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new Cast((Expression)new Constant((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), DateTimes.parseTimestampWithTimeZone((int)3, (String)"2020-05-10 12:34:56.123 Europe/Warsaw")), (Type)VarcharType.VARCHAR), (Expression)new Cast((Expression)new Constant((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), DateTimes.parseTimestampWithTimeZone((int)3, (String)"2020-05-10 12:34:56.123 Europe/Paris")), (Type)VarcharType.VARCHAR));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new Cast((Expression)new Constant((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6), DateTimes.parseTimestampWithTimeZone((int)6, (String)"2020-05-10 12:34:56.123456 Europe/Warsaw")), (Type)VarcharType.VARCHAR), (Expression)new Cast((Expression)new Constant((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6), DateTimes.parseTimestampWithTimeZone((int)6, (String)"2020-05-10 12:34:56.123456 Europe/Paris")), (Type)VarcharType.VARCHAR));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new Cast((Expression)new Constant((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9), DateTimes.parseTimestampWithTimeZone((int)9, (String)"2020-05-10 12:34:56.123456789 Europe/Warsaw")), (Type)VarcharType.VARCHAR), (Expression)new Cast((Expression)new Constant((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9), DateTimes.parseTimestampWithTimeZone((int)9, (String)"2020-05-10 12:34:56.123456789 Europe/Paris")), (Type)VarcharType.VARCHAR));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new Cast((Expression)new Constant((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12), DateTimes.parseTimestampWithTimeZone((int)12, (String)"2020-05-10 12:34:56.123456789012 Europe/Warsaw")), (Type)VarcharType.VARCHAR), (Expression)new Cast((Expression)new Constant((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12), DateTimes.parseTimestampWithTimeZone((int)12, (String)"2020-05-10 12:34:56.123456789012 Europe/Paris")), (Type)VarcharType.VARCHAR));
    }

    private static void assertNotEquivalent(Expression leftExpression, Expression rightExpression) {
        Set symbols = SymbolsExtractor.extractUnique((Iterable)ImmutableList.of((Object)leftExpression, (Object)rightExpression));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)TestExpressionEquivalence.areExpressionEquivalent(leftExpression, rightExpression, symbols)).describedAs(String.format("Expected (%s) and (%s) to not be equivalent", leftExpression, rightExpression), new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)TestExpressionEquivalence.areExpressionEquivalent(rightExpression, leftExpression, symbols)).describedAs(String.format("Expected (%s) and (%s) to not be equivalent", rightExpression, leftExpression), new Object[0])).isFalse();
    }

    private static boolean areExpressionEquivalent(Expression leftExpression, Expression rightExpression, Set<Symbol> symbols) {
        TestingTransactionManager transactionManager = new TestingTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager((TransactionManager)transactionManager).build();
        return (Boolean)TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)new AllowAllAccessControl()).singleStatement().execute(SessionTestUtils.TEST_SESSION, transactionSession -> EQUIVALENCE.areExpressionsEquivalent(transactionSession, leftExpression, rightExpression, symbols));
    }
}

