/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.SessionTestUtils;
import io.trino.cost.CachingTableStatsProvider;
import io.trino.cost.RuntimeInfoProvider;
import io.trino.cost.StatsAndCosts;
import io.trino.cost.TableStatsProvider;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.DynamicFilters;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanAssert;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.rule.RemoveUnsupportedDynamicFilters;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.sanity.DynamicFiltersChecker;
import io.trino.testing.TestingTransactionHandle;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestRemoveUnsupportedDynamicFilters
extends BasePlanTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private PlannerContext plannerContext;
    private Metadata metadata;
    private PlanBuilder builder;
    private Symbol lineitemOrderKeySymbol;
    private TableScanNode lineitemTableScanNode;
    private TableHandle lineitemTableHandle;
    private Symbol ordersOrderKeySymbol;
    private TableScanNode ordersTableScanNode;

    @BeforeAll
    public void setup() {
        this.plannerContext = this.getPlanTester().getPlannerContext();
        this.metadata = this.plannerContext.getMetadata();
        this.builder = new PlanBuilder(new PlanNodeIdAllocator(), this.plannerContext, SessionTestUtils.TEST_SESSION);
        CatalogHandle catalogHandle = this.getCurrentCatalogHandle();
        this.lineitemTableHandle = new TableHandle(catalogHandle, (ConnectorTableHandle)new TpchTableHandle("sf1", "lineitem", 1.0), (ConnectorTransactionHandle)TestingTransactionHandle.create());
        this.lineitemOrderKeySymbol = this.builder.symbol("LINEITEM_OK", (Type)BigintType.BIGINT);
        this.lineitemTableScanNode = this.builder.tableScan(this.lineitemTableHandle, (List<Symbol>)ImmutableList.of((Object)this.lineitemOrderKeySymbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)this.lineitemOrderKeySymbol, (Object)new TpchColumnHandle("orderkey", (Type)BigintType.BIGINT)));
        TableHandle ordersTableHandle = new TableHandle(catalogHandle, (ConnectorTableHandle)new TpchTableHandle("sf1", "orders", 1.0), (ConnectorTransactionHandle)TestingTransactionHandle.create());
        this.ordersOrderKeySymbol = this.builder.symbol("ORDERS_OK", (Type)BigintType.BIGINT);
        this.ordersTableScanNode = this.builder.tableScan(ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)this.ordersOrderKeySymbol, (Object)new TpchColumnHandle("orderkey", (Type)BigintType.BIGINT)));
    }

    @Test
    public void testUnconsumedDynamicFilterInJoin() {
        JoinNode root = this.builder.join(JoinType.INNER, (PlanNode)this.builder.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "ORDERS_OK"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (PlanNode)this.ordersTableScanNode), (PlanNode)this.lineitemTableScanNode, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)new DynamicFilterId("DF"), (Object)this.lineitemOrderKeySymbol));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("ORDERS_OK", "LINEITEM_OK").left(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "ORDERS_OK"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))).right(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))));
    }

    @Test
    public void testDynamicFilterConsumedOnBuildSide() {
        Expression dynamicFilter = DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.ordersOrderKeySymbol.toSymbolReference());
        JoinNode root = this.builder.join(JoinType.INNER, (PlanNode)this.builder.filter(dynamicFilter, (PlanNode)this.ordersTableScanNode), (PlanNode)this.builder.filter(dynamicFilter, (PlanNode)this.lineitemTableScanNode), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)new DynamicFilterId("DF"), (Object)this.lineitemOrderKeySymbol));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("ORDERS_OK", "LINEITEM_OK").dynamicFilter((Type)BigintType.BIGINT, "ORDERS_OK", "LINEITEM_OK").left(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)new SymbolReference((Type)BigintType.BIGINT, "ORDERS_OK")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))).right(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))));
    }

    @Test
    public void testUnmatchedDynamicFilter() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.join(JoinType.INNER, (PlanNode)this.ordersTableScanNode, (PlanNode)this.builder.filter(IrUtils.combineConjuncts((Expression[])new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "LINEITEM_OK"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())}), (PlanNode)this.lineitemTableScanNode), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol)), (List<Symbol>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of()));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.output(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("ORDERS_OK", "LINEITEM_OK").left(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))).right(TestRemoveUnsupportedDynamicFilters.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "LINEITEM_OK"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testRemoveDynamicFilterNotAboveTableScan() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.join(JoinType.INNER, (PlanNode)this.builder.filter(IrUtils.combineConjuncts((Expression[])new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "LINEITEM_OK"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.ordersOrderKeySymbol.toSymbolReference())}), (PlanNode)this.builder.values(this.lineitemOrderKeySymbol)), (PlanNode)this.ordersTableScanNode, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.lineitemOrderKeySymbol, this.ordersOrderKeySymbol)), (List<Symbol>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)new DynamicFilterId("DF"), (Object)this.ordersOrderKeySymbol)));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.output(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("LINEITEM_OK", "ORDERS_OK").left(TestRemoveUnsupportedDynamicFilters.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "LINEITEM_OK"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), PlanMatchPattern.values("LINEITEM_OK"))).right(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))))));
    }

    @Test
    public void testNestedDynamicFilterDisjunctionRewrite() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.join(JoinType.INNER, (PlanNode)this.ordersTableScanNode, (PlanNode)this.builder.filter(IrUtils.combineConjuncts((Expression[])new Expression[]{IrUtils.combineDisjuncts((Expression[])new Expression[]{new IsNullPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "LINEITEM_OK")), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())}), IrUtils.combineDisjuncts((Expression[])new Expression[]{new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "LINEITEM_OK"))), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())})}), (PlanNode)this.lineitemTableScanNode), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of()));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.output(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("ORDERS_OK", "LINEITEM_OK").left(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))).right(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))))));
    }

    @Test
    public void testNestedDynamicFilterConjunctionRewrite() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.join(JoinType.INNER, (PlanNode)this.ordersTableScanNode, (PlanNode)this.builder.filter(IrUtils.combineDisjuncts((Expression[])new Expression[]{IrUtils.combineConjuncts((Expression[])new Expression[]{new IsNullPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "LINEITEM_OK")), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())}), IrUtils.combineConjuncts((Expression[])new Expression[]{new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "LINEITEM_OK"))), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())})}), (PlanNode)this.lineitemTableScanNode), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of()));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.output(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("ORDERS_OK", "LINEITEM_OK").left(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))).right(TestRemoveUnsupportedDynamicFilters.filter(IrUtils.combineDisjuncts((Expression[])new Expression[]{new IsNullPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "LINEITEM_OK")), new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "LINEITEM_OK")))}), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testRemoveUnsupportedCast() {
        Symbol lineitemDoubleOrderKeySymbol = this.builder.symbol("LINEITEM_DOUBLE_OK", (Type)DoubleType.DOUBLE);
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.join(JoinType.INNER, (PlanNode)this.builder.filter(DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)new Cast((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "LINEITEM_DOUBLE_OK"), (Type)BigintType.BIGINT)), (PlanNode)this.builder.tableScan(this.lineitemTableHandle, (List<Symbol>)ImmutableList.of((Object)lineitemDoubleOrderKeySymbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)lineitemDoubleOrderKeySymbol, (Object)new TpchColumnHandle("orderkey", (Type)DoubleType.DOUBLE)))), (PlanNode)this.ordersTableScanNode, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(lineitemDoubleOrderKeySymbol, this.ordersOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)lineitemDoubleOrderKeySymbol), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)new DynamicFilterId("DF"), (Object)this.ordersOrderKeySymbol)));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.output(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("LINEITEM_DOUBLE_OK", "ORDERS_OK").left(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_DOUBLE_OK", (Object)"orderkey"))).right(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))))));
    }

    @Test
    public void testSpatialJoin() {
        Symbol leftSymbol = this.builder.symbol("LEFT_SYMBOL", (Type)BigintType.BIGINT);
        Symbol rightSymbol = this.builder.symbol("RIGHT_SYMBOL", (Type)BigintType.BIGINT);
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), this.builder.spatialJoin(SpatialJoinNode.Type.INNER, (PlanNode)this.builder.values(leftSymbol), (PlanNode)this.builder.values(rightSymbol), (List<Symbol>)ImmutableList.of((Object)leftSymbol, (Object)rightSymbol), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "LEFT_SYMBOL"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "RIGHT_SYMBOL")))));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.output(PlanMatchPattern.spatialJoin((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values("LEFT_SYMBOL"), PlanMatchPattern.values("RIGHT_SYMBOL"))));
    }

    @Test
    public void testUnconsumedDynamicFilterInSemiJoin() {
        SemiJoinNode root = this.builder.semiJoin((PlanNode)this.builder.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "ORDERS_OK"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (PlanNode)this.ordersTableScanNode), (PlanNode)this.lineitemTableScanNode, this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol, new Symbol((Type)UnknownType.UNKNOWN, "SEMIJOIN_OUTPUT"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new DynamicFilterId("DF")));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.semiJoin("ORDERS_OK", "LINEITEM_OK", "SEMIJOIN_OUTPUT", false, TestRemoveUnsupportedDynamicFilters.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "ORDERS_OK"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))));
    }

    @Test
    public void testDynamicFilterConsumedOnFilteringSourceSideInSemiJoin() {
        SemiJoinNode root = this.builder.semiJoin((PlanNode)this.ordersTableScanNode, (PlanNode)this.builder.filter(IrUtils.combineConjuncts((Expression[])new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "LINEITEM_OK"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())}), (PlanNode)this.lineitemTableScanNode), this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol, new Symbol((Type)UnknownType.UNKNOWN, "SEMIJOIN_OUTPUT"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new DynamicFilterId("DF")));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.semiJoin("ORDERS_OK", "LINEITEM_OK", "SEMIJOIN_OUTPUT", false, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")), TestRemoveUnsupportedDynamicFilters.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "LINEITEM_OK"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))));
    }

    @Test
    public void testUnmatchedDynamicFilterInSemiJoin() {
        SemiJoinNode root = this.builder.semiJoin((PlanNode)this.builder.filter(IrUtils.combineConjuncts((Expression[])new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "ORDERS_OK"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.ordersOrderKeySymbol.toSymbolReference())}), (PlanNode)this.ordersTableScanNode), (PlanNode)this.lineitemTableScanNode, this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol, new Symbol((Type)UnknownType.UNKNOWN, "SEMIJOIN_OUTPUT"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.semiJoin("ORDERS_OK", "LINEITEM_OK", "SEMIJOIN_OUTPUT", false, TestRemoveUnsupportedDynamicFilters.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "ORDERS_OK"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))));
    }

    @Test
    public void testRemoveDynamicFilterNotAboveTableScanWithSemiJoin() {
        SemiJoinNode root = this.builder.semiJoin((PlanNode)this.builder.filter(IrUtils.combineConjuncts((Expression[])new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "ORDERS_OK"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.ordersOrderKeySymbol.toSymbolReference())}), (PlanNode)this.builder.values(this.ordersOrderKeySymbol)), (PlanNode)this.lineitemTableScanNode, this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol, new Symbol((Type)UnknownType.UNKNOWN, "SEMIJOIN_OUTPUT"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new DynamicFilterId("DF")));
        this.assertPlan(this.removeUnsupportedDynamicFilters((PlanNode)root), PlanMatchPattern.semiJoin("ORDERS_OK", "LINEITEM_OK", "SEMIJOIN_OUTPUT", false, TestRemoveUnsupportedDynamicFilters.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "ORDERS_OK"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), PlanMatchPattern.values("ORDERS_OK")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))));
    }

    private static PlanMatchPattern filter(Expression expectedPredicate, PlanMatchPattern source) {
        return PlanMatchPattern.filter(expectedPredicate, (Expression)BooleanLiteral.TRUE_LITERAL, source);
    }

    private PlanNode removeUnsupportedDynamicFilters(PlanNode root) {
        return (PlanNode)this.getPlanTester().inTransaction(session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            PlanNode rewrittenPlan = new RemoveUnsupportedDynamicFilters(this.plannerContext).optimize(root, new PlanOptimizer.Context(session, new SymbolAllocator(), new PlanNodeIdAllocator(), WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector(), (TableStatsProvider)new CachingTableStatsProvider(this.metadata, session), RuntimeInfoProvider.noImplementation()));
            new DynamicFiltersChecker().validate(rewrittenPlan, session, this.plannerContext, WarningCollector.NOOP);
            return rewrittenPlan;
        });
    }

    protected void assertPlan(PlanNode actual, PlanMatchPattern pattern) {
        this.getPlanTester().inTransaction(session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            PlanAssert.assertPlan(session, this.metadata, this.getPlanTester().getPlannerContext().getFunctionManager(), this.getPlanTester().getStatsCalculator(), new Plan(actual, StatsAndCosts.empty()), pattern);
            return null;
        });
    }
}

