/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import com.google.common.collect.ImmutableList;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.planprinter.CounterBasedAnonymizer;
import io.trino.type.UnknownType;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCounterBasedAnonymizer {
    @Test
    public void testTimestampWithTimeZoneValueAnonymization() {
        CounterBasedAnonymizer anonymizer = new CounterBasedAnonymizer();
        Assertions.assertThat((String)anonymizer.anonymize((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "2012-10-30 18:00:00.000 America/Los_Angeles")).isEqualTo("timestamp_3_with_time_zone_value_1");
    }

    @Test
    public void testSymbolReferenceAnonymization() {
        LogicalExpression expression = new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "c"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L))));
        CounterBasedAnonymizer anonymizer = new CounterBasedAnonymizer();
        Assertions.assertThat((String)anonymizer.anonymize((Expression)expression)).isEqualTo("((\"symbol_1\" > 'integer_literal_1') AND (\"symbol_2\" < 'integer_literal_2') AND (\"symbol_3\" = 'integer_literal_3'))");
    }

    @Test
    public void testLiteralAnonymization() {
        CounterBasedAnonymizer anonymizer = new CounterBasedAnonymizer();
        Assertions.assertThat((String)anonymizer.anonymize((Expression)new Constant((Type)UnknownType.UNKNOWN, null))).isEqualTo("null");
    }
}

