/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.Session;
import io.trino.sql.query.QueryAssertions;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestAggregation {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testQuantifiedComparison() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT v > ALL (VALUES 1) FROM (VALUES (1, 1), (1, 2)) t(k, v) GROUP BY k"))).failure().hasMessageContaining("must be an aggregate expression or appear in GROUP BY clause");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT v > ANY (VALUES 1) FROM (VALUES (1, 1), (1, 2)) t(k, v) GROUP BY k"))).failure().hasMessageContaining("must be an aggregate expression or appear in GROUP BY clause");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT v > SOME (VALUES 1) FROM (VALUES (1, 1), (1, 2)) t(k, v) GROUP BY k"))).failure().hasMessageContaining("must be an aggregate expression or appear in GROUP BY clause");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count_if(v > ALL (VALUES 0, 1)) FROM (VALUES (1, 1), (1, 2)) t(k, v) GROUP BY k"))).matches("VALUES BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count_if(v > ANY (VALUES 0, 1)) FROM (VALUES (1, 1), (1, 2)) t(k, v) GROUP BY k"))).matches("VALUES BIGINT '2'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 > ALL (VALUES k) FROM (VALUES (1, 1), (1, 2)) t(k, v) GROUP BY k"))).failure().hasMessageContaining("line 1:17: Given correlated subquery is not supported");
    }

    @Test
    void testSpecialDateTimeFunctionsInAggregation() {
        Session session = Session.builder((Session)this.assertions.getDefaultSession()).setStart(ZonedDateTime.of(2024, 3, 12, 12, 24, 0, 0, ZoneId.of("Pacific/Apia")).toInstant()).setSystemProperty("session_start_time", ZonedDateTime.of(2024, 3, 12, 12, 24, 0, 0, ZoneId.of("Pacific/Apia")).toInstant().toString()).build();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(session, "WITH t(x) AS (VALUES 1)\nSELECT max(x), current_timestamp, current_date, current_time, localtimestamp, localtime\nFROM t\n"))).matches("VALUES (\n    1,\n    TIMESTAMP '2024-03-12 12:24:0.000 Pacific/Apia',\n    DATE '2024-03-12',\n    TIME '12:24:0.000+13:00',\n    TIMESTAMP '2024-03-12 12:24:0.000',\n    TIME '12:24:0.000')\n");
    }

    @Test
    public void testAggregationMaskOnDictionaryInput() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT\n    max(update_ts) FILTER (WHERE step_type = 'Rest')\nFROM (VALUES\n        ('cell_id', 'Rest', TIMESTAMP '2005-09-10 13:31:00.123 Europe/Warsaw'),\n        ('cell_id', 'Rest', TIMESTAMP '2005-09-10 13:31:00.123 Europe/Warsaw')\n    ) AS t(cell_id, step_type, update_ts)\n-- UNNEST to produce DictionaryBlock\nCROSS JOIN UNNEST (sequence(1, 1000)) AS a(e)\nGROUP BY cell_id\n"))).matches("VALUES TIMESTAMP '2005-09-10 13:31:00.123 Europe/Warsaw'");
    }

    @Test
    public void testLongDecimalPartialAggregation() {
        Session session = Session.builder((Session)this.assertions.getDefaultSession()).setSystemProperty("push_partial_aggregation_through_join", "true").build();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(session, "-- sum and avg likely use different aggregation state classes\nSELECT l.i, sum(v), avg(v)\nFROM (VALUES 1, 2, 2, 3, 3, 3) l(i)\nJOIN (VALUES\n    (1, DECIMAL '12345678901234567890.1234567890'),\n    (1, DECIMAL '11111111111111111111.1234567890'),\n    (2, DECIMAL '22222222222222222222.1234567890'),\n    (3, DECIMAL '33333333333333333333.1234567890'),\n    (3, DECIMAL '10101010101010101010.0987654321'),\n    (7, DECIMAL '77777777777777777777.1234567890')) r(i, v) ON l.i = r.i\nGROUP BY l.i\n"))).matches("SELECT i, CAST(s AS decimal(38, 10)), v\nFROM (VALUES\n    (1, DECIMAL '23456790012345679001.2469135780', DECIMAL '11728395006172839500.6234567890'),\n    (2, DECIMAL '44444444444444444444.2469135780', DECIMAL '22222222222222222222.1234567890'),\n    (3, DECIMAL '130303030303030303029.6666666633', DECIMAL '21717171717171717171.6111111106')) t(i, s, v)\n");
    }
}

