/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.inject.Inject;
import io.airlift.node.NodeInfo;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.trino.connector.CatalogConnector;
import io.trino.connector.CatalogFactory;
import io.trino.connector.ConnectorAwareNodeManager;
import io.trino.connector.ConnectorContextInstance;
import io.trino.connector.ConnectorServices;
import io.trino.connector.InternalMetadataProvider;
import io.trino.connector.informationschema.InformationSchemaConnector;
import io.trino.connector.system.CoordinatorSystemTablesProvider;
import io.trino.connector.system.StaticSystemTablesProvider;
import io.trino.connector.system.SystemConnector;
import io.trino.connector.system.SystemTablesProvider;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.Metadata;
import io.trino.security.AccessControl;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.PageSorter;
import io.trino.spi.VersionEmbedder;
import io.trino.spi.catalog.CatalogProperties;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorName;
import io.trino.spi.type.TypeManager;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@ThreadSafe
public class DefaultCatalogFactory
implements CatalogFactory {
    private final Metadata metadata;
    private final AccessControl accessControl;
    private final InternalNodeManager nodeManager;
    private final PageSorter pageSorter;
    private final PageIndexerFactory pageIndexerFactory;
    private final NodeInfo nodeInfo;
    private final VersionEmbedder versionEmbedder;
    private final OpenTelemetry openTelemetry;
    private final TransactionManager transactionManager;
    private final TypeManager typeManager;
    private final boolean schedulerIncludeCoordinator;
    private final int maxPrefetchedInformationSchemaPrefixes;
    private final ConcurrentMap<ConnectorName, ConnectorFactory> connectorFactories = new ConcurrentHashMap<ConnectorName, ConnectorFactory>();

    @Inject
    public DefaultCatalogFactory(Metadata metadata, AccessControl accessControl, InternalNodeManager nodeManager, PageSorter pageSorter, PageIndexerFactory pageIndexerFactory, NodeInfo nodeInfo, VersionEmbedder versionEmbedder, OpenTelemetry openTelemetry, TransactionManager transactionManager, TypeManager typeManager, NodeSchedulerConfig nodeSchedulerConfig, OptimizerConfig optimizerConfig) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.pageSorter = Objects.requireNonNull(pageSorter, "pageSorter is null");
        this.pageIndexerFactory = Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
        this.nodeInfo = Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        this.versionEmbedder = Objects.requireNonNull(versionEmbedder, "versionEmbedder is null");
        this.openTelemetry = Objects.requireNonNull(openTelemetry, "openTelemetry is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.schedulerIncludeCoordinator = nodeSchedulerConfig.isIncludeCoordinator();
        this.maxPrefetchedInformationSchemaPrefixes = optimizerConfig.getMaxPrefetchedInformationSchemaPrefixes();
    }

    @Override
    public synchronized void addConnectorFactory(ConnectorFactory connectorFactory) {
        ConnectorFactory existingConnectorFactory = this.connectorFactories.putIfAbsent(new ConnectorName(connectorFactory.getName()), connectorFactory);
        Preconditions.checkArgument((existingConnectorFactory == null ? 1 : 0) != 0, (String)"Connector '%s' is already registered", (Object)connectorFactory.getName());
    }

    @Override
    public CatalogConnector createCatalog(CatalogProperties catalogProperties) {
        Objects.requireNonNull(catalogProperties, "catalogProperties is null");
        ConnectorFactory connectorFactory = (ConnectorFactory)this.connectorFactories.get(catalogProperties.connectorName());
        Preconditions.checkArgument((connectorFactory != null ? 1 : 0) != 0, (String)"No factory for connector '%s'. Available factories: %s", (Object)catalogProperties.connectorName(), this.connectorFactories.keySet());
        Connector connector = this.createConnector(catalogProperties.catalogHandle().getCatalogName().toString(), catalogProperties.catalogHandle(), connectorFactory, catalogProperties.properties());
        return this.createCatalog(catalogProperties.catalogHandle(), catalogProperties.connectorName(), connector, Optional.of(catalogProperties));
    }

    @Override
    public CatalogConnector createCatalog(CatalogHandle catalogHandle, ConnectorName connectorName, Connector connector) {
        return this.createCatalog(catalogHandle, connectorName, connector, Optional.empty());
    }

    private CatalogConnector createCatalog(CatalogHandle catalogHandle, ConnectorName connectorName, Connector connector, Optional<CatalogProperties> catalogProperties) {
        Tracer tracer = this.createTracer(catalogHandle);
        ConnectorServices catalogConnector = new ConnectorServices(tracer, catalogHandle, connector);
        ConnectorServices informationSchemaConnector = new ConnectorServices(tracer, CatalogHandle.createInformationSchemaCatalogHandle((CatalogHandle)catalogHandle), new InformationSchemaConnector(catalogHandle.getCatalogName().toString(), this.nodeManager, this.metadata, this.accessControl, this.maxPrefetchedInformationSchemaPrefixes));
        SystemTablesProvider systemTablesProvider = this.nodeManager.getCurrentNode().isCoordinator() ? new CoordinatorSystemTablesProvider(this.transactionManager, this.metadata, catalogHandle.getCatalogName().toString(), new StaticSystemTablesProvider(catalogConnector.getSystemTables())) : new StaticSystemTablesProvider(catalogConnector.getSystemTables());
        ConnectorServices systemConnector = new ConnectorServices(tracer, CatalogHandle.createSystemTablesCatalogHandle((CatalogHandle)catalogHandle), new SystemConnector(this.nodeManager, systemTablesProvider, transactionId -> this.transactionManager.getConnectorTransaction((TransactionId)transactionId, catalogHandle)));
        return new CatalogConnector(catalogHandle, connectorName, catalogConnector, informationSchemaConnector, systemConnector, catalogProperties);
    }

    private Connector createConnector(String catalogName, CatalogHandle catalogHandle, ConnectorFactory connectorFactory, Map<String, String> properties) {
        ConnectorContextInstance context = new ConnectorContextInstance(catalogHandle, this.openTelemetry, this.createTracer(catalogHandle), new ConnectorAwareNodeManager(this.nodeManager, this.nodeInfo.getEnvironment(), catalogHandle, this.schedulerIncludeCoordinator), this.versionEmbedder, this.typeManager, new InternalMetadataProvider(this.metadata, this.typeManager), this.pageSorter, this.pageIndexerFactory);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(connectorFactory.getClass().getClassLoader());){
            Connector connector = connectorFactory.create(catalogName, properties, (ConnectorContext)context);
            return connector;
        }
    }

    private Tracer createTracer(CatalogHandle catalogHandle) {
        return this.openTelemetry.getTracer("trino.catalog." + String.valueOf(catalogHandle.getCatalogName()));
    }
}

