/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.base.Verify;
import io.airlift.log.Logger;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.cost.CostCalculator;
import io.trino.cost.CostProvider;
import io.trino.cost.PlanCostEstimate;
import io.trino.cost.StatsProvider;
import io.trino.sql.planner.iterative.GroupReference;
import io.trino.sql.planner.iterative.Memo;
import io.trino.sql.planner.plan.PlanNode;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CachingCostProvider
implements CostProvider {
    private static final Logger log = Logger.get(CachingCostProvider.class);
    private final CostCalculator costCalculator;
    private final StatsProvider statsProvider;
    private final Optional<Memo> memo;
    private final Session session;
    private final Map<PlanNode, PlanCostEstimate> cache = new IdentityHashMap<PlanNode, PlanCostEstimate>();

    public CachingCostProvider(CostCalculator costCalculator, StatsProvider statsProvider, Session session) {
        this(costCalculator, statsProvider, Optional.empty(), session);
    }

    public CachingCostProvider(CostCalculator costCalculator, StatsProvider statsProvider, Optional<Memo> memo, Session session) {
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.statsProvider = Objects.requireNonNull(statsProvider, "statsProvider is null");
        this.memo = Objects.requireNonNull(memo, "memo is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    @Override
    public PlanCostEstimate getCost(PlanNode node) {
        if (!SystemSessionProperties.isEnableStatsCalculator(this.session)) {
            return PlanCostEstimate.unknown();
        }
        Objects.requireNonNull(node, "node is null");
        try {
            if (node instanceof GroupReference) {
                return this.getGroupCost((GroupReference)node);
            }
            PlanCostEstimate cost = this.cache.get(node);
            if (cost != null) {
                return cost;
            }
            cost = this.calculateCost(node);
            Verify.verify((this.cache.put(node, cost) == null ? 1 : 0) != 0, (String)"Cost already set", (Object[])new Object[0]);
            return cost;
        }
        catch (RuntimeException e) {
            if (SystemSessionProperties.isIgnoreStatsCalculatorFailures(this.session)) {
                log.error((Throwable)e, "Error occurred when computing cost for query %s", new Object[]{this.session.getQueryId()});
                return PlanCostEstimate.unknown();
            }
            throw e;
        }
    }

    private PlanCostEstimate getGroupCost(GroupReference groupReference) {
        int group = groupReference.getGroupId();
        Memo memo = this.memo.orElseThrow(() -> new IllegalStateException("CachingCostProvider without memo cannot handle GroupReferences"));
        Optional<PlanCostEstimate> knownCost = memo.getCost(group);
        if (knownCost.isPresent()) {
            return knownCost.get();
        }
        PlanCostEstimate cost = this.getCost(memo.getNode(group));
        Verify.verify((boolean)memo.getCost(group).isEmpty(), (String)"Group cost already set", (Object[])new Object[0]);
        memo.storeCost(group, cost);
        return cost;
    }

    private PlanCostEstimate calculateCost(PlanNode node) {
        return this.costCalculator.calculateCost(node, this.statsProvider, this, this.session);
    }
}

