/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.ParameterExtractor;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.MaterializedViewDefinition;
import io.trino.metadata.MaterializedViewPropertyManager;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.ViewColumn;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.SqlFormatterUtil;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.ConstantEvaluator;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.tree.CreateMaterializedView;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Statement;
import io.trino.type.IntervalDayTimeType;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class CreateMaterializedViewTask
implements DataDefinitionTask<CreateMaterializedView> {
    private final PlannerContext plannerContext;
    private final AccessControl accessControl;
    private final SqlParser sqlParser;
    private final AnalyzerFactory analyzerFactory;
    private final MaterializedViewPropertyManager materializedViewPropertyManager;

    @Inject
    public CreateMaterializedViewTask(PlannerContext plannerContext, AccessControl accessControl, SqlParser sqlParser, AnalyzerFactory analyzerFactory, MaterializedViewPropertyManager materializedViewPropertyManager) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.analyzerFactory = Objects.requireNonNull(analyzerFactory, "analyzerFactory is null");
        this.materializedViewPropertyManager = Objects.requireNonNull(materializedViewPropertyManager, "materializedViewPropertyManager is null");
    }

    @Override
    public String getName() {
        return "CREATE MATERIALIZED VIEW";
    }

    @Override
    public ListenableFuture<Void> execute(CreateMaterializedView statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Analysis analysis = this.executeInternal(statement, stateMachine.getSession(), parameters, warningCollector, stateMachine.getPlanOptimizersStatsCollector());
        stateMachine.setOutput(analysis.getTarget());
        stateMachine.setReferencedTables(analysis.getReferencedTables());
        return Futures.immediateVoidFuture();
    }

    @VisibleForTesting
    Analysis executeInternal(CreateMaterializedView statement, Session session, List<Expression> parameters, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        QualifiedObjectName name = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        Map<NodeRef<Parameter>, Expression> parameterLookup = ParameterExtractor.bindParameters((Statement)statement, parameters);
        String sql = SqlFormatterUtil.getFormattedSql((Statement)statement.getQuery(), this.sqlParser);
        Analysis analysis = this.analyzerFactory.createAnalyzer(session, parameters, parameterLookup, warningCollector, planOptimizersStatsCollector).analyze((Statement)statement);
        List columns = (List)analysis.getOutputDescriptor((Node)statement.getQuery()).getVisibleFields().stream().map(field -> new ViewColumn(field.getName().get(), field.getType().getTypeId(), Optional.empty())).collect(ImmutableList.toImmutableList());
        String catalogName = name.getCatalogName();
        CatalogHandle catalogHandle = MetadataUtil.getRequiredCatalogHandle(this.plannerContext.getMetadata(), session, (Node)statement, catalogName);
        Map properties = this.materializedViewPropertyManager.getProperties(catalogName, catalogHandle, (Iterable)statement.getProperties(), session, this.plannerContext, this.accessControl, (Map)parameterLookup, true);
        Optional<Duration> gracePeriod = statement.getGracePeriod().map(expression -> {
            if (!this.plannerContext.getMetadata().getConnectorCapabilities(session, catalogHandle).contains(ConnectorCapabilities.MATERIALIZED_VIEW_GRACE_PERIOD)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Catalog '%s' does not support GRACE PERIOD", catalogName);
            }
            Type type = analysis.getType((Expression)expression);
            if (type != IntervalDayTimeType.INTERVAL_DAY_TIME) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, "Unsupported grace period type %s, expected %s".formatted(type.getDisplayName(), IntervalDayTimeType.INTERVAL_DAY_TIME.getDisplayName()));
            }
            Long milliseconds = (Long)ConstantEvaluator.evaluateConstant((Expression)expression, type, this.plannerContext, session, this.accessControl);
            Verify.verify((milliseconds != null ? 1 : 0) != 0, (String)"Grace period cannot be null", (Object[])new Object[0]);
            return Duration.ofMillis(milliseconds);
        });
        MaterializedViewDefinition definition = new MaterializedViewDefinition(sql, session.getCatalog(), session.getSchema(), columns, gracePeriod, statement.getComment(), session.getIdentity(), (List)session.getPath().getPath().stream().filter(element -> !element.getCatalogName().equals("system")).collect(ImmutableList.toImmutableList()), Optional.empty());
        Set specifiedPropertyKeys = (Set)statement.getProperties().stream().map(property -> property.getName().getValue().toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
        Map explicitlySetProperties = (Map)properties.keySet().stream().peek(key -> Verify.verify((boolean)key.equals(key.toLowerCase(Locale.ENGLISH)), (String)"Property name '%s' not in lower-case", (Object)key)).filter(specifiedPropertyKeys::contains).collect(ImmutableMap.toImmutableMap(Function.identity(), properties::get));
        this.accessControl.checkCanCreateMaterializedView(session.toSecurityContext(), name, explicitlySetProperties);
        this.plannerContext.getMetadata().createMaterializedView(session, name, definition, properties, statement.isReplace(), statement.isNotExists());
        return analysis;
    }
}

