/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.errorprone.annotations.ThreadSafe;
import io.trino.execution.TableExecuteContext;
import io.trino.spi.QueryId;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@ThreadSafe
public class TableExecuteContextManager {
    private final ConcurrentMap<QueryId, TableExecuteContext> contexts = new ConcurrentHashMap<QueryId, TableExecuteContext>();

    public void registerTableExecuteContextForQuery(QueryId queryId) {
        TableExecuteContext newContext = new TableExecuteContext();
        if (this.contexts.putIfAbsent(queryId, newContext) != null) {
            throw new IllegalStateException("TableExecuteContext already registered for query " + String.valueOf(queryId));
        }
    }

    public void unregisterTableExecuteContextForQuery(QueryId queryId) {
        this.contexts.remove(queryId);
    }

    public TableExecuteContext getTableExecuteContextForQuery(QueryId queryId) {
        TableExecuteContext context = (TableExecuteContext)this.contexts.get(queryId);
        if (context == null) {
            throw new IllegalStateException("TableExecuteContext not registered for query " + String.valueOf(queryId));
        }
        return context;
    }
}

