/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.log.Logger;
import io.airlift.stats.CounterStat;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.RemoteTask;
import io.trino.execution.scheduler.BucketNodeMap;
import io.trino.execution.scheduler.NetworkLocation;
import io.trino.execution.scheduler.NetworkTopology;
import io.trino.execution.scheduler.NodeAssignmentStats;
import io.trino.execution.scheduler.NodeMap;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.NodeSelector;
import io.trino.execution.scheduler.ResettableRandomizedIterator;
import io.trino.execution.scheduler.SplitPlacementResult;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.Split;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import jakarta.annotation.Nullable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class TopologyAwareNodeSelector
implements NodeSelector {
    private static final Logger log = Logger.get(TopologyAwareNodeSelector.class);
    private final InternalNodeManager nodeManager;
    private final NodeTaskMap nodeTaskMap;
    private final boolean includeCoordinator;
    private final AtomicReference<Supplier<NodeMap>> nodeMap;
    private final int minCandidates;
    private final long maxSplitsWeightPerNode;
    private final long maxPendingSplitsWeightPerTask;
    private final int maxUnacknowledgedSplitsPerTask;
    private final List<CounterStat> topologicalSplitCounters;
    private final NetworkTopology networkTopology;

    public TopologyAwareNodeSelector(InternalNodeManager nodeManager, NodeTaskMap nodeTaskMap, boolean includeCoordinator, Supplier<NodeMap> nodeMap, int minCandidates, long maxSplitsWeightPerNode, long maxPendingSplitsWeightPerTask, int maxUnacknowledgedSplitsPerTask, List<CounterStat> topologicalSplitCounters, NetworkTopology networkTopology) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        this.includeCoordinator = includeCoordinator;
        this.nodeMap = new AtomicReference<Supplier<NodeMap>>(nodeMap);
        this.minCandidates = minCandidates;
        this.maxSplitsWeightPerNode = maxSplitsWeightPerNode;
        this.maxPendingSplitsWeightPerTask = maxPendingSplitsWeightPerTask;
        this.maxUnacknowledgedSplitsPerTask = maxUnacknowledgedSplitsPerTask;
        Preconditions.checkArgument((maxUnacknowledgedSplitsPerTask > 0 ? 1 : 0) != 0, (String)"maxUnacknowledgedSplitsPerTask must be > 0, found: %s", (int)maxUnacknowledgedSplitsPerTask);
        this.topologicalSplitCounters = Objects.requireNonNull(topologicalSplitCounters, "topologicalSplitCounters is null");
        this.networkTopology = Objects.requireNonNull(networkTopology, "networkTopology is null");
    }

    @Override
    public void lockDownNodes() {
        this.nodeMap.set((Supplier<NodeMap>)Suppliers.ofInstance((Object)this.nodeMap.get().get()));
    }

    @Override
    public List<InternalNode> allNodes() {
        return NodeScheduler.getAllNodes(this.nodeMap.get().get(), this.includeCoordinator);
    }

    @Override
    public InternalNode selectCurrentNode() {
        return this.nodeManager.getCurrentNode();
    }

    @Override
    public List<InternalNode> selectRandomNodes(int limit, Set<InternalNode> excludedNodes) {
        return NodeScheduler.selectNodes(limit, NodeScheduler.randomizedNodes(this.nodeMap.get().get(), this.includeCoordinator, excludedNodes));
    }

    @Override
    public SplitPlacementResult computeAssignments(Set<Split> splits, List<RemoteTask> existingTasks) {
        NodeMap nodeMap = this.nodeMap.get().get();
        HashMultimap assignment = HashMultimap.create();
        NodeAssignmentStats assignmentStats = new NodeAssignmentStats(this.nodeTaskMap, nodeMap, existingTasks);
        int[] topologicCounters = new int[this.topologicalSplitCounters.size()];
        HashSet<NetworkLocation> filledLocations = new HashSet<NetworkLocation>();
        HashSet<InternalNode> blockedExactNodes = new HashSet<InternalNode>();
        boolean splitWaitingForAnyNode = false;
        for (Split split : splits) {
            SplitWeight splitWeight = split.getSplitWeight();
            if (!split.isRemotelyAccessible()) {
                List<InternalNode> candidateNodes = NodeScheduler.selectExactNodes(nodeMap, split.getAddresses(), this.includeCoordinator);
                if (candidateNodes.isEmpty()) {
                    log.debug("No nodes available to schedule %s. Available nodes %s", new Object[]{split, nodeMap.getNodesByHost().keys()});
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query");
                }
                InternalNode chosenNode = this.bestNodeSplitCount(splitWeight, candidateNodes.iterator(), this.minCandidates, this.maxPendingSplitsWeightPerTask, assignmentStats);
                if (chosenNode != null) {
                    assignment.put((Object)chosenNode, (Object)split);
                    assignmentStats.addAssignedSplit(chosenNode, splitWeight);
                    continue;
                }
                if (splitWaitingForAnyNode) continue;
                blockedExactNodes.addAll(candidateNodes);
                continue;
            }
            InternalNode chosenNode = null;
            int depth = this.topologicalSplitCounters.size() - 1;
            int chosenDepth = 0;
            HashSet<NetworkLocation> locations = new HashSet<NetworkLocation>();
            for (HostAddress host : split.getAddresses()) {
                locations.add(this.networkTopology.locate(host));
            }
            if (locations.isEmpty()) {
                locations.add(NetworkLocation.ROOT_LOCATION);
                depth = 0;
            }
            block2: for (int i = depth; i >= 0 && chosenNode == null; --i) {
                for (NetworkLocation location : locations) {
                    if (location.getSegments().size() < i || filledLocations.contains(location = location.subLocation(0, i))) continue;
                    Set nodes = nodeMap.getWorkersByNetworkPath().get((Object)location);
                    chosenNode = this.bestNodeSplitCount(splitWeight, new ResettableRandomizedIterator<InternalNode>(nodes), this.minCandidates, this.calculateMinPendingSplitsWeightPerTask(i, depth), assignmentStats);
                    if (chosenNode != null) {
                        chosenDepth = i;
                        continue block2;
                    }
                    filledLocations.add(location);
                }
            }
            if (chosenNode != null) {
                assignment.put(chosenNode, (Object)split);
                assignmentStats.addAssignedSplit(chosenNode, splitWeight);
                int n = chosenDepth;
                topologicCounters[n] = topologicCounters[n] + 1;
                continue;
            }
            splitWaitingForAnyNode = true;
        }
        for (int i = 0; i < topologicCounters.length; ++i) {
            if (topologicCounters[i] <= 0) continue;
            this.topologicalSplitCounters.get(i).update((long)topologicCounters[i]);
        }
        long minPendingForWildcardNetworkAffinity = this.calculateMinPendingSplitsWeightPerTask(0, this.topologicalSplitCounters.size() - 1);
        ListenableFuture<Void> blocked = splitWaitingForAnyNode ? NodeScheduler.toWhenHasSplitQueueSpaceFuture(existingTasks, NodeScheduler.calculateLowWatermark(minPendingForWildcardNetworkAffinity)) : NodeScheduler.toWhenHasSplitQueueSpaceFuture(blockedExactNodes, existingTasks, NodeScheduler.calculateLowWatermark(minPendingForWildcardNetworkAffinity));
        return new SplitPlacementResult(blocked, (Multimap<InternalNode, Split>)assignment);
    }

    private long calculateMinPendingSplitsWeightPerTask(int splitAffinity, int totalDepth) {
        if (totalDepth == 0) {
            return this.maxPendingSplitsWeightPerTask;
        }
        double queueFraction = 0.5 * (1.0 + (double)splitAffinity / (double)totalDepth);
        return (long)Math.ceil((double)this.maxPendingSplitsWeightPerTask * queueFraction);
    }

    @Override
    public SplitPlacementResult computeAssignments(Set<Split> splits, List<RemoteTask> existingTasks, BucketNodeMap bucketNodeMap) {
        return NodeScheduler.selectDistributionNodes(this.nodeMap.get().get(), this.nodeTaskMap, this.maxSplitsWeightPerNode, this.maxPendingSplitsWeightPerTask, this.maxUnacknowledgedSplitsPerTask, splits, existingTasks, bucketNodeMap);
    }

    @Nullable
    private InternalNode bestNodeSplitCount(SplitWeight splitWeight, Iterator<InternalNode> candidates, int minCandidatesWhenFull, long minPendingSplitsWeightPerTask, NodeAssignmentStats assignmentStats) {
        InternalNode bestQueueNotFull = null;
        long minWeight = Long.MAX_VALUE;
        int fullCandidatesConsidered = 0;
        while (candidates.hasNext() && (fullCandidatesConsidered < minCandidatesWhenFull || bestQueueNotFull == null)) {
            InternalNode node = candidates.next();
            if (assignmentStats.getUnacknowledgedSplitCountForStage(node) >= this.maxUnacknowledgedSplitsPerTask) {
                ++fullCandidatesConsidered;
                continue;
            }
            if (NodeScheduler.canAssignSplitBasedOnWeight(assignmentStats.getTotalSplitsWeight(node), this.maxSplitsWeightPerNode, splitWeight)) {
                return node;
            }
            ++fullCandidatesConsidered;
            long taskQueuedWeight = assignmentStats.getQueuedSplitsWeightForStage(node);
            if (taskQueuedWeight >= minWeight || !NodeScheduler.canAssignSplitBasedOnWeight(taskQueuedWeight, minPendingSplitsWeightPerTask, splitWeight)) continue;
            minWeight = taskQueuedWeight;
            bestQueueNotFull = node;
        }
        return bestQueueNotFull;
    }
}

