/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import io.trino.cache.NonEvictableCache;
import io.trino.cache.SafeCaches;
import io.trino.json.IrPathNodeRef;
import io.trino.json.ir.IrPathNode;
import io.trino.metadata.Metadata;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

public class CachingResolver {
    private static final int MAX_CACHE_SIZE = 1000;
    private final Metadata metadata;
    private final NonEvictableCache<NodeAndTypes, ResolvedOperatorAndCoercions> operators = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L));

    public CachingResolver(Metadata metadata) {
        Objects.requireNonNull(metadata, "metadata is null");
        this.metadata = metadata;
    }

    public ResolvedOperatorAndCoercions getOperators(IrPathNode node, OperatorType operatorType, Type leftType, Type rightType) {
        try {
            return (ResolvedOperatorAndCoercions)this.operators.get((Object)new NodeAndTypes(IrPathNodeRef.of(node), leftType, rightType), () -> this.resolveOperators(operatorType, leftType, rightType));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private ResolvedOperatorAndCoercions resolveOperators(OperatorType operatorType, Type leftType, Type rightType) {
        ResolvedFunction operator;
        try {
            operator = this.metadata.resolveOperator(operatorType, (List<? extends Type>)ImmutableList.of((Object)leftType, (Object)rightType));
        }
        catch (OperatorNotFoundException e) {
            return ResolvedOperatorAndCoercions.RESOLUTION_ERROR;
        }
        BoundSignature signature = operator.getSignature();
        Optional<ResolvedFunction> leftCast = Optional.empty();
        if (!((Type)signature.getArgumentTypes().get(0)).equals((Object)leftType)) {
            try {
                leftCast = Optional.of(this.metadata.getCoercion(leftType, (Type)signature.getArgumentTypes().get(0)));
            }
            catch (OperatorNotFoundException e) {
                return ResolvedOperatorAndCoercions.RESOLUTION_ERROR;
            }
        }
        Optional<ResolvedFunction> rightCast = Optional.empty();
        if (!((Type)signature.getArgumentTypes().get(1)).equals((Object)rightType)) {
            try {
                rightCast = Optional.of(this.metadata.getCoercion(rightType, (Type)signature.getArgumentTypes().get(1)));
            }
            catch (OperatorNotFoundException e) {
                return ResolvedOperatorAndCoercions.RESOLUTION_ERROR;
            }
        }
        return ResolvedOperatorAndCoercions.operators(operator, leftCast, rightCast);
    }

    private static class NodeAndTypes {
        private final IrPathNodeRef<IrPathNode> node;
        private final Type leftType;
        private final Type rightType;

        public NodeAndTypes(IrPathNodeRef<IrPathNode> node, Type leftType, Type rightType) {
            this.node = node;
            this.leftType = leftType;
            this.rightType = rightType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeAndTypes that = (NodeAndTypes)o;
            return Objects.equals(this.node, that.node) && Objects.equals(this.leftType, that.leftType) && Objects.equals(this.rightType, that.rightType);
        }

        public int hashCode() {
            return Objects.hash(this.node, this.leftType, this.rightType);
        }
    }

    public static class ResolvedOperatorAndCoercions {
        public static final ResolvedOperatorAndCoercions RESOLUTION_ERROR = new ResolvedOperatorAndCoercions(null, Optional.empty(), Optional.empty());
        private final ResolvedFunction operator;
        private final Optional<ResolvedFunction> leftCoercion;
        private final Optional<ResolvedFunction> rightCoercion;

        public static ResolvedOperatorAndCoercions operators(ResolvedFunction operator, Optional<ResolvedFunction> leftCoercion, Optional<ResolvedFunction> rightCoercion) {
            return new ResolvedOperatorAndCoercions(Objects.requireNonNull(operator, "operator is null"), leftCoercion, rightCoercion);
        }

        private ResolvedOperatorAndCoercions(ResolvedFunction operator, Optional<ResolvedFunction> leftCoercion, Optional<ResolvedFunction> rightCoercion) {
            this.operator = operator;
            this.leftCoercion = Objects.requireNonNull(leftCoercion, "leftCoercion is null");
            this.rightCoercion = Objects.requireNonNull(rightCoercion, "rightCoercion is null");
        }

        public ResolvedFunction getOperator() {
            Preconditions.checkState((this != RESOLUTION_ERROR ? 1 : 0) != 0, (Object)"accessing operator on RESOLUTION_ERROR");
            return this.operator;
        }

        public Optional<ResolvedFunction> getLeftCoercion() {
            Preconditions.checkState((this != RESOLUTION_ERROR ? 1 : 0) != 0, (Object)"accessing coercion on RESOLUTION_ERROR");
            return this.leftCoercion;
        }

        public Optional<ResolvedFunction> getRightCoercion() {
            Preconditions.checkState((this != RESOLUTION_ERROR ? 1 : 0) != 0, (Object)"accessing coercion on RESOLUTION_ERROR");
            return this.rightCoercion;
        }
    }
}

