/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.connector.ConnectorServices;
import io.trino.metadata.CatalogMetadata;
import io.trino.metadata.CatalogTransaction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorName;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.transaction.InternalConnector;
import io.trino.transaction.TransactionId;
import java.util.Objects;

public class Catalog {
    private final CatalogName catalogName;
    private final CatalogHandle catalogHandle;
    private final ConnectorName connectorName;
    private final ConnectorServices catalogConnector;
    private final ConnectorServices informationSchemaConnector;
    private final ConnectorServices systemConnector;

    public Catalog(CatalogName catalogName, CatalogHandle catalogHandle, ConnectorName connectorName, ConnectorServices catalogConnector, ConnectorServices informationSchemaConnector, ConnectorServices systemConnector) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        Preconditions.checkArgument((!catalogHandle.getType().isInternal() ? 1 : 0) != 0, (Object)"Internal catalogName not allowed");
        this.connectorName = Objects.requireNonNull(connectorName, "connectorName is null");
        this.catalogConnector = Objects.requireNonNull(catalogConnector, "catalogConnector is null");
        this.informationSchemaConnector = Objects.requireNonNull(informationSchemaConnector, "informationSchemaConnector is null");
        this.systemConnector = Objects.requireNonNull(systemConnector, "systemConnector is null");
    }

    public static Catalog failedCatalog(CatalogName catalogName, CatalogHandle catalogHandle, ConnectorName connectorName) {
        return new Catalog(catalogName, catalogHandle, connectorName);
    }

    private Catalog(CatalogName catalogName, CatalogHandle catalogHandle, ConnectorName connectorName) {
        this.catalogName = catalogName;
        this.catalogHandle = catalogHandle;
        this.connectorName = connectorName;
        this.catalogConnector = null;
        this.informationSchemaConnector = null;
        this.systemConnector = null;
    }

    public CatalogName getCatalogName() {
        return this.catalogName;
    }

    public CatalogHandle getCatalogHandle() {
        return this.catalogHandle;
    }

    public ConnectorName getConnectorName() {
        return this.connectorName;
    }

    public boolean isFailed() {
        return this.catalogConnector == null;
    }

    public void verify() {
        if (this.catalogConnector == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.CATALOG_UNAVAILABLE, String.format("Catalog '%s' failed to initialize and is disabled", this.catalogName));
        }
    }

    public CatalogMetadata beginTransaction(TransactionId transactionId, IsolationLevel isolationLevel, boolean readOnly, boolean autoCommitContext) {
        this.verify();
        CatalogTransaction catalogTransaction = Catalog.beginTransaction(this.catalogConnector, transactionId, isolationLevel, readOnly, autoCommitContext);
        CatalogTransaction informationSchemaTransaction = Catalog.beginTransaction(this.informationSchemaConnector, transactionId, isolationLevel, readOnly, autoCommitContext);
        CatalogTransaction systemTransaction = Catalog.beginTransaction(this.systemConnector, transactionId, isolationLevel, readOnly, autoCommitContext);
        return new CatalogMetadata(this.catalogName, catalogTransaction, informationSchemaTransaction, systemTransaction, this.catalogConnector.getSecurityManagement(), this.catalogConnector.getCapabilities());
    }

    private static CatalogTransaction beginTransaction(ConnectorServices connectorServices, TransactionId transactionId, IsolationLevel isolationLevel, boolean readOnly, boolean autoCommitContext) {
        Connector connector = connectorServices.getConnector();
        ConnectorTransactionHandle transactionHandle = connector instanceof InternalConnector ? ((InternalConnector)connector).beginTransaction(transactionId, isolationLevel, readOnly) : connector.beginTransaction(isolationLevel, readOnly, autoCommitContext);
        return new CatalogTransaction(connectorServices.getTracer(), connectorServices.getCatalogHandle(), connector, transactionHandle);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalogName", (Object)this.catalogName).add("catalogHandle", (Object)this.catalogHandle).toString();
    }
}

