/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ResolvedFunction {
    private final BoundSignature signature;
    private final CatalogHandle catalogHandle;
    private final FunctionId functionId;
    private final FunctionKind functionKind;
    private final boolean deterministic;
    private final FunctionNullability functionNullability;
    private final Map<TypeSignature, Type> typeDependencies;
    private final Set<ResolvedFunction> functionDependencies;

    @JsonCreator
    public ResolvedFunction(@JsonProperty(value="signature") BoundSignature signature, @JsonProperty(value="catalogHandle") CatalogHandle catalogHandle, @JsonProperty(value="id") FunctionId functionId, @JsonProperty(value="functionKind") FunctionKind functionKind, @JsonProperty(value="deterministic") boolean deterministic, @JsonProperty(value="functionNullability") FunctionNullability functionNullability, @JsonProperty(value="typeDependencies") Map<TypeSignature, Type> typeDependencies, @JsonProperty(value="functionDependencies") Set<ResolvedFunction> functionDependencies) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        this.functionId = Objects.requireNonNull(functionId, "functionId is null");
        this.functionKind = Objects.requireNonNull(functionKind, "functionKind is null");
        this.deterministic = deterministic;
        this.functionNullability = Objects.requireNonNull(functionNullability, "functionNullability is null");
        this.typeDependencies = ImmutableMap.copyOf(Objects.requireNonNull(typeDependencies, "typeDependencies is null"));
        this.functionDependencies = ImmutableSet.copyOf((Collection)Objects.requireNonNull(functionDependencies, "functionDependencies is null"));
        Preconditions.checkArgument((functionNullability.getArgumentNullable().size() == signature.getArgumentTypes().size() ? 1 : 0) != 0, (Object)"signature and functionNullability must have same argument count");
    }

    @JsonProperty
    public BoundSignature getSignature() {
        return this.signature;
    }

    @JsonProperty
    public CatalogHandle getCatalogHandle() {
        return this.catalogHandle;
    }

    @JsonProperty(value="id")
    public FunctionId getFunctionId() {
        return this.functionId;
    }

    @JsonProperty(value="functionKind")
    public FunctionKind getFunctionKind() {
        return this.functionKind;
    }

    @JsonProperty
    public boolean isDeterministic() {
        return this.deterministic;
    }

    @JsonProperty
    public FunctionNullability getFunctionNullability() {
        return this.functionNullability;
    }

    @JsonProperty
    public Map<TypeSignature, Type> getTypeDependencies() {
        return this.typeDependencies;
    }

    @JsonProperty
    public Set<ResolvedFunction> getFunctionDependencies() {
        return this.functionDependencies;
    }

    public CatalogSchemaFunctionName getName() {
        return this.getSignature().getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedFunction that = (ResolvedFunction)o;
        return Objects.equals(this.signature, that.signature) && Objects.equals(this.catalogHandle, that.catalogHandle) && Objects.equals(this.functionId, that.functionId) && this.functionKind == that.functionKind && this.deterministic == that.deterministic && Objects.equals(this.functionNullability, that.functionNullability) && Objects.equals(this.typeDependencies, that.typeDependencies) && Objects.equals(this.functionDependencies, that.functionDependencies);
    }

    public int hashCode() {
        return Objects.hash(this.signature, this.catalogHandle, this.functionId, this.functionKind, this.deterministic, this.functionNullability, this.typeDependencies, this.functionDependencies);
    }

    public String toString() {
        return this.signature.toString();
    }
}

