/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.MoreCollectors;
import io.trino.metadata.QualifiedObjectName;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.ColumnSchema;
import io.trino.spi.connector.ConnectorTableSchema;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class TableSchema {
    private final CatalogName catalogName;
    private final ConnectorTableSchema tableSchema;

    public TableSchema(CatalogName catalogName, ConnectorTableSchema tableSchema) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(tableSchema, "metadata is null");
        this.catalogName = catalogName;
        this.tableSchema = tableSchema;
    }

    public QualifiedObjectName getQualifiedName() {
        return new QualifiedObjectName(this.catalogName.toString(), this.tableSchema.getTable().getSchemaName(), this.tableSchema.getTable().getTableName());
    }

    public CatalogName getCatalogName() {
        return this.catalogName;
    }

    public ConnectorTableSchema getTableSchema() {
        return this.tableSchema;
    }

    public SchemaTableName getTable() {
        return this.tableSchema.getTable();
    }

    public List<ColumnSchema> getColumns() {
        return this.tableSchema.getColumns();
    }

    public ColumnSchema getColumn(String name) {
        return (ColumnSchema)((Optional)this.tableSchema.getColumns().stream().filter(columnMetadata -> columnMetadata.getName().equals(name)).collect(MoreCollectors.toOptional())).orElseThrow(() -> new IllegalArgumentException("Invalid column name: " + name));
    }
}

