/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.ForLoop;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.jmx.CacheStatsMBean;
import io.trino.cache.SafeCaches;
import io.trino.operator.FlatHashStrategy;
import io.trino.operator.scalar.CombineHashFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.gen.Bootstrap;
import io.trino.sql.gen.BytecodeUtils;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.sql.gen.SqlTypeBytecodeExpression;
import io.trino.util.CompilerUtils;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.assertj.core.util.VisibleForTesting;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public final class FlatHashStrategyCompiler {
    private final LoadingCache<List<Type>, FlatHashStrategy> flatHashStrategies = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().recordStats().maximumSize(1000L), (CacheLoader)CacheLoader.from(key -> FlatHashStrategyCompiler.compileFlatHashStrategy(key, typeOperators)));

    @Inject
    public FlatHashStrategyCompiler(TypeOperators typeOperators) {
    }

    public FlatHashStrategy getFlatHashStrategy(List<Type> types) {
        return (FlatHashStrategy)this.flatHashStrategies.getUnchecked((Object)ImmutableList.copyOf(types));
    }

    @Managed
    @Nested
    public CacheStatsMBean getFlatHashStrategiesStats() {
        return new CacheStatsMBean(this.flatHashStrategies);
    }

    @VisibleForTesting
    public static FlatHashStrategy compileFlatHashStrategy(List<Type> types, TypeOperators typeOperators) {
        ArrayList<KeyField> keyFields = new ArrayList<KeyField>();
        int fixedOffset = 0;
        for (int i = 0; i < types.size(); ++i) {
            Type type = types.get(i);
            keyFields.add(new KeyField(i, type, fixedOffset, fixedOffset + 1, typeOperators.getReadValueOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT})), typeOperators.getReadValueOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FLAT_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL})), typeOperators.getDistinctFromOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL})), typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT})), typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}))));
            fixedOffset += 1 + type.getFlatFixedSize();
        }
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ArrayList<ChunkClass> chunkClasses = new ArrayList<ChunkClass>();
        int chunkNumber = 0;
        for (List chunk : Lists.partition(keyFields, (int)500)) {
            chunkClasses.add(FlatHashStrategyCompiler.compileFlatHashStrategyChunk(callSiteBinder, chunk, chunkNumber));
            ++chunkNumber;
        }
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("FlatHashStrategy"), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(FlatHashStrategy.class)});
        FieldDefinition typesField = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "types", ParameterizedType.type(List.class, (Class[])new Class[]{Type.class}));
        MethodDefinition constructor = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        constructor.getBody().append((BytecodeNode)constructor.getThis()).invokeConstructor(Object.class, new Class[0]).append((BytecodeNode)constructor.getThis().setField(typesField, BytecodeUtils.loadConstant(callSiteBinder, ImmutableList.copyOf(types), List.class))).ret();
        boolean anyVariableWidth = (int)types.stream().filter(Type::isFlatVariableWidth).count() > 0;
        definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "isAnyVariableWidth", ParameterizedType.type(Boolean.TYPE), new Parameter[0]).getBody().append((BytecodeNode)BytecodeExpressions.constantBoolean((boolean)anyVariableWidth).ret());
        definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getTotalFlatFixedLength", ParameterizedType.type(Integer.TYPE), new Parameter[0]).getBody().append((BytecodeNode)BytecodeExpressions.constantInt((int)fixedOffset).ret());
        FlatHashStrategyCompiler.generateGetTotalVariableWidth(definition, chunkClasses);
        FlatHashStrategyCompiler.generateReadFlat(definition, chunkClasses);
        FlatHashStrategyCompiler.generateWriteFlat(definition, chunkClasses);
        FlatHashStrategyCompiler.generateNotDistinctFromMethod(definition, chunkClasses);
        FlatHashStrategyCompiler.generateHashBlock(definition, chunkClasses);
        FlatHashStrategyCompiler.generateHashFlat(definition, chunkClasses);
        FlatHashStrategyCompiler.generateHashBlocksBatched(definition, chunkClasses);
        try {
            DynamicClassLoader classLoader = new DynamicClassLoader(FlatHashStrategyCompiler.class.getClassLoader(), callSiteBinder.getBindings());
            for (ChunkClass chunkClass : chunkClasses) {
                CompilerUtils.defineClass(chunkClass.definition(), Object.class, classLoader);
            }
            return CompilerUtils.defineClass(definition, FlatHashStrategy.class, classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static ChunkClass compileFlatHashStrategyChunk(CallSiteBinder callSiteBinder, List<KeyField> keyFields, int chunkNumber) {
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("FlatHashStrategyChunk$" + chunkNumber), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(FlatHashStrategy.class)});
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        MethodDefinition getTotalVariableWidthChunk = FlatHashStrategyCompiler.generateGetTotalVariableWidthChunk(definition, keyFields, callSiteBinder);
        MethodDefinition readFlatChunk = FlatHashStrategyCompiler.generateReadFlatChunk(definition, keyFields, callSiteBinder);
        MethodDefinition writeFlatChunk = FlatHashStrategyCompiler.generateWriteFlatChunk(definition, keyFields, callSiteBinder);
        MethodDefinition notDistinctFromMethodChunk = FlatHashStrategyCompiler.generateNotDistinctFromMethodChunk(definition, keyFields, callSiteBinder);
        MethodDefinition hashBlockChunk = FlatHashStrategyCompiler.generateHashBlockChunk(definition, keyFields, callSiteBinder);
        MethodDefinition hashFlatChunk = FlatHashStrategyCompiler.generateHashFlatChunk(definition, keyFields, callSiteBinder);
        MethodDefinition hashBlocksBatchedChunk = FlatHashStrategyCompiler.generateHashBlocksBatchedChunk(definition, keyFields, callSiteBinder);
        return new ChunkClass(definition, getTotalVariableWidthChunk, readFlatChunk, writeFlatChunk, notDistinctFromMethodChunk, hashBlockChunk, hashFlatChunk, hashBlocksBatchedChunk);
    }

    private static void generateGetTotalVariableWidth(ClassDefinition definition, List<ChunkClass> chunkClasses) {
        Parameter blocks = Parameter.arg((String)"blocks", (ParameterizedType)ParameterizedType.type(Block[].class));
        Parameter position = Parameter.arg((String)"position", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getTotalVariableWidth", ParameterizedType.type(Integer.TYPE), new Parameter[]{blocks, position});
        BytecodeBlock body = methodDefinition.getBody();
        Scope scope = methodDefinition.getScope();
        Variable variableWidth = scope.declareVariable("variableWidth", body, BytecodeExpressions.constantLong((long)0L));
        for (ChunkClass chunkClass : chunkClasses) {
            body.append((BytecodeNode)variableWidth.set(BytecodeExpressions.add((BytecodeExpression)variableWidth, (BytecodeExpression)BytecodeExpressions.invokeStatic((MethodDefinition)chunkClass.getTotalVariableWidth(), (BytecodeExpression[])new BytecodeExpression[]{blocks, position}))));
        }
        body.append((BytecodeNode)BytecodeExpressions.invokeStatic(Math.class, (String)"toIntExact", Integer.TYPE, (BytecodeExpression[])new BytecodeExpression[]{variableWidth}).ret());
    }

    private static MethodDefinition generateGetTotalVariableWidthChunk(ClassDefinition definition, List<KeyField> keyFields, CallSiteBinder callSiteBinder) {
        Parameter blocks = Parameter.arg((String)"blocks", (ParameterizedType)ParameterizedType.type(Block[].class));
        Parameter position = Parameter.arg((String)"position", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "getTotalVariableWidth", ParameterizedType.type(Long.TYPE), new Parameter[]{blocks, position});
        BytecodeBlock body = methodDefinition.getBody();
        Scope scope = methodDefinition.getScope();
        Variable variableWidth = scope.declareVariable("variableWidth", body, BytecodeExpressions.constantLong((long)0L));
        for (KeyField keyField : keyFields) {
            Type type = keyField.type();
            if (!type.isFlatVariableWidth()) continue;
            body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.not((BytecodeExpression)blocks.getElement(keyField.index()).invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position}))).ifTrue((BytecodeNode)variableWidth.set(BytecodeExpressions.add((BytecodeExpression)variableWidth, (BytecodeExpression)SqlTypeBytecodeExpression.constantType(callSiteBinder, type).invoke("getFlatVariableWidthSize", Integer.TYPE, new BytecodeExpression[]{blocks.getElement(keyField.index()), position}).cast(Long.TYPE)))));
        }
        body.append((BytecodeNode)variableWidth.ret());
        return methodDefinition;
    }

    private static void generateReadFlat(ClassDefinition definition, List<ChunkClass> chunkClasses) {
        Parameter fixedChunk = Parameter.arg((String)"fixedChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter fixedOffset = Parameter.arg((String)"fixedOffset", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        Parameter variableChunk = Parameter.arg((String)"variableChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter blockBuilders = Parameter.arg((String)"blockBuilders", (ParameterizedType)ParameterizedType.type(BlockBuilder[].class));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "readFlat", ParameterizedType.type(Void.TYPE), new Parameter[]{fixedChunk, fixedOffset, variableChunk, blockBuilders});
        BytecodeBlock body = methodDefinition.getBody();
        for (ChunkClass chunkClass : chunkClasses) {
            body.append((BytecodeNode)BytecodeExpressions.invokeStatic((MethodDefinition)chunkClass.readFlatChunk(), (BytecodeExpression[])new BytecodeExpression[]{fixedChunk, fixedOffset, variableChunk, blockBuilders}));
        }
        body.ret();
    }

    private static MethodDefinition generateReadFlatChunk(ClassDefinition definition, List<KeyField> keyFields, CallSiteBinder callSiteBinder) {
        Parameter fixedChunk = Parameter.arg((String)"fixedChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter fixedOffset = Parameter.arg((String)"fixedOffset", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        Parameter variableChunk = Parameter.arg((String)"variableChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter blockBuilders = Parameter.arg((String)"blockBuilders", (ParameterizedType)ParameterizedType.type(BlockBuilder[].class));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "readFlat", ParameterizedType.type(Void.TYPE), new Parameter[]{fixedChunk, fixedOffset, variableChunk, blockBuilders});
        BytecodeBlock body = methodDefinition.getBody();
        for (KeyField keyField : keyFields) {
            body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.notEqual((BytecodeExpression)fixedChunk.getElement(BytecodeExpressions.add((BytecodeExpression)fixedOffset, (BytecodeExpression)BytecodeExpressions.constantInt((int)keyField.fieldIsNullOffset()))).cast(Integer.TYPE), (BytecodeExpression)BytecodeExpressions.constantInt((int)0))).ifTrue((BytecodeNode)blockBuilders.getElement(keyField.index()).invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)new BytecodeBlock().append((BytecodeNode)BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)callSiteBinder.bind(keyField.readFlatMethod()).getBindingId()), (String)"readFlat", Void.TYPE, (BytecodeExpression[])new BytecodeExpression[]{fixedChunk, BytecodeExpressions.add((BytecodeExpression)fixedOffset, (BytecodeExpression)BytecodeExpressions.constantInt((int)keyField.fieldFixedOffset())), variableChunk, blockBuilders.getElement(keyField.index())}))));
        }
        body.ret();
        return methodDefinition;
    }

    private static void generateWriteFlat(ClassDefinition definition, List<ChunkClass> chunkClasses) {
        Parameter blocks = Parameter.arg((String)"blocks", (ParameterizedType)ParameterizedType.type(Block[].class));
        Parameter position = Parameter.arg((String)"position", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        Parameter fixedChunk = Parameter.arg((String)"fixedChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter fixedOffset = Parameter.arg((String)"fixedOffset", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        Parameter variableChunk = Parameter.arg((String)"variableChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter variableOffset = Parameter.arg((String)"variableOffset", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "writeFlat", ParameterizedType.type(Void.TYPE), new Parameter[]{blocks, position, fixedChunk, fixedOffset, variableChunk, variableOffset});
        BytecodeBlock body = methodDefinition.getBody();
        for (ChunkClass chunkClass : chunkClasses) {
            body.append((BytecodeNode)variableOffset.set(BytecodeExpressions.invokeStatic((MethodDefinition)chunkClass.writeFlatChunk(), (BytecodeExpression[])new BytecodeExpression[]{blocks, position, fixedChunk, fixedOffset, variableChunk, variableOffset})));
        }
        body.ret();
    }

    private static MethodDefinition generateWriteFlatChunk(ClassDefinition definition, List<KeyField> keyFields, CallSiteBinder callSiteBinder) {
        Parameter blocks = Parameter.arg((String)"blocks", (ParameterizedType)ParameterizedType.type(Block[].class));
        Parameter position = Parameter.arg((String)"position", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        Parameter fixedChunk = Parameter.arg((String)"fixedChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter fixedOffset = Parameter.arg((String)"fixedOffset", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        Parameter variableChunk = Parameter.arg((String)"variableChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter variableOffset = Parameter.arg((String)"variableOffset", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "writeFlat", ParameterizedType.type(Integer.TYPE), new Parameter[]{blocks, position, fixedChunk, fixedOffset, variableChunk, variableOffset});
        BytecodeBlock body = methodDefinition.getBody();
        for (KeyField keyField : keyFields) {
            BytecodeBlock writeNonNullFlat = new BytecodeBlock().append((BytecodeNode)BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)callSiteBinder.bind(keyField.writeFlatMethod()).getBindingId()), (String)"writeFlat", Void.TYPE, (BytecodeExpression[])new BytecodeExpression[]{blocks.getElement(keyField.index()), position, fixedChunk, BytecodeExpressions.add((BytecodeExpression)fixedOffset, (BytecodeExpression)BytecodeExpressions.constantInt((int)keyField.fieldFixedOffset())), variableChunk, variableOffset}));
            if (keyField.type().isFlatVariableWidth()) {
                writeNonNullFlat.append((BytecodeNode)variableOffset.set(BytecodeExpressions.add((BytecodeExpression)variableOffset, (BytecodeExpression)SqlTypeBytecodeExpression.constantType(callSiteBinder, keyField.type()).invoke("getFlatVariableWidthSize", Integer.TYPE, new BytecodeExpression[]{blocks.getElement(keyField.index()), position}))));
            }
            body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)blocks.getElement(keyField.index()).invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position})).ifTrue((BytecodeNode)fixedChunk.setElement(BytecodeExpressions.add((BytecodeExpression)fixedOffset, (BytecodeExpression)BytecodeExpressions.constantInt((int)keyField.fieldIsNullOffset())), BytecodeExpressions.constantInt((int)1).cast(Byte.TYPE))).ifFalse((BytecodeNode)writeNonNullFlat));
        }
        body.append((BytecodeNode)variableOffset.ret());
        return methodDefinition;
    }

    private static void generateNotDistinctFromMethod(ClassDefinition definition, List<ChunkClass> chunkClasses) {
        Parameter leftFixedChunk = Parameter.arg((String)"leftFixedChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter leftFixedOffset = Parameter.arg((String)"leftFixedOffset", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        Parameter leftVariableChunk = Parameter.arg((String)"leftVariableChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter rightBlocks = Parameter.arg((String)"rightBlocks", (ParameterizedType)ParameterizedType.type(Block[].class));
        Parameter rightPosition = Parameter.arg((String)"rightPosition", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "valueNotDistinctFrom", ParameterizedType.type(Boolean.TYPE), new Parameter[]{leftFixedChunk, leftFixedOffset, leftVariableChunk, rightBlocks, rightPosition});
        BytecodeBlock body = methodDefinition.getBody();
        for (ChunkClass chunkClass : chunkClasses) {
            body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.invokeStatic((MethodDefinition)chunkClass.notDistinctFromMethodChunk(), (BytecodeExpression[])new BytecodeExpression[]{leftFixedChunk, leftFixedOffset, leftVariableChunk, rightBlocks, rightPosition})).ifFalse((BytecodeNode)BytecodeExpressions.constantFalse().ret()));
        }
        body.append((BytecodeNode)BytecodeExpressions.constantTrue().ret());
    }

    private static MethodDefinition generateNotDistinctFromMethodChunk(ClassDefinition definition, List<KeyField> keyFields, CallSiteBinder callSiteBinder) {
        Parameter leftFixedChunk = Parameter.arg((String)"leftFixedChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter leftFixedOffset = Parameter.arg((String)"leftFixedOffset", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        Parameter leftVariableChunk = Parameter.arg((String)"leftVariableChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter rightBlocks = Parameter.arg((String)"rightBlocks", (ParameterizedType)ParameterizedType.type(Block[].class));
        Parameter rightPosition = Parameter.arg((String)"rightPosition", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "valueNotDistinctFrom", ParameterizedType.type(Boolean.TYPE), new Parameter[]{leftFixedChunk, leftFixedOffset, leftVariableChunk, rightBlocks, rightPosition});
        BytecodeBlock body = methodDefinition.getBody();
        for (KeyField keyField : keyFields) {
            MethodDefinition distinctFromMethod = FlatHashStrategyCompiler.generateDistinctFromMethod(definition, keyField, callSiteBinder);
            body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.invokeStatic((MethodDefinition)distinctFromMethod, (BytecodeExpression[])new BytecodeExpression[]{leftFixedChunk, leftFixedOffset, leftVariableChunk, rightBlocks.getElement(keyField.index()), rightPosition})).ifTrue((BytecodeNode)BytecodeExpressions.constantFalse().ret()));
        }
        body.append((BytecodeNode)BytecodeExpressions.constantTrue().ret());
        return methodDefinition;
    }

    private static MethodDefinition generateDistinctFromMethod(ClassDefinition definition, KeyField keyField, CallSiteBinder callSiteBinder) {
        Parameter leftFixedChunk = Parameter.arg((String)"leftFixedChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter leftFixedOffset = Parameter.arg((String)"leftFixedOffset", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        Parameter leftVariableChunk = Parameter.arg((String)"leftVariableChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter rightBlock = Parameter.arg((String)"rightBlock", (ParameterizedType)ParameterizedType.type(Block.class));
        Parameter rightPosition = Parameter.arg((String)"rightPosition", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "valueDistinctFrom" + keyField.index(), ParameterizedType.type(Boolean.TYPE), new Parameter[]{leftFixedChunk, leftFixedOffset, leftVariableChunk, rightBlock, rightPosition});
        BytecodeBlock body = methodDefinition.getBody();
        Scope scope = methodDefinition.getScope();
        Variable leftIsNull = scope.declareVariable("leftIsNull", body, BytecodeExpressions.notEqual((BytecodeExpression)leftFixedChunk.getElement(BytecodeExpressions.add((BytecodeExpression)leftFixedOffset, (BytecodeExpression)BytecodeExpressions.constantInt((int)keyField.fieldIsNullOffset()))).cast(Integer.TYPE), (BytecodeExpression)BytecodeExpressions.constantInt((int)0)));
        Variable rightIsNull = scope.declareVariable("rightIsNull", body, rightBlock.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{rightPosition}));
        body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)leftIsNull).ifTrue((BytecodeNode)BytecodeExpressions.not((BytecodeExpression)rightIsNull).ret()));
        body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)rightIsNull).ifTrue((BytecodeNode)BytecodeExpressions.constantTrue().ret()));
        body.append((BytecodeNode)BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)callSiteBinder.bind(keyField.distinctFlatBlockMethod()).getBindingId()), (String)"distinctFrom", Boolean.TYPE, (BytecodeExpression[])new BytecodeExpression[]{leftFixedChunk, BytecodeExpressions.add((BytecodeExpression)leftFixedOffset, (BytecodeExpression)BytecodeExpressions.constantInt((int)keyField.fieldFixedOffset())), leftVariableChunk, rightBlock, rightPosition}).ret());
        return methodDefinition;
    }

    private static void generateHashBlock(ClassDefinition definition, List<ChunkClass> chunkClasses) {
        Parameter blocks = Parameter.arg((String)"blocks", (ParameterizedType)ParameterizedType.type(Block[].class));
        Parameter position = Parameter.arg((String)"position", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "hash", ParameterizedType.type(Long.TYPE), new Parameter[]{blocks, position});
        BytecodeBlock body = methodDefinition.getBody();
        Scope scope = methodDefinition.getScope();
        Variable result = scope.declareVariable("result", body, BytecodeExpressions.constantLong((long)0L));
        for (ChunkClass chunkClass : chunkClasses) {
            body.append((BytecodeNode)result.set(BytecodeExpressions.invokeStatic((MethodDefinition)chunkClass.hashBlockChunk(), (BytecodeExpression[])new BytecodeExpression[]{blocks, position, result})));
        }
        body.append((BytecodeNode)result.ret());
    }

    private static MethodDefinition generateHashBlockChunk(ClassDefinition definition, List<KeyField> keyFields, CallSiteBinder callSiteBinder) {
        Parameter blocks = Parameter.arg((String)"blocks", (ParameterizedType)ParameterizedType.type(Block[].class));
        Parameter position = Parameter.arg((String)"position", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        Parameter seed = Parameter.arg((String)"seed", (ParameterizedType)ParameterizedType.type(Long.TYPE));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "hashBlocks", ParameterizedType.type(Long.TYPE), new Parameter[]{blocks, position, seed});
        BytecodeBlock body = methodDefinition.getBody();
        Scope scope = methodDefinition.getScope();
        Variable result = scope.declareVariable("result", body, (BytecodeExpression)seed);
        Variable hash = scope.declareVariable(Long.TYPE, "hash");
        Variable block = scope.declareVariable(Block.class, "block");
        for (KeyField keyField : keyFields) {
            body.append((BytecodeNode)block.set(blocks.getElement(keyField.index())));
            body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)block.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position})).ifTrue((BytecodeNode)hash.set(BytecodeExpressions.constantLong((long)0L))).ifFalse((BytecodeNode)hash.set(BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)callSiteBinder.bind(keyField.hashBlockMethod()).getBindingId()), (String)"hash", Long.TYPE, (BytecodeExpression[])new BytecodeExpression[]{block, position}))));
            body.append((BytecodeNode)result.set(BytecodeExpressions.invokeStatic(CombineHashFunction.class, (String)"getHash", Long.TYPE, (BytecodeExpression[])new BytecodeExpression[]{result, hash})));
        }
        body.append((BytecodeNode)result.ret());
        return methodDefinition;
    }

    private static void generateHashBlocksBatched(ClassDefinition definition, List<ChunkClass> chunkClasses) {
        Parameter blocks = Parameter.arg((String)"blocks", (ParameterizedType)ParameterizedType.type(Block[].class));
        Parameter hashes = Parameter.arg((String)"hashes", (ParameterizedType)ParameterizedType.type(long[].class));
        Parameter offset = Parameter.arg((String)"offset", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        Parameter length = Parameter.arg((String)"length", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "hashBlocksBatched", ParameterizedType.type(Void.TYPE), new Parameter[]{blocks, hashes, offset, length});
        BytecodeBlock body = methodDefinition.getBody();
        body.append((BytecodeNode)BytecodeExpressions.invokeStatic(Objects.class, (String)"checkFromIndexSize", Integer.TYPE, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantInt((int)0), length, hashes.length()}).pop());
        BytecodeBlock nonEmptyLength = new BytecodeBlock();
        for (ChunkClass chunkClass : chunkClasses) {
            nonEmptyLength.append((BytecodeNode)BytecodeExpressions.invokeStatic((MethodDefinition)chunkClass.hashBlocksBatchedChunk(), (BytecodeExpression[])new BytecodeExpression[]{blocks, hashes, offset, length}));
        }
        body.append((BytecodeNode)new IfStatement("if (length != 0)", new Object[0]).condition((BytecodeNode)BytecodeExpressions.equal((BytecodeExpression)length, (BytecodeExpression)BytecodeExpressions.constantInt((int)0))).ifFalse((BytecodeNode)nonEmptyLength)).ret();
    }

    private static MethodDefinition generateHashBlocksBatchedChunk(ClassDefinition definition, List<KeyField> keyFields, CallSiteBinder callSiteBinder) {
        Parameter blocks = Parameter.arg((String)"blocks", (ParameterizedType)ParameterizedType.type(Block[].class));
        Parameter hashes = Parameter.arg((String)"hashes", (ParameterizedType)ParameterizedType.type(long[].class));
        Parameter offset = Parameter.arg((String)"offset", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        Parameter length = Parameter.arg((String)"length", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "hashBlocksBatched", ParameterizedType.type(Void.TYPE), new Parameter[]{blocks, hashes, offset, length});
        BytecodeBlock body = methodDefinition.getBody();
        body.append((BytecodeNode)BytecodeExpressions.invokeStatic(Objects.class, (String)"checkFromIndexSize", Integer.TYPE, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantInt((int)0), length, hashes.length()}).pop());
        BytecodeBlock nonEmptyLength = new BytecodeBlock();
        HashMap<Type, MethodDefinition> typeMethods = new HashMap<Type, MethodDefinition>();
        for (KeyField keyField : keyFields) {
            MethodDefinition method;
            if (keyField.index() == 0) {
                method = FlatHashStrategyCompiler.generateHashBlockVectorized(definition, keyField, callSiteBinder);
            } else {
                method = (MethodDefinition)typeMethods.get(keyField.type());
                if (method == null) {
                    method = FlatHashStrategyCompiler.generateHashBlockVectorized(definition, keyField, callSiteBinder);
                    typeMethods.put(keyField.type(), method);
                }
            }
            nonEmptyLength.append((BytecodeNode)BytecodeExpressions.invokeStatic((MethodDefinition)method, (BytecodeExpression[])new BytecodeExpression[]{blocks.getElement(keyField.index()), hashes, offset, length}));
        }
        body.append((BytecodeNode)new IfStatement("if (length != 0)", new Object[0]).condition((BytecodeNode)BytecodeExpressions.equal((BytecodeExpression)length, (BytecodeExpression)BytecodeExpressions.constantInt((int)0))).ifFalse((BytecodeNode)nonEmptyLength)).ret();
        return methodDefinition;
    }

    private static MethodDefinition generateHashBlockVectorized(ClassDefinition definition, KeyField field, CallSiteBinder callSiteBinder) {
        Parameter block = Parameter.arg((String)"block", (ParameterizedType)ParameterizedType.type(Block.class));
        Parameter hashes = Parameter.arg((String)"hashes", (ParameterizedType)ParameterizedType.type(long[].class));
        Parameter offset = Parameter.arg((String)"offset", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        Parameter length = Parameter.arg((String)"length", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "hashBlockVectorized_" + field.index(), ParameterizedType.type(Void.TYPE), new Parameter[]{block, hashes, offset, length});
        Scope scope = methodDefinition.getScope();
        BytecodeBlock body = methodDefinition.getBody();
        Variable index = scope.declareVariable(Integer.TYPE, "index");
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        Variable mayHaveNull = scope.declareVariable(Boolean.TYPE, "mayHaveNull");
        Variable hash = scope.declareVariable(Long.TYPE, "hash");
        body.append((BytecodeNode)position.set(BytecodeExpressions.invokeStatic(Objects.class, (String)"checkFromToIndex", Integer.TYPE, (BytecodeExpression[])new BytecodeExpression[]{offset, BytecodeExpressions.add((BytecodeExpression)offset, (BytecodeExpression)length), block.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0])})));
        body.append((BytecodeNode)BytecodeExpressions.invokeStatic(Objects.class, (String)"checkFromIndexSize", Integer.TYPE, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantInt((int)0), length, hashes.length()}).pop());
        BytecodeExpression computeHashNonNull = BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)callSiteBinder.bind(field.hashBlockMethod()).getBindingId()), (String)"hash", Long.TYPE, (BytecodeExpression[])new BytecodeExpression[]{block, position});
        BytecodeBlock rleHandling = new BytecodeBlock().append((BytecodeNode)new IfStatement("hash = block.isNull(position) ? NULL_HASH_CODE : hash(block, position)", new Object[0]).condition((BytecodeNode)block.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position})).ifTrue((BytecodeNode)hash.set(BytecodeExpressions.constantLong((long)0L))).ifFalse((BytecodeNode)hash.set(computeHashNonNull)));
        if (field.index() == 0) {
            rleHandling.append((BytecodeNode)BytecodeExpressions.invokeStatic(Arrays.class, (String)"fill", Void.TYPE, (BytecodeExpression[])new BytecodeExpression[]{hashes, BytecodeExpressions.constantInt((int)0), length, hash}));
        } else {
            rleHandling.append((BytecodeNode)BytecodeExpressions.invokeStatic(CombineHashFunction.class, (String)"combineAllHashesWithConstant", Void.TYPE, (BytecodeExpression[])new BytecodeExpression[]{hashes, BytecodeExpressions.constantInt((int)0), length, hash}));
        }
        BytecodeExpression setHashExpression = field.index() == 0 ? hashes.setElement((BytecodeExpression)index, (BytecodeExpression)hash) : hashes.setElement((BytecodeExpression)index, BytecodeExpressions.invokeStatic(CombineHashFunction.class, (String)"getHash", Long.TYPE, (BytecodeExpression[])new BytecodeExpression[]{hashes.getElement((BytecodeExpression)index), hash}));
        BytecodeBlock computeHashLoop = new BytecodeBlock().append((BytecodeNode)mayHaveNull.set(block.invoke("mayHaveNull", Boolean.TYPE, new BytecodeExpression[0]))).append((BytecodeNode)new ForLoop("for (int index = 0; index < length; index++)", new Object[0]).initialize((BytecodeNode)index.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)index, (BytecodeExpression)length)).update((BytecodeNode)index.increment()).body((BytecodeNode)new BytecodeBlock().append((BytecodeNode)new IfStatement("if (mayHaveNull && block.isNull(position))", new Object[0]).condition((BytecodeNode)BytecodeExpressions.and((BytecodeExpression)mayHaveNull, (BytecodeExpression)block.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position}))).ifTrue((BytecodeNode)hash.set(BytecodeExpressions.constantLong((long)0L))).ifFalse((BytecodeNode)hash.set(computeHashNonNull))).append((BytecodeNode)setHashExpression).append((BytecodeNode)position.increment())));
        body.append((BytecodeNode)new IfStatement("if (block instanceof RunLengthEncodedBlock)", new Object[0]).condition((BytecodeNode)block.instanceOf(RunLengthEncodedBlock.class)).ifTrue((BytecodeNode)rleHandling).ifFalse((BytecodeNode)computeHashLoop)).ret();
        return methodDefinition;
    }

    private static void generateHashFlat(ClassDefinition definition, List<ChunkClass> chunkClasses) {
        Parameter fixedChunk = Parameter.arg((String)"fixedChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter fixedOffset = Parameter.arg((String)"fixedOffset", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        Parameter variableChunk = Parameter.arg((String)"variableChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "hash", ParameterizedType.type(Long.TYPE), new Parameter[]{fixedChunk, fixedOffset, variableChunk});
        BytecodeBlock body = methodDefinition.getBody();
        Scope scope = methodDefinition.getScope();
        Variable result = scope.declareVariable("result", body, BytecodeExpressions.constantLong((long)0L));
        for (ChunkClass chunkClass : chunkClasses) {
            body.append((BytecodeNode)result.set(BytecodeExpressions.invokeStatic((MethodDefinition)chunkClass.hashFlatChunk(), (BytecodeExpression[])new BytecodeExpression[]{fixedChunk, fixedOffset, variableChunk, result})));
        }
        body.append((BytecodeNode)result.ret());
    }

    private static MethodDefinition generateHashFlatChunk(ClassDefinition definition, List<KeyField> keyFields, CallSiteBinder callSiteBinder) {
        Parameter fixedChunk = Parameter.arg((String)"fixedChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter fixedOffset = Parameter.arg((String)"fixedOffset", (ParameterizedType)ParameterizedType.type(Integer.TYPE));
        Parameter variableChunk = Parameter.arg((String)"variableChunk", (ParameterizedType)ParameterizedType.type(byte[].class));
        Parameter seed = Parameter.arg((String)"seed", (ParameterizedType)ParameterizedType.type(Long.TYPE));
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "hashFlat", ParameterizedType.type(Long.TYPE), new Parameter[]{fixedChunk, fixedOffset, variableChunk, seed});
        BytecodeBlock body = methodDefinition.getBody();
        Scope scope = methodDefinition.getScope();
        Variable result = scope.declareVariable("result", body, (BytecodeExpression)seed);
        Variable hash = scope.declareVariable(Long.TYPE, "hash");
        for (KeyField keyField : keyFields) {
            body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.notEqual((BytecodeExpression)fixedChunk.getElement(BytecodeExpressions.add((BytecodeExpression)fixedOffset, (BytecodeExpression)BytecodeExpressions.constantInt((int)keyField.fieldIsNullOffset()))).cast(Integer.TYPE), (BytecodeExpression)BytecodeExpressions.constantInt((int)0))).ifTrue((BytecodeNode)hash.set(BytecodeExpressions.constantLong((long)0L))).ifFalse((BytecodeNode)hash.set(BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)callSiteBinder.bind(keyField.hashFlatMethod()).getBindingId()), (String)"hash", Long.TYPE, (BytecodeExpression[])new BytecodeExpression[]{fixedChunk, BytecodeExpressions.add((BytecodeExpression)fixedOffset, (BytecodeExpression)BytecodeExpressions.constantInt((int)keyField.fieldFixedOffset())), variableChunk}))));
            body.append((BytecodeNode)result.set(BytecodeExpressions.invokeStatic(CombineHashFunction.class, (String)"getHash", Long.TYPE, (BytecodeExpression[])new BytecodeExpression[]{result, hash})));
        }
        body.append((BytecodeNode)result.ret());
        return methodDefinition;
    }

    private record KeyField(int index, Type type, int fieldIsNullOffset, int fieldFixedOffset, MethodHandle readFlatMethod, MethodHandle writeFlatMethod, MethodHandle distinctFlatBlockMethod, MethodHandle hashFlatMethod, MethodHandle hashBlockMethod) {
    }

    private record ChunkClass(ClassDefinition definition, MethodDefinition getTotalVariableWidth, MethodDefinition readFlatChunk, MethodDefinition writeFlatChunk, MethodDefinition notDistinctFromMethodChunk, MethodDefinition hashBlockChunk, MethodDefinition hashFlatChunk, MethodDefinition hashBlocksBatchedChunk) {
    }
}

