/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.state.LongAndDoubleState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.RemoveInputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DoubleType;

@AggregationFunction(value="avg")
public final class AverageAggregations {
    private AverageAggregations() {
    }

    @InputFunction
    public static void input(@AggregationState LongAndDoubleState state, @SqlType(value="bigint") long value) {
        state.setLong(state.getLong() + 1L);
        state.setDouble(state.getDouble() + (double)value);
    }

    @InputFunction
    public static void input(@AggregationState LongAndDoubleState state, @SqlType(value="double") double value) {
        state.setLong(state.getLong() + 1L);
        state.setDouble(state.getDouble() + value);
    }

    @RemoveInputFunction
    public static boolean removeInput(@AggregationState LongAndDoubleState state, @SqlType(value="bigint") long value) {
        state.setLong(state.getLong() - 1L);
        state.setDouble(state.getDouble() - (double)value);
        return true;
    }

    @RemoveInputFunction
    public static boolean removeInput(@AggregationState LongAndDoubleState state, @SqlType(value="double") double value) {
        double currentValue = state.getDouble();
        if (Double.isFinite(currentValue)) {
            state.setDouble(currentValue - value);
            state.setLong(state.getLong() - 1L);
            return true;
        }
        return false;
    }

    @CombineFunction
    public static void combine(@AggregationState LongAndDoubleState state, @AggregationState LongAndDoubleState otherState) {
        state.setLong(state.getLong() + otherState.getLong());
        state.setDouble(state.getDouble() + otherState.getDouble());
    }

    @OutputFunction(value="double")
    public static void output(@AggregationState LongAndDoubleState state, BlockBuilder out) {
        long count = state.getLong();
        if (count == 0L) {
            out.appendNull();
        } else {
            double value = state.getDouble();
            DoubleType.DOUBLE.writeDouble(out, value / (double)count);
        }
    }
}

