/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.state.LongState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.RemoveInputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.BigintType;

@AggregationFunction(value="count")
@Description(value="Counts the non-null values")
public final class CountColumn {
    private CountColumn() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@AggregationState LongState state, @BlockPosition @SqlType(value="T") ValueBlock block, @BlockIndex int position) {
        state.setValue(state.getValue() + 1L);
    }

    @RemoveInputFunction
    public static boolean removeInput(@AggregationState LongState state, @BlockPosition @SqlType(value="T") ValueBlock block, @BlockIndex int position) {
        state.setValue(state.getValue() - 1L);
        return true;
    }

    @CombineFunction
    public static void combine(@AggregationState LongState state, LongState otherState) {
        state.setValue(state.getValue() + otherState.getValue());
    }

    @OutputFunction(value="BIGINT")
    public static void output(@AggregationState LongState state, BlockBuilder out) {
        BigintType.BIGINT.writeLong(out, state.getValue());
    }
}

