/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.security.SecurityContext;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.EntityKindAndName;
import io.trino.spi.connector.EntityPrivilege;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.security.Identity;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public abstract class ForwardingAccessControl
implements AccessControl {
    public static ForwardingAccessControl of(final Supplier<AccessControl> accessControlSupplier) {
        Objects.requireNonNull(accessControlSupplier, "accessControlSupplier is null");
        return new ForwardingAccessControl(){

            @Override
            protected AccessControl delegate() {
                return Objects.requireNonNull((AccessControl)accessControlSupplier.get(), "accessControlSupplier.get() is null");
            }
        };
    }

    protected abstract AccessControl delegate();

    @Override
    public void checkCanImpersonateUser(Identity identity, String userName) {
        this.delegate().checkCanImpersonateUser(identity, userName);
    }

    @Override
    public void checkCanReadSystemInformation(Identity identity) {
        this.delegate().checkCanReadSystemInformation(identity);
    }

    @Override
    public void checkCanWriteSystemInformation(Identity identity) {
        this.delegate().checkCanWriteSystemInformation(identity);
    }

    @Override
    @Deprecated
    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        this.delegate().checkCanSetUser(principal, userName);
    }

    @Override
    public void checkCanExecuteQuery(Identity identity) {
        this.delegate().checkCanExecuteQuery(identity);
    }

    @Override
    public void checkCanViewQueryOwnedBy(Identity identity, Identity queryOwner) {
        this.delegate().checkCanViewQueryOwnedBy(identity, queryOwner);
    }

    @Override
    public Collection<Identity> filterQueriesOwnedBy(Identity identity, Collection<Identity> queryOwners) {
        return this.delegate().filterQueriesOwnedBy(identity, queryOwners);
    }

    @Override
    public void checkCanKillQueryOwnedBy(Identity identity, Identity queryOwner) {
        this.delegate().checkCanKillQueryOwnedBy(identity, queryOwner);
    }

    @Override
    public void checkCanCreateCatalog(SecurityContext context, String catalog) {
        this.delegate().checkCanCreateCatalog(context, catalog);
    }

    @Override
    public void checkCanDropCatalog(SecurityContext context, String catalog) {
        this.delegate().checkCanDropCatalog(context, catalog);
    }

    @Override
    public Set<String> filterCatalogs(SecurityContext context, Set<String> catalogs) {
        return this.delegate().filterCatalogs(context, catalogs);
    }

    @Override
    public void checkCanCreateSchema(SecurityContext context, CatalogSchemaName schemaName, Map<String, Object> properties) {
        this.delegate().checkCanCreateSchema(context, schemaName, properties);
    }

    @Override
    public void checkCanDropSchema(SecurityContext context, CatalogSchemaName schemaName) {
        this.delegate().checkCanDropSchema(context, schemaName);
    }

    @Override
    public void checkCanRenameSchema(SecurityContext context, CatalogSchemaName schemaName, String newSchemaName) {
        this.delegate().checkCanRenameSchema(context, schemaName, newSchemaName);
    }

    @Override
    public void checkCanSetSchemaAuthorization(SecurityContext context, CatalogSchemaName schemaName, TrinoPrincipal principal) {
        this.delegate().checkCanSetSchemaAuthorization(context, schemaName, principal);
    }

    @Override
    public void checkCanShowSchemas(SecurityContext context, String catalogName) {
        this.delegate().checkCanShowSchemas(context, catalogName);
    }

    @Override
    public Set<String> filterSchemas(SecurityContext context, String catalogName, Set<String> schemaNames) {
        return this.delegate().filterSchemas(context, catalogName, schemaNames);
    }

    @Override
    public void checkCanShowCreateSchema(SecurityContext context, CatalogSchemaName schemaName) {
        this.delegate().checkCanShowCreateSchema(context, schemaName);
    }

    @Override
    public void checkCanShowCreateTable(SecurityContext context, QualifiedObjectName tableName) {
        this.delegate().checkCanShowCreateTable(context, tableName);
    }

    @Override
    public void checkCanCreateTable(SecurityContext context, QualifiedObjectName tableName, Map<String, Object> properties) {
        this.delegate().checkCanCreateTable(context, tableName, properties);
    }

    @Override
    public void checkCanDropTable(SecurityContext context, QualifiedObjectName tableName) {
        this.delegate().checkCanDropTable(context, tableName);
    }

    @Override
    public void checkCanTruncateTable(SecurityContext context, QualifiedObjectName tableName) {
        this.delegate().checkCanTruncateTable(context, tableName);
    }

    @Override
    public void checkCanRenameTable(SecurityContext context, QualifiedObjectName tableName, QualifiedObjectName newTableName) {
        this.delegate().checkCanRenameTable(context, tableName, newTableName);
    }

    @Override
    public void checkCanSetTableProperties(SecurityContext context, QualifiedObjectName tableName, Map<String, Optional<Object>> properties) {
        this.delegate().checkCanSetTableProperties(context, tableName, properties);
    }

    @Override
    public void checkCanSetTableComment(SecurityContext context, QualifiedObjectName tableName) {
        this.delegate().checkCanSetTableComment(context, tableName);
    }

    @Override
    public void checkCanSetViewComment(SecurityContext context, QualifiedObjectName viewName) {
        this.delegate().checkCanSetViewComment(context, viewName);
    }

    @Override
    public void checkCanSetColumnComment(SecurityContext context, QualifiedObjectName tableName) {
        this.delegate().checkCanSetColumnComment(context, tableName);
    }

    @Override
    public void checkCanShowTables(SecurityContext context, CatalogSchemaName schema) {
        this.delegate().checkCanShowTables(context, schema);
    }

    @Override
    public Set<SchemaTableName> filterTables(SecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        return this.delegate().filterTables(context, catalogName, tableNames);
    }

    @Override
    public void checkCanShowColumns(SecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanShowColumns(context, table);
    }

    @Override
    public Map<SchemaTableName, Set<String>> filterColumns(SecurityContext context, String catalogName, Map<SchemaTableName, Set<String>> tableColumns) {
        return this.delegate().filterColumns(context, catalogName, tableColumns);
    }

    @Override
    public void checkCanAddColumns(SecurityContext context, QualifiedObjectName tableName) {
        this.delegate().checkCanAddColumns(context, tableName);
    }

    @Override
    public void checkCanAlterColumn(SecurityContext context, QualifiedObjectName tableName) {
        this.delegate().checkCanAlterColumn(context, tableName);
    }

    @Override
    public void checkCanDropColumn(SecurityContext context, QualifiedObjectName tableName) {
        this.delegate().checkCanDropColumn(context, tableName);
    }

    @Override
    public void checkCanRenameColumn(SecurityContext context, QualifiedObjectName tableName) {
        this.delegate().checkCanRenameColumn(context, tableName);
    }

    @Override
    public void checkCanSetTableAuthorization(SecurityContext context, QualifiedObjectName tableName, TrinoPrincipal principal) {
        this.delegate().checkCanSetTableAuthorization(context, tableName, principal);
    }

    @Override
    public void checkCanInsertIntoTable(SecurityContext context, QualifiedObjectName tableName) {
        this.delegate().checkCanInsertIntoTable(context, tableName);
    }

    @Override
    public void checkCanDeleteFromTable(SecurityContext context, QualifiedObjectName tableName) {
        this.delegate().checkCanDeleteFromTable(context, tableName);
    }

    @Override
    public void checkCanUpdateTableColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> updatedColumnNames) {
        this.delegate().checkCanUpdateTableColumns(context, tableName, updatedColumnNames);
    }

    @Override
    public void checkCanCreateView(SecurityContext context, QualifiedObjectName viewName) {
        this.delegate().checkCanCreateView(context, viewName);
    }

    @Override
    public void checkCanRenameView(SecurityContext context, QualifiedObjectName viewName, QualifiedObjectName newViewName) {
        this.delegate().checkCanRenameView(context, viewName, newViewName);
    }

    @Override
    public void checkCanSetViewAuthorization(SecurityContext context, QualifiedObjectName view, TrinoPrincipal principal) {
        this.delegate().checkCanSetViewAuthorization(context, view, principal);
    }

    @Override
    public void checkCanDropView(SecurityContext context, QualifiedObjectName viewName) {
        this.delegate().checkCanDropView(context, viewName);
    }

    @Override
    public void checkCanCreateViewWithSelectFromColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        this.delegate().checkCanCreateViewWithSelectFromColumns(context, tableName, columnNames);
    }

    @Override
    public void checkCanCreateMaterializedView(SecurityContext context, QualifiedObjectName materializedViewName, Map<String, Object> properties) {
        this.delegate().checkCanCreateMaterializedView(context, materializedViewName, properties);
    }

    @Override
    public void checkCanRefreshMaterializedView(SecurityContext context, QualifiedObjectName materializedViewName) {
        this.delegate().checkCanRefreshMaterializedView(context, materializedViewName);
    }

    @Override
    public void checkCanDropMaterializedView(SecurityContext context, QualifiedObjectName materializedViewName) {
        this.delegate().checkCanDropMaterializedView(context, materializedViewName);
    }

    @Override
    public void checkCanRenameMaterializedView(SecurityContext context, QualifiedObjectName viewName, QualifiedObjectName newViewName) {
        this.delegate().checkCanRenameMaterializedView(context, viewName, newViewName);
    }

    @Override
    public void checkCanSetMaterializedViewProperties(SecurityContext context, QualifiedObjectName materializedViewName, Map<String, Optional<Object>> properties) {
        this.delegate().checkCanSetMaterializedViewProperties(context, materializedViewName, properties);
    }

    @Override
    public void checkCanGrantSchemaPrivilege(SecurityContext context, Privilege privilege, CatalogSchemaName schemaName, TrinoPrincipal grantee, boolean grantOption) {
        this.delegate().checkCanGrantSchemaPrivilege(context, privilege, schemaName, grantee, grantOption);
    }

    @Override
    public void checkCanDenySchemaPrivilege(SecurityContext context, Privilege privilege, CatalogSchemaName schemaName, TrinoPrincipal grantee) {
        this.delegate().checkCanDenySchemaPrivilege(context, privilege, schemaName, grantee);
    }

    @Override
    public void checkCanRevokeSchemaPrivilege(SecurityContext context, Privilege privilege, CatalogSchemaName schemaName, TrinoPrincipal revokee, boolean grantOption) {
        this.delegate().checkCanRevokeSchemaPrivilege(context, privilege, schemaName, revokee, grantOption);
    }

    @Override
    public void checkCanGrantTablePrivilege(SecurityContext context, Privilege privilege, QualifiedObjectName tableName, TrinoPrincipal grantee, boolean grantOption) {
        this.delegate().checkCanGrantTablePrivilege(context, privilege, tableName, grantee, grantOption);
    }

    @Override
    public void checkCanDenyTablePrivilege(SecurityContext context, Privilege privilege, QualifiedObjectName tableName, TrinoPrincipal grantee) {
        this.delegate().checkCanDenyTablePrivilege(context, privilege, tableName, grantee);
    }

    @Override
    public void checkCanRevokeTablePrivilege(SecurityContext context, Privilege privilege, QualifiedObjectName tableName, TrinoPrincipal revokee, boolean grantOption) {
        this.delegate().checkCanRevokeTablePrivilege(context, privilege, tableName, revokee, grantOption);
    }

    @Override
    public void checkCanGrantEntityPrivilege(SecurityContext context, EntityPrivilege privilege, EntityKindAndName entity, TrinoPrincipal grantee, boolean grantOption) {
        this.delegate().checkCanGrantEntityPrivilege(context, privilege, entity, grantee, grantOption);
    }

    @Override
    public void checkCanDenyEntityPrivilege(SecurityContext context, EntityPrivilege privilege, EntityKindAndName entity, TrinoPrincipal grantee) {
        this.delegate().checkCanDenyEntityPrivilege(context, privilege, entity, grantee);
    }

    @Override
    public void checkCanRevokeEntityPrivilege(SecurityContext context, EntityPrivilege privilege, EntityKindAndName entity, TrinoPrincipal revokee, boolean grantOption) {
        this.delegate().checkCanRevokeEntityPrivilege(context, privilege, entity, revokee, grantOption);
    }

    @Override
    public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
        this.delegate().checkCanSetSystemSessionProperty(identity, propertyName);
    }

    @Override
    public void checkCanSetCatalogSessionProperty(SecurityContext context, String catalogName, String propertyName) {
        this.delegate().checkCanSetCatalogSessionProperty(context, catalogName, propertyName);
    }

    @Override
    public void checkCanSelectFromColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        this.delegate().checkCanSelectFromColumns(context, tableName, columnNames);
    }

    @Override
    public void checkCanCreateRole(SecurityContext context, String role, Optional<TrinoPrincipal> grantor, Optional<String> catalogName) {
        this.delegate().checkCanCreateRole(context, role, grantor, catalogName);
    }

    @Override
    public void checkCanDropRole(SecurityContext context, String role, Optional<String> catalogName) {
        this.delegate().checkCanDropRole(context, role, catalogName);
    }

    @Override
    public void checkCanGrantRoles(SecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, Optional<String> catalogName) {
        this.delegate().checkCanGrantRoles(context, roles, grantees, adminOption, grantor, catalogName);
    }

    @Override
    public void checkCanRevokeRoles(SecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, Optional<String> catalogName) {
        this.delegate().checkCanRevokeRoles(context, roles, grantees, adminOption, grantor, catalogName);
    }

    @Override
    public void checkCanSetCatalogRole(SecurityContext context, String role, String catalogName) {
        this.delegate().checkCanSetCatalogRole(context, role, catalogName);
    }

    @Override
    public void checkCanShowRoles(SecurityContext context, Optional<String> catalogName) {
        this.delegate().checkCanShowRoles(context, catalogName);
    }

    @Override
    public void checkCanShowCurrentRoles(SecurityContext context, Optional<String> catalogName) {
        this.delegate().checkCanShowCurrentRoles(context, catalogName);
    }

    @Override
    public void checkCanShowRoleGrants(SecurityContext context, Optional<String> catalogName) {
        this.delegate().checkCanShowRoleGrants(context, catalogName);
    }

    @Override
    public void checkCanExecuteProcedure(SecurityContext context, QualifiedObjectName procedureName) {
        this.delegate().checkCanExecuteProcedure(context, procedureName);
    }

    @Override
    public boolean canExecuteFunction(SecurityContext context, QualifiedObjectName functionName) {
        return this.delegate().canExecuteFunction(context, functionName);
    }

    @Override
    public boolean canCreateViewWithExecuteFunction(SecurityContext context, QualifiedObjectName functionName) {
        return this.delegate().canCreateViewWithExecuteFunction(context, functionName);
    }

    @Override
    public void checkCanExecuteTableProcedure(SecurityContext context, QualifiedObjectName tableName, String procedureName) {
        this.delegate().checkCanExecuteTableProcedure(context, tableName, procedureName);
    }

    @Override
    public void checkCanShowFunctions(SecurityContext context, CatalogSchemaName schema) {
        this.delegate().checkCanShowFunctions(context, schema);
    }

    @Override
    public Set<SchemaFunctionName> filterFunctions(SecurityContext context, String catalogName, Set<SchemaFunctionName> functionNames) {
        return this.delegate().filterFunctions(context, catalogName, functionNames);
    }

    @Override
    public void checkCanCreateFunction(SecurityContext context, QualifiedObjectName functionName) {
        this.delegate().checkCanCreateFunction(context, functionName);
    }

    @Override
    public void checkCanDropFunction(SecurityContext context, QualifiedObjectName functionName) {
        this.delegate().checkCanDropFunction(context, functionName);
    }

    @Override
    public List<ViewExpression> getRowFilters(SecurityContext context, QualifiedObjectName tableName) {
        return this.delegate().getRowFilters(context, tableName);
    }

    @Override
    public Optional<ViewExpression> getColumnMask(SecurityContext context, QualifiedObjectName tableName, String columnName, Type type) {
        return this.delegate().getColumnMask(context, tableName, columnName, type);
    }
}

