/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import com.google.inject.Inject;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.Threads;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.connector.CatalogServiceProvider;
import io.trino.execution.QueryManagerConfig;
import io.trino.metadata.TableFunctionHandle;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.split.BufferingSplitSource;
import io.trino.split.ConnectorAwareSplitSource;
import io.trino.split.SplitSource;
import io.trino.split.TracingSplitSource;
import io.trino.tracing.ScopedSpan;
import io.trino.tracing.TrinoAttributes;
import jakarta.annotation.PreDestroy;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SplitManager {
    private final CatalogServiceProvider<ConnectorSplitManager> splitManagerProvider;
    private final Tracer tracer;
    private final int minScheduleSplitBatchSize;
    private final ExecutorService executorService;
    private final Executor executor;

    @Inject
    public SplitManager(CatalogServiceProvider<ConnectorSplitManager> splitManagerProvider, Tracer tracer, QueryManagerConfig config) {
        this.splitManagerProvider = Objects.requireNonNull(splitManagerProvider, "splitManagerProvider is null");
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        this.minScheduleSplitBatchSize = config.getMinScheduleSplitBatchSize();
        this.executorService = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"splits-manager-callback-%s"));
        this.executor = new BoundedExecutor((Executor)this.executorService, config.getMaxSplitManagerCallbackThreads());
    }

    @PreDestroy
    public void shutdown() {
        this.executorService.shutdown();
    }

    public SplitSource getSplits(Session session, Span parentSpan, TableHandle table, DynamicFilter dynamicFilter, Constraint constraint) {
        ConnectorSplitSource source;
        CatalogHandle catalogHandle = table.getCatalogHandle();
        ConnectorSplitManager splitManager = this.splitManagerProvider.getService(catalogHandle);
        if (!SystemSessionProperties.isAllowPushdownIntoConnectors(session)) {
            dynamicFilter = DynamicFilter.EMPTY;
        }
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        try (ScopedSpan ignore = ScopedSpan.scopedSpan(this.tracer.spanBuilder("SplitManager.getSplits").setParent(Context.current().with((ImplicitContextKeyed)parentSpan)).setAttribute(TrinoAttributes.TABLE, (Object)table.getConnectorHandle().toString()).startSpan());){
            source = splitManager.getSplits(table.getTransaction(), connectorSession, table.getConnectorHandle(), dynamicFilter, constraint);
        }
        SplitSource splitSource = new ConnectorAwareSplitSource(catalogHandle, source);
        Span span = this.splitSourceSpan(parentSpan, catalogHandle);
        if (this.minScheduleSplitBatchSize > 1) {
            splitSource = new TracingSplitSource(splitSource, this.tracer, Optional.empty(), "split-batch");
            splitSource = new BufferingSplitSource(splitSource, this.executor, this.minScheduleSplitBatchSize);
            splitSource = new TracingSplitSource(splitSource, this.tracer, Optional.of(span), "split-buffer");
        } else {
            splitSource = new TracingSplitSource(splitSource, this.tracer, Optional.of(span), "split-batch");
        }
        return splitSource;
    }

    public SplitSource getSplits(Session session, Span parentSpan, TableFunctionHandle function) {
        ConnectorSplitSource source;
        CatalogHandle catalogHandle = function.getCatalogHandle();
        ConnectorSplitManager splitManager = this.splitManagerProvider.getService(catalogHandle);
        try (ScopedSpan ignore = ScopedSpan.scopedSpan(this.tracer.spanBuilder("SplitManager.getSplits").setParent(Context.current().with((ImplicitContextKeyed)parentSpan)).setAttribute(TrinoAttributes.FUNCTION, (Object)function.getFunctionHandle().toString()).startSpan());){
            source = splitManager.getSplits(function.getTransactionHandle(), session.toConnectorSession(catalogHandle), function.getFunctionHandle());
        }
        ConnectorAwareSplitSource splitSource = new ConnectorAwareSplitSource(catalogHandle, source);
        Span span = this.splitSourceSpan(parentSpan, catalogHandle);
        return new TracingSplitSource(splitSource, this.tracer, Optional.of(span), "split-buffer");
    }

    private Span splitSourceSpan(Span parentSpan, CatalogHandle catalogHandle) {
        return this.tracer.spanBuilder("split-source").setParent(Context.current().with((ImplicitContextKeyed)parentSpan)).setAttribute(TrinoAttributes.CATALOG, (Object)catalogHandle.getCatalogName().toString()).startSpan();
    }
}

